/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.tasks;

import com.ibm.ws.jbatch.utility.tasks.BaseWaitTask;
import com.ibm.ws.jbatch.utility.utils.ArgumentRequiredException;
import com.ibm.ws.jbatch.utility.utils.ConsoleWrapper;
import com.ibm.ws.jbatch.utility.utils.TaskIO;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;

public class RestartTask
extends BaseWaitTask<RestartTask> {
    public RestartTask(String scriptName) {
        super("restart", scriptName);
    }

    @Override
    public int handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        this.setTaskIO(new TaskIO(stdin, stdout, stderr));
        this.setTaskArgs(args);
        JobExecution latestJobExecution = this.getPollingBatchRestClient().getLatestJobExecution(this.resolveJobInstanceId());
        JobInstance jobInstance = this.restartJob();
        this.issueJobRestartedMessage(jobInstance);
        this.issueJobInstanceMessage(jobInstance);
        if (this.shouldWaitForTermination()) {
            latestJobExecution = this.getPollingBatchRestClient().waitForNextJobExecution(jobInstance, latestJobExecution);
            Thread shutdownHook = this.shouldAddShutdownHook() ? this.addShutdownHook(jobInstance) : null;
            latestJobExecution = this.waitForTermination(jobInstance, latestJobExecution);
            this.removeShutdownHook(shutdownHook);
            return this.getProcessReturnCode(latestJobExecution);
        }
        return 0;
    }

    protected JobInstance restartJob() throws IOException {
        Long jobInstanceId = this.getJobInstanceId();
        Long jobExecutionId = this.getJobExecutionId();
        if (jobInstanceId != null) {
            return this.getBatchRestClient().restartJobInstance(jobInstanceId, this.getJobProperties());
        }
        if (jobExecutionId != null) {
            return this.getBatchRestClient().restartJobExecution(jobExecutionId, this.getJobProperties());
        }
        throw new ArgumentRequiredException("--jobInstanceId or --jobExecutionId");
    }

    protected Long getJobExecutionId() {
        return this.getTaskArgs().getLongValue("--jobExecutionId", null);
    }

    protected Long getJobInstanceId() {
        return this.getTaskArgs().getLongValue("--jobInstanceId", null);
    }

    protected long resolveJobInstanceId() throws IOException {
        Long jobInstanceId = this.getJobInstanceId();
        Long jobExecutionId = this.getJobExecutionId();
        if (jobInstanceId != null) {
            return jobInstanceId;
        }
        if (jobExecutionId != null) {
            return this.getBatchRestClient().getJobInstanceForJobExecution(jobExecutionId).getInstanceId();
        }
        throw new ArgumentRequiredException("--jobInstanceId or --jobExecutionId");
    }

    protected Properties getJobProperties() throws IOException {
        return this.getTaskArgs().getJobParameters();
    }
}

