/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context.navigate;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;

public class MessageLookup<T>
implements ContextDataLookupFunction<MessageContext, T> {
    private final Class<T> messageType;

    public MessageLookup(@Nonnull @ParameterName(name="type") Class<T> type) {
        this.messageType = (Class)Constraint.isNotNull(type, (String)"Message type cannot be null");
    }

    @Nullable
    public T apply(@Nullable MessageContext input) {
        if (input != null && this.messageType.isInstance(input.getMessage())) {
            return (T)input.getMessage();
        }
        return null;
    }
}

