/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCErrorCode;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCException;
import io.openliberty.mcp.internal.requests.ExecutionRequestId;
import io.openliberty.mcp.internal.requests.McpRequestId;
import io.openliberty.mcp.messaging.Cancellation;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ApplicationScoped
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpConnectionTracker {
    private final ConcurrentMap<McpRequestId, Cancellation> ongoingRequests = new ConcurrentHashMap<McpRequestId, Cancellation>();
    static final long serialVersionUID = -33432735655313260L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void deregisterOngoingRequest(ExecutionRequestId id) {
        this.ongoingRequests.remove(id.id());
    }

    public void registerOngoingRequest(ExecutionRequestId id, Cancellation cancellation) {
        Cancellation previous = this.ongoingRequests.putIfAbsent(id.id(), cancellation);
        if (previous != null) {
            throw new JSONRPCException(JSONRPCErrorCode.INVALID_PARAMS, "A request with id " + String.valueOf(id.id()) + " is already in progress");
        }
    }

    public boolean isOngoingRequest(ExecutionRequestId id) {
        return this.ongoingRequests.containsKey(id.id());
    }

    public Cancellation getOngoingRequestCancellation(ExecutionRequestId id) {
        return (Cancellation)this.ongoingRequests.get(id.id());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.McpConnectionTracker", McpConnectionTracker.class, (String)"MCP", null);
    }
}

