/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.registries;

import java.time.Duration;
import java.util.Objects;
import org.dataloader.DataLoader;

@FunctionalInterface
public interface DispatchPredicate {
    public boolean test(String var1, DataLoader<?, ?> var2);

    default public DispatchPredicate and(DispatchPredicate other) {
        Objects.requireNonNull(other);
        return (k, dl) -> this.test(k, dl) && other.test(k, dl);
    }

    default public DispatchPredicate negate() {
        return (k, dl) -> !this.test(k, dl);
    }

    default public DispatchPredicate or(DispatchPredicate other) {
        Objects.requireNonNull(other);
        return (k, dl) -> this.test(k, dl) || other.test(k, dl);
    }

    public static DispatchPredicate dispatchIfLongerThan(Duration duration) {
        return (dataLoaderKey, dataLoader) -> {
            int i = dataLoader.getTimeSinceDispatch().compareTo(duration);
            return i > 0;
        };
    }

    public static DispatchPredicate dispatchIfDepthGreaterThan(int depth) {
        return (dataLoaderKey, dataLoader) -> dataLoader.dispatchDepth() > depth;
    }
}

