/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.utils.SocialTaiRequest;
import com.ibm.ws.security.social.internal.utils.SocialUtil;
import com.ibm.ws.security.social.tai.SocialLoginTAI;
import com.ibm.ws.security.social.web.utils.SocialWebUtils;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TAIRequestHelper {
    private static TraceComponent tc = Tr.register(TAIRequestHelper.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    SocialWebUtils webUtils = new SocialWebUtils();
    static final long serialVersionUID = 5721307317960750323L;

    public SocialTaiRequest createSocialTaiRequestAndSetRequestAttribute(HttpServletRequest request) {
        SocialTaiRequest socialTaiRequest = new SocialTaiRequest(request);
        request.setAttribute("SocialTaiRequest", (Object)socialTaiRequest);
        return socialTaiRequest;
    }

    public boolean requestShouldBeHandledByTAI(HttpServletRequest request, SocialTaiRequest socialTaiRequest) {
        if (this.isJmxConnectorRequest(request)) {
            return false;
        }
        String loginHint = this.webUtils.getLoginHint(request);
        socialTaiRequest = this.setSocialTaiRequestConfigInfo(request, loginHint, socialTaiRequest);
        return socialTaiRequest.hasServices();
    }

    @FFDCIgnore(value={SocialLoginException.class})
    public boolean requestShouldBeHandledByTAI(HttpServletRequest request, SocialTaiRequest socialTaiRequest, boolean beforeTAI) {
        if (this.requestShouldBeHandledByTAI(request, socialTaiRequest)) {
            if (beforeTAI) {
                SocialLoginConfig clientConfig;
                block7: {
                    clientConfig = null;
                    try {
                        clientConfig = socialTaiRequest.getTheOnlySocialLoginConfig();
                    }
                    catch (SocialLoginException e) {
                        if (!tc.isDebugEnabled()) break block7;
                        Tr.debug((TraceComponent)tc, (String)("A unique social login config wasn't found for this request. Exception was " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
                if (clientConfig != null) {
                    boolean useAccessToken = SocialUtil.useAccessTokenFromRequest(clientConfig);
                    if (useAccessToken) {
                        request.setAttribute("SocialTaiBeforeSSORequest", (Object)true);
                    }
                    return useAccessToken;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    boolean isJmxConnectorRequest(HttpServletRequest request) {
        String ctxPath = request.getContextPath();
        return "/IBMJMXConnectorREST".equals(ctxPath);
    }

    SocialTaiRequest setSocialTaiRequestConfigInfo(HttpServletRequest request, String loginHintParameter, SocialTaiRequest socialTaiRequest) {
        if (loginHintParameter == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Login hint parameter not provided, so will set generic config information for SocialTaiRequest object", (Object[])new Object[0]);
            }
            return this.setGenericAndFilteredConfigTaiRequestInfo(request, socialTaiRequest);
        }
        return this.setSpecificConfigTaiRequestInfo(request, loginHintParameter, socialTaiRequest);
    }

    SocialTaiRequest setGenericAndFilteredConfigTaiRequestInfo(HttpServletRequest request, SocialTaiRequest socialTaiRequest) {
        if (socialTaiRequest == null) {
            socialTaiRequest = this.createSocialTaiRequestAndSetRequestAttribute(request);
        }
        Iterator<SocialLoginConfig> services = this.getConfigServices();
        return this.setGenericAndFilteredConfigTaiRequestInfoFromConfigServices(request, socialTaiRequest, services);
    }

    SocialTaiRequest setGenericAndFilteredConfigTaiRequestInfoFromConfigServices(HttpServletRequest request, SocialTaiRequest socialTaiRequest, Iterator<SocialLoginConfig> services) {
        if (services == null) {
            return socialTaiRequest;
        }
        if (socialTaiRequest == null) {
            socialTaiRequest = this.createSocialTaiRequestAndSetRequestAttribute(request);
        }
        while (services.hasNext()) {
            SocialLoginConfig socialLoginConfig = services.next();
            AuthenticationFilter authFilter = socialLoginConfig.getAuthFilter();
            if (authFilter != null) {
                if (!authFilter.isAccepted(request)) continue;
                socialTaiRequest.addFilteredConfig(socialLoginConfig);
                continue;
            }
            socialTaiRequest.addGenericConfig(socialLoginConfig);
        }
        return socialTaiRequest;
    }

    SocialTaiRequest setSpecificConfigTaiRequestInfo(HttpServletRequest request, String loginHintParam, SocialTaiRequest socialTaiRequest) {
        SocialLoginConfig config;
        if (socialTaiRequest == null) {
            socialTaiRequest = this.createSocialTaiRequestAndSetRequestAttribute(request);
        }
        if ((config = this.getConfigAssociatedWithRequestAndId(request, this.getConfigIdFromLoginHintParam(loginHintParam))) == null) {
            SocialLoginException socialLoginException = new SocialLoginException("SOCIAL_LOGIN_NO_SUCH_PROVIDER", null, new Object[]{loginHintParam});
            socialTaiRequest.setTaiException(socialLoginException);
        } else {
            socialTaiRequest.setSpecifiedConfig(config);
        }
        return socialTaiRequest;
    }

    String getConfigIdFromLoginHintParam(String loginHintParam) {
        return SocialLoginTAI.getConfigIdFromObscuredId(loginHintParam);
    }

    SocialLoginConfig getConfigAssociatedWithRequestAndId(HttpServletRequest request, String configId) {
        SocialLoginConfig socialLoginConfig = this.getConfig(configId);
        if (!this.configAuthFilterMatchesRequest(request, socialLoginConfig)) {
            socialLoginConfig = null;
        }
        return socialLoginConfig;
    }

    Iterator<SocialLoginConfig> getConfigServices() {
        return SocialLoginTAI.socialLoginConfigRef.getServices();
    }

    SocialLoginConfig getConfig(String configId) {
        return SocialLoginTAI.getSocialLoginConfig(configId);
    }

    boolean configAuthFilterMatchesRequest(HttpServletRequest request, SocialLoginConfig config) {
        if (config == null) {
            return false;
        }
        AuthenticationFilter authFilter = config.getAuthFilter();
        return authFilter == null || authFilter.isAccepted(request);
    }
}

