/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.oauth.core.api.OAuthResult;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OauthConsentStore;
import com.ibm.ws.security.oauth20.form.FormRenderer;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.BoundedConsentCache;
import com.ibm.ws.security.oauth20.util.ConsentCacheKey;
import com.ibm.ws.security.oauth20.util.Nonce;
import com.ibm.ws.security.oauth20.util.TemplateRetriever;
import com.ibm.ws.security.oauth20.web.Prompt;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Consent {
    private static TraceComponent tc = Tr.register(Consent.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static final Pattern FORWARD_TEMPLATE_PATTERN = Pattern.compile("\\{(/[\\w-/]+)\\}(/.+)");
    public static final String PARAM_AUTHZ_FORM_TEMPLATE = "oauth20.authorization.form.template";
    private static final String ATTR_CONSENT_CACHE = "consentCache";
    private static final String ATTR_NONCE = "consentNonce";
    private static final String ATTR_RESOURCE = "consentResource";
    private static final String ATTR_OAUTH_CLIENT = "oauthClient";
    public static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    static final long serialVersionUID = 5742476363057045229L;

    protected void handleConsent(OAuth20Provider provider, HttpServletRequest request, Prompt prompt, String clientId) {
        if (prompt.hasPrompt() && !prompt.hasConsent()) {
            String redirectUri = request.getParameter("redirect_uri");
            String resourceId = request.getParameter("resource");
            String scopeString = request.getParameter("scope");
            String[] scope = this.getScope(scopeString);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caching consent response for scopes: " + scopeString), (Object[])new Object[0]);
            }
            int keyLifetime = (int)provider.getConsentCacheEntryLifetime();
            if (provider.isLocalStoreUsed()) {
                BoundedConsentCache consentCache = this.getConsentCacheFromSession(request, provider);
                for (String s : scope) {
                    ConsentCacheKey newKey = new ConsentCacheKey(clientId, redirectUri, scopeString, resourceId, keyLifetime);
                    if (consentCache.contains(newKey)) continue;
                    consentCache.put(newKey);
                }
                request.getSession().setAttribute(ATTR_CONSENT_CACHE, (Object)consentCache);
            } else {
                OauthConsentStore consentStore = provider.getConsentCache();
                consentStore.addConsent(clientId, request.getUserPrincipal().getName(), scopeString, resourceId, provider.getID(), keyLifetime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCachedAndValid(OAuthResult oauthResult, OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) {
        if (oauthResult == null) {
            return false;
        }
        String[] scopes = null;
        if (oauthResult.getAttributeList() != null) {
            scopes = oauthResult.getAttributeList().getAttributeValuesByName("scope");
        }
        if (scopes == null || scopes.length == 0) {
            return false;
        }
        String clientId = oauthResult.getAttributeList().getAttributeValueByName("client_id");
        String redirectUri = oauthResult.getAttributeList().getAttributeValueByName("redirect_uri");
        String resourceId = oauthResult.getAttributeList().getAttributeValueByName("resource");
        int keyLifetime = (int)provider.getConsentCacheEntryLifetime();
        boolean isValid = true;
        if (provider.isLocalStoreUsed()) {
            BoundedConsentCache consentCache = this.getConsentCacheFromSession(request, provider);
            for (String scope : scopes) {
                ConsentCacheKey consentCacheKey = new ConsentCacheKey(clientId, redirectUri, scope, resourceId, keyLifetime);
                BoundedConsentCache boundedConsentCache = consentCache;
                synchronized (boundedConsentCache) {
                    ConsentCacheKey cacheKey = consentCache.get(consentCacheKey);
                    isValid = this.isCacheKeyValid(consentCache, cacheKey, scope, keyLifetime);
                    if (!isValid) {
                        consentCache.remove(consentCacheKey);
                        isValid = false;
                    }
                }
            }
            request.getSession().setAttribute(ATTR_CONSENT_CACHE, (Object)consentCache);
        } else {
            OauthConsentStore consentStore = provider.getConsentCache();
            isValid = consentStore.validateConsent(clientId, request.getUserPrincipal().getName(), provider.getID(), scopes, resourceId);
        }
        return isValid;
    }

    public boolean isCacheKeyValid(BoundedConsentCache consentCache, ConsentCacheKey consentCacheKey, String scope, int keyLifetime) {
        if (consentCacheKey == null) {
            return false;
        }
        return consentCacheKey.isValid() && consentCacheKey.getLifetime() == keyLifetime;
    }

    public BoundedConsentCache getConsentCacheFromSession(HttpServletRequest request, OAuth20Provider provider) {
        int cacheCapacity = (int)provider.getConsentCacheSize();
        BoundedConsentCache consentCache = (BoundedConsentCache)request.getSession().getAttribute(ATTR_CONSENT_CACHE);
        if (consentCache == null) {
            consentCache = new BoundedConsentCache(cacheCapacity);
        } else if (cacheCapacity != consentCache.getCapacity()) {
            consentCache.updateCapacity(cacheCapacity);
        }
        return consentCache;
    }

    public void renderConsentForm(HttpServletRequest request, HttpServletResponse response, OAuth20Provider provider, String clientId, Nonce nonce, AttributeList attributes, ServletContext servletContext) throws IOException, ServletException, OidcServerException {
        this.renderConsentForm(request, response, provider, clientId, nonce, attributes, servletContext, null);
    }

    protected void renderConsentForm(HttpServletRequest request, HttpServletResponse response, OAuth20Provider provider, String clientId, Nonce nonce, AttributeList attributes, ServletContext servletContext, FormRenderer renderer) throws IOException, ServletException, OidcServerException {
        byte[] defaultAuthorizationFormTemplatecontent;
        OidcBaseClient client = provider.getClientProvider().get(clientId);
        String templateUrl = provider.getAuthorizationFormTemplate();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("templateUrl from configuration is " + templateUrl), (Object[])new Object[0]);
        }
        boolean useDefaultTemplateValue = (defaultAuthorizationFormTemplatecontent = provider.getDefaultAuthorizationFormTemplateContent()) != null;
        Matcher m = FORWARD_TEMPLATE_PATTERN.matcher(templateUrl);
        if (m.matches()) {
            String contextPath = m.group(1);
            String path = m.group(2);
            request.setAttribute(ATTR_OAUTH_CLIENT, (Object)client);
            request.setAttribute(ATTR_NONCE, (Object)nonce);
            RequestDispatcher dispatcher = this.getDispatcher(servletContext, contextPath, path);
            if (dispatcher != null) {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                Tr.error((TraceComponent)tc, (String)"security.oauth20.endpoint.template.forward.error", (Object[])new Object[]{PARAM_AUTHZ_FORM_TEMPLATE, contextPath, path});
            }
        } else {
            templateUrl = useDefaultTemplateValue ? null : TemplateRetriever.normallizeTemplateUrl(request, templateUrl);
            String acceptLanguage = request.getHeader(HEADER_ACCEPT_LANGUAGE);
            if (renderer == null) {
                renderer = new FormRenderer();
            }
            String contextPath = request.getContextPath();
            String authorizationUrl = request.getRequestURL().toString();
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private, max-age=0");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            renderer.renderForm(client, templateUrl, contextPath, authorizationUrl, nonce, attributes, acceptLanguage, response, defaultAuthorizationFormTemplatecontent);
        }
    }

    private RequestDispatcher getDispatcher(ServletContext servletContext, String contextPath, String path) {
        RequestDispatcher retVal = null;
        ServletContext ctx = servletContext.getContext(contextPath);
        if (ctx != null) {
            retVal = ctx.getRequestDispatcher(path);
        }
        return retVal;
    }

    protected String[] getScope(String scopeString) {
        String[] scope = null;
        if (scopeString != null) {
            scope = scopeString.split(" ");
        }
        return scope;
    }

    public void handleNonceError(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isNonceExpired(request)) {
            response.sendError(408);
        } else {
            response.sendError(500);
        }
    }

    public boolean isNonceValid(HttpServletRequest request, String requestNonce) {
        Nonce sessionNonce = this.getSessionNonce(request);
        if (sessionNonce != null) {
            return sessionNonce.isValid(requestNonce);
        }
        return false;
    }

    boolean isNonceExpired(HttpServletRequest request) {
        Nonce sessionNonce = this.getSessionNonce(request);
        if (sessionNonce != null) {
            return sessionNonce.isExpired();
        }
        return false;
    }

    public Nonce setNonce(HttpServletRequest request) {
        Nonce nonce = Nonce.getInstance();
        request.getSession(true).setAttribute(ATTR_NONCE, (Object)nonce);
        request.setAttribute(ATTR_NONCE, (Object)nonce.getValue());
        return nonce;
    }

    private Nonce getSessionNonce(HttpServletRequest request) {
        Nonce sessionNonce = (Nonce)request.getSession().getAttribute(ATTR_NONCE);
        return sessionNonce;
    }
}

