/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.common.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.DebugUtils;
import com.ibm.ws.wsat.common.impl.WSATCoordinator;
import com.ibm.ws.wsat.common.impl.WSATEndpoint;
import com.ibm.ws.wsat.common.impl.WSATParticipantState;
import com.ibm.ws.wsat.common.impl.WSATTransaction;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSATParticipant
extends WSATEndpoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent TC = Tr.register(WSATParticipant.class, (String)"WSAT");
    private final String globalId;
    private final String participantId;
    private transient WSATParticipantState state = WSATParticipantState.ACTIVE;
    private transient WSATCoordinator coordinator;

    @Trivial
    public WSATParticipant(String tranId, String partId, EndpointReferenceType epr) {
        super(epr);
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"WSATParticipant:\nglobalId:\n{0}\nparticipantId:\n{1}\nEPR:\n{2}", (Object[])new Object[]{tranId, partId, DebugUtils.printEPR(epr)});
        }
        this.globalId = tranId;
        this.participantId = partId;
    }

    @Trivial
    public String getId() {
        return this.participantId;
    }

    @Trivial
    public String getGlobalId() {
        return this.globalId;
    }

    @Trivial
    public WSATCoordinator getCoordinator() {
        return this.coordinator;
    }

    @Trivial
    public void setCoordinator(WSATCoordinator coord) {
        this.coordinator = coord;
    }

    public synchronized void setState(WSATParticipantState newState) {
        this.state = newState;
    }

    @Trivial
    public synchronized void setResponse(WSATParticipantState newState) {
        if (this.state != WSATParticipantState.ABORTED) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)("Set response from " + (Object)((Object)this.state) + " to " + (Object)((Object)newState)), (Object[])new Object[0]);
            }
            this.state = newState;
        } else if (TC.isDebugEnabled() && newState != WSATParticipantState.ABORTED) {
            Tr.debug((TraceComponent)TC, (String)("Not overriding " + (Object)((Object)WSATParticipantState.ABORTED) + " with " + (Object)((Object)newState)), (Object[])new Object[0]);
        }
        this.notifyAll();
    }

    @Trivial
    @ManualTrace
    public synchronized WSATParticipantState waitResponse(long timeoutMills, WSATParticipantState ... responses) {
        WSATParticipantState ret;
        if (TC.isEntryEnabled()) {
            Tr.entry((TraceComponent)TC, (String)"waitResponse", (Object[])new Object[]{this, timeoutMills, responses});
        }
        List<WSATParticipantState> responseList = Arrays.asList(responses);
        if (timeoutMills <= 0L) {
            while (!responseList.contains((Object)this.state)) {
                if (TC.isDebugEnabled()) {
                    Tr.debug((TraceComponent)TC, (String)("Waiting 1 second for state [" + (Object)((Object)this.state) + "] to be one of " + Arrays.toString((Object[])responses)), (Object[])new Object[0]);
                }
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.wsat.common.impl.WSATParticipant", (String)"123", (Object)this, (Object[])new Object[]{timeoutMills, responses});
                }
            }
        } else {
            Instant expiry = Instant.now().plusMillis(timeoutMills);
            while (Instant.now().compareTo(expiry) < 0 && !responseList.contains((Object)this.state)) {
                long waitTime = expiry.minusMillis(Instant.now().toEpochMilli()).toEpochMilli();
                if (TC.isDebugEnabled()) {
                    Tr.debug((TraceComponent)TC, (String)("Waiting " + waitTime + " milliseconds for state [" + (Object)((Object)this.state) + "] to be one of " + Arrays.toString((Object[])responses)), (Object[])new Object[0]);
                }
                try {
                    if (waitTime > 0L) {
                        this.wait(waitTime);
                    }
                    break;
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.wsat.common.impl.WSATParticipant", (String)"139", (Object)this, (Object[])new Object[]{timeoutMills, responses});
                }
            }
        }
        WSATParticipantState wSATParticipantState = ret = responseList.contains((Object)this.state) ? this.state : WSATParticipantState.TIMEOUT;
        if (TC.isEntryEnabled()) {
            Tr.exit((TraceComponent)TC, (String)"waitResponse", (Object)((Object)ret));
        }
        return ret;
    }

    public void remove() {
        WSATTransaction tran = WSATTransaction.getCoordTran(this.globalId);
        if (tran != null) {
            tran.removeParticipant(this.participantId);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof WSATParticipant) {
            WSATParticipant otherPart = (WSATParticipant)other;
            return this.globalId.equals(otherPart.globalId) && this.participantId.equals(otherPart.participantId);
        }
        return false;
    }

    public int hashCode() {
        return this.globalId.hashCode() * 31 + this.participantId.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append(": ").append(this.globalId).append("/").append(this.participantId).append(" (").append((Object)this.state).append(")");
        if (this.globalId != null) {
            sb.append(" ").append(Integer.toHexString(this.hashCode()));
        }
        return sb.toString();
    }

    public WSATParticipantState getState() {
        return this.state;
    }
}

