/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.sp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContextBuilder;
import com.ibm.ws.security.saml.sso20.internal.utils.ForwardRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.InitialRequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import com.ibm.ws.security.saml.sso20.metadata.AcsDOMMetadataProvider;
import com.ibm.wsspi.security.tai.TAIResult;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.joda.time.DateTime;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnRequestMarshaller;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.Signer;
import org.opensaml.xmlsec.signature.support.SignerProvider;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Solicited {
    public static final TraceComponent tc = Tr.register(Solicited.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    SsoSamlService ssoService = null;
    InitialRequestUtil irUtil = new InitialRequestUtil();
    static final long serialVersionUID = -2689280960184047529L;

    public Solicited(SsoSamlService service) {
        this.ssoService = service;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Solicited(" + service.getProviderId() + ")"), (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={SamlException.class})
    public TAIResult sendAuthRequestToIdp(HttpServletRequest req, HttpServletResponse resp) throws WebTrustAssociationFailedException, SamlException {
        BasicMessageContext<?, ?> basicMsgCtx = BasicMessageContextBuilder.getInstance().buildIdp(req, resp, this.ssoService);
        String idpUrl = this.handleIdpMetadataAndLoginUrl(basicMsgCtx);
        if (this.ssoService.getConfig() != null && idpUrl != null && this.ssoService.getConfig().isHttpsRequired() && !idpUrl.startsWith("https")) {
            throw new SamlException("SAML20_IDP_PROTOCOL_NOT_HTTPS", null, new Object[]{idpUrl});
        }
        String shortRelayState = SamlUtil.generateRandom();
        HttpRequestInfo cachingRequestInfo = new HttpRequestInfo(req);
        AuthnRequest authnRequest = this.buildAuthnRequest(cachingRequestInfo.getInResponseToId(), req, basicMsgCtx);
        String strAuthnRequest = "";
        if (basicMsgCtx.getSsoConfig().isAuthnRequestsSigned()) {
            this.signAuthnRequest((SAMLObject)authnRequest, RequestUtil.getSigningCredential(this.ssoService));
        }
        strAuthnRequest = this.getAuthnRequestString(authnRequest);
        String relayState = "sp_initial_" + shortRelayState;
        RequestUtil.cacheRequestInfo(shortRelayState, this.ssoService, cachingRequestInfo);
        if (!this.ssoService.getConfig().isDisableInitialRequestCookie()) {
            this.irUtil.handleSerializingInitialRequest(req, resp, "sp_initial_", shortRelayState, cachingRequestInfo, this.ssoService);
        }
        TAIResult result = this.postIdp(req, resp, strAuthnRequest, relayState, idpUrl, cachingRequestInfo);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    String handleIdpMetadataAndLoginUrl(BasicMessageContext<?, ?> basicMsgCtx) throws SamlException {
        String idpUrl;
        block11: {
            idpUrl = null;
            AcsDOMMetadataProvider metadataProvider = basicMsgCtx.getMetadataProvider();
            if (metadataProvider == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("idp metadata file :" + basicMsgCtx.getSsoConfig().getIdpMetadata()), (Object[])new Object[0]);
                }
                SsoConfig ssoConfig = this.ssoService.getConfig();
                String idpMetadataFile = ssoConfig.getIdpMetadata();
                String providerId = this.ssoService.getProviderId();
                if (idpMetadataFile == null || idpMetadataFile.isEmpty()) {
                    throw new SamlException("SAML20_NO_IDP_URL_OR_METADATA", null, new Object[]{providerId});
                }
                throw new SamlException("SAML20_NO_IDP_URL_ERROR", null, new Object[]{idpMetadataFile, providerId});
            }
            EntityDescriptor metadata2 = null;
            String entityID = metadataProvider.getEntityId();
            try {
                CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
                metadata2 = metadataProvider.resolveSingle(criteriaSet);
                if (metadata2 != null) {
                    EntityDescriptor entityDescriptor = metadata2;
                    String idpEntityId = entityDescriptor.getEntityID();
                    IDPSSODescriptor ssoDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
                    if (ssoDescriptor != null) {
                        List list = ssoDescriptor.getSingleSignOnServices();
                        for (SingleSignOnService ssoService : list) {
                            if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(ssoService.getBinding())) continue;
                            basicMsgCtx.setPeerEntityEndpoint((Endpoint)ssoService);
                            idpUrl = ssoService.getLocation();
                            break;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("idpLogin url:" + idpUrl + "(" + "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST" + ")"), (Object[])new Object[0]);
                        }
                        break block11;
                    }
                    SsoConfig ssoConfig = this.ssoService.getConfig();
                    String idpMetadataFile = ssoConfig.getIdpMetadata();
                    String providerId = this.ssoService.getProviderId();
                    throw new SamlException("SAML20_IDP_METADATA_PARSE_ERROR", null, new Object[]{idpMetadataFile, providerId, "No IDPSSODescriptor"});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR: metadata is not an EntityDescriptor", (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("idp metadata file :" + basicMsgCtx.getSsoConfig().getIdpMetadata()), (Object[])new Object[0]);
                }
                SsoConfig ssoConfig = this.ssoService.getConfig();
                String idpMetadaFile = ssoConfig.getIdpMetadata();
                String providerId = this.ssoService.getProviderId();
                throw new SamlException("SAML20_NO_IDP_URL_ERROR", null, new Object[]{idpMetadaFile, providerId});
            }
            catch (ResolverException ssoConfig) {
                void e;
                FFDCFilter.processException((Throwable)ssoConfig, (String)"com.ibm.ws.security.saml.sso20.sp.Solicited", (String)"227", (Object)this, (Object[])new Object[]{basicMsgCtx});
                throw new SamlException((Exception)e);
            }
        }
        return idpUrl;
    }

    AuthnRequest buildAuthnRequest(String inResponseToId, HttpServletRequest req, BasicMessageContext<?, ?> basicMsgCtx) {
        SsoConfig samlConfig = this.ssoService.getConfig();
        AuthnRequestBuilder arBuilder = new AuthnRequestBuilder();
        AuthnRequest request = arBuilder.buildObject();
        request.setID(inResponseToId);
        String acsEndpointUrl = RequestUtil.getAcsUrl(req, "/ibm/saml20/", this.ssoService.getProviderId(), this.ssoService.getConfig());
        request.setAssertionConsumerServiceURL(acsEndpointUrl);
        request.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        request.setVersion(SAMLVersion.VERSION_20);
        request.setForceAuthn(Boolean.valueOf(samlConfig.isForceAuthn()));
        request.setIsPassive(Boolean.valueOf(samlConfig.isPassive()));
        request.setNameIDPolicy(this.buildNameIdPolicy(samlConfig));
        String entityUrl = RequestUtil.getEntityUrl(req, "/ibm/saml20/", this.ssoService.getProviderId(), this.ssoService.getConfig());
        request.setIssuer(this.getIssuer(entityUrl));
        request.setIssueInstant(new DateTime());
        request.setDestination(basicMsgCtx.getPeerEntityEndpoint().getLocation());
        RequestedAuthnContext requestedAuthnContext = this.buildRequestedAuthnContext();
        if (requestedAuthnContext != null) {
            request.setRequestedAuthnContext(requestedAuthnContext);
        }
        return request;
    }

    RequestedAuthnContext buildRequestedAuthnContext() {
        RequestedAuthnContext requestedAuthnContext = null;
        SsoConfig ssoConfig = this.ssoService.getConfig();
        String[] authnContextClassRefs = ssoConfig.getAuthnContextClassRef();
        if (authnContextClassRefs != null && authnContextClassRefs.length > 0) {
            RequestedAuthnContextBuilder requestedAuthnContextBuilder = new RequestedAuthnContextBuilder();
            requestedAuthnContext = requestedAuthnContextBuilder.buildObject();
            this.addAuthnContextClassRef(requestedAuthnContext, authnContextClassRefs);
            requestedAuthnContext.setComparison(this.getAuthnContextComparisonTypeEnumeration(ssoConfig.getAuthnContextComparisonType()));
        }
        return requestedAuthnContext;
    }

    AuthnContextComparisonTypeEnumeration getAuthnContextComparisonTypeEnumeration(String authnContextComparisonType) {
        if ("exact".equals(authnContextComparisonType)) {
            return AuthnContextComparisonTypeEnumeration.EXACT;
        }
        if ("minimum".equals(authnContextComparisonType)) {
            return AuthnContextComparisonTypeEnumeration.MINIMUM;
        }
        if ("maximum".equals(authnContextComparisonType)) {
            return AuthnContextComparisonTypeEnumeration.MAXIMUM;
        }
        if ("better".equals(authnContextComparisonType)) {
            return AuthnContextComparisonTypeEnumeration.BETTER;
        }
        return AuthnContextComparisonTypeEnumeration.EXACT;
    }

    void addAuthnContextClassRef(RequestedAuthnContext requestedAuthnContext, String[] authnContextClassRefs) {
        AuthnContextClassRefBuilder authnContextClassRefBuilder = new AuthnContextClassRefBuilder();
        List listAuthnContextClassRef = requestedAuthnContext.getAuthnContextClassRefs();
        int iCnt = 0;
        for (String strAuthnContextClassRef : authnContextClassRefs) {
            AuthnContextClassRef authnContextClassRef = authnContextClassRefBuilder.buildObject();
            authnContextClassRef.setAuthnContextClassRef(strAuthnContextClassRef);
            listAuthnContextClassRef.add(iCnt++, authnContextClassRef);
        }
    }

    Issuer getIssuer(String acsEndpointUrl) {
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(acsEndpointUrl);
        return issuer;
    }

    NameIDPolicy buildNameIdPolicy(SsoConfig samlConfig) {
        Boolean allowCreate;
        NameIDPolicyBuilder nameIDPolicyBuilder = new NameIDPolicyBuilder();
        NameIDPolicy nameIDPolicy = nameIDPolicyBuilder.buildObject();
        String strNameIDPolicy = samlConfig.getNameIDFormat();
        if (strNameIDPolicy != null && !strNameIDPolicy.isEmpty()) {
            nameIDPolicy.setFormat(strNameIDPolicy);
        }
        if ((allowCreate = samlConfig.getAllowCreate()) != null) {
            nameIDPolicy.setAllowCreate(Boolean.valueOf(allowCreate));
        }
        return nameIDPolicy;
    }

    /*
     * WARNING - void declaration
     */
    TAIResult postIdp(HttpServletRequest req, HttpServletResponse resp, String AuthnRequest2, String relayState, String idpUrl, HttpRequestInfo cachingRequestInfo) throws WebTrustAssociationFailedException {
        byte[] authnReqBytes = AuthnRequest2.getBytes(StandardCharsets.UTF_8);
        String samlRequest = Base64Support.encode((byte[])authnReqBytes, (boolean)false);
        if (relayState == null || samlRequest == null || idpUrl == null) {
            throw new WebTrustAssociationFailedException("RelayState, Single-Sign-On URL, and AuthnRequest must be provided");
        }
        try {
            resp.setStatus(200);
            ForwardRequestInfo requestInfo = new ForwardRequestInfo(idpUrl);
            requestInfo.setFragmentCookieId(cachingRequestInfo.getFragmentCookieId());
            requestInfo.setParameter("RelayState", new String[]{relayState});
            requestInfo.setParameter("SAMLRequest", new String[]{samlRequest});
            requestInfo.setFragmentCookieMaxAge(this.ssoService.getConfig().getAuthnRequestTime());
            requestInfo.redirectPostRequest(req, resp, null, null);
        }
        catch (SamlException requestInfo) {
            void e;
            FFDCFilter.processException((Throwable)requestInfo, (String)"com.ibm.ws.security.saml.sso20.sp.Solicited", (String)"403", (Object)this, (Object[])new Object[]{req, resp, AuthnRequest2, relayState, idpUrl, cachingRequestInfo});
            WebTrustAssociationFailedException wtafe = new WebTrustAssociationFailedException(e.getMessage());
            wtafe.initCause((Throwable)e);
            throw wtafe;
        }
        return TAIResult.create((int)401);
    }

    /*
     * WARNING - void declaration
     */
    void signAuthnRequest(SAMLObject authnRequest, Credential signingCredential) throws SamlException {
        SsoConfig samlConfig = this.ssoService.getConfig();
        if (authnRequest instanceof SignableSAMLObject && signingCredential != null) {
            SignableSAMLObject signableMessage = (SignableSAMLObject)authnRequest;
            XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
            XMLObjectBuilder signatureBuilder = builderFactory.getBuilder(Signature.DEFAULT_ELEMENT_NAME);
            Signature signature = (Signature)signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSignatureAlgorithm(samlConfig.getSignatureMethodAlgorithm());
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            signature.setSigningCredential(signingCredential);
            signableMessage.setSignature(signature);
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)signableMessage);
                if (marshaller == null) {
                    throw new SamlException("SAML20_AUTHENTICATION_FAIL", null, new Object[0]);
                }
                marshaller.marshall((XMLObject)signableMessage);
                Thread.currentThread().setContextClassLoader(SignerProvider.class.getClassLoader());
                Signer.signObject((Signature)signature);
            }
            catch (Exception marshaller) {
                void e;
                FFDCFilter.processException((Throwable)marshaller, (String)"com.ibm.ws.security.saml.sso20.sp.Solicited", (String)"450", (Object)this, (Object[])new Object[]{authnRequest, signingCredential});
                throw new SamlException((Exception)e, true);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    String getAuthnRequestString(AuthnRequest authnRequest) throws SamlException {
        String result = null;
        if (authnRequest != null) {
            try {
                AuthnRequestMarshaller marshaller = new AuthnRequestMarshaller();
                Element element = marshaller.marshall((XMLObject)authnRequest);
                result = SerializeSupport.nodeToString((Node)element);
            }
            catch (MarshallingException marshaller) {
                void e;
                FFDCFilter.processException((Throwable)marshaller, (String)"com.ibm.ws.security.saml.sso20.sp.Solicited", (String)"466", (Object)this, (Object[])new Object[]{authnRequest});
                throw new SamlException((Exception)e, true);
            }
        }
        return result;
    }
}

