/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser.util;

import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.WeakHashMap;

public class InetAddressCache {
    private static final WeakHashMap<String, CachedInetAddress> s_inetAddressCache = new WeakHashMap();
    private static final WeakHashMap<InetAddress, String> s_ipCache = new WeakHashMap();
    private static final WeakHashMap<InetSocketAddressKey, InetSocketAddress> s_inetSocketAddressCache = new WeakHashMap();
    private static final ThreadLocal<InetSocketAddressKey> s_key = new ThreadLocal<InetSocketAddressKey>(){

        @Override
        protected InetSocketAddressKey initialValue() {
            return new InetSocketAddressKey();
        }
    };
    private static final int s_cacheAge = SIPTransactionStack.instance().getConfiguration().getNetworkAddressCacheTtl();

    private InetAddressCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress getByName(String host) throws UnknownHostException {
        InetAddress address;
        long now = System.currentTimeMillis();
        CachedInetAddress entry = s_inetAddressCache.get(host);
        if (entry == null) {
            address = InetAddress.getByName(host);
            entry = new CachedInetAddress(address, now);
            WeakHashMap<String, CachedInetAddress> weakHashMap = s_inetAddressCache;
            synchronized (weakHashMap) {
                s_inetAddressCache.put(host, entry);
            }
        } else if (s_cacheAge == -1) {
            address = entry.m_address;
        } else {
            long timestamp = entry.m_timestamp;
            long diff = (now - timestamp) / 1000L;
            if (diff >= (long)s_cacheAge) {
                entry.m_address = address = InetAddress.getByName(host);
                entry.m_timestamp = now;
            } else {
                address = entry.m_address;
            }
        }
        return address;
    }

    public static String getHostAddress(String host) throws UnknownHostException {
        InetAddress address = InetAddressCache.getByName(host);
        String ip = InetAddressCache.getHostAddress(address);
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostAddress(InetAddress address) {
        String ip = s_ipCache.get(address);
        if (ip == null) {
            ip = address.getHostAddress();
            WeakHashMap<InetAddress, String> weakHashMap = s_ipCache;
            synchronized (weakHashMap) {
                s_ipCache.put(address, ip);
            }
        }
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetSocketAddress getInetSocketAddress(String host, int port) {
        InetAddress address;
        try {
            address = InetAddressCache.getByName(host);
            host = null;
        }
        catch (UnknownHostException e2) {
            address = null;
        }
        InetSocketAddressKey key = s_key.get();
        key.set(address, host, port);
        InetSocketAddress socketAddress = s_inetSocketAddressCache.get(key);
        if (socketAddress == null) {
            socketAddress = address == null ? new InetSocketAddress(host, port) : new InetSocketAddress(address, port);
            InetSocketAddressKey socketAddressKey = new InetSocketAddressKey();
            socketAddressKey.set(address, host, port);
            if (!key.equals(socketAddressKey)) {
                throw new RuntimeException("Expected equality between [" + socketAddress + "] and [" + key + ']');
            }
            WeakHashMap<InetSocketAddressKey, InetSocketAddress> weakHashMap = s_inetSocketAddressCache;
            synchronized (weakHashMap) {
                s_inetSocketAddressCache.put(socketAddressKey, socketAddress);
            }
        }
        return socketAddress;
    }

    static class CachedInetAddress {
        InetAddress m_address;
        long m_timestamp;

        CachedInetAddress(InetAddress address, long timestamp) {
            this.m_address = address;
            this.m_timestamp = timestamp;
        }
    }

    static class InetSocketAddressKey {
        private InetAddress m_address;
        private String m_host;
        private int m_port;

        InetSocketAddressKey() {
        }

        void set(InetAddress address, String host, int port) {
            this.m_address = address;
            this.m_host = host;
            this.m_port = port;
        }

        public int hashCode() {
            return Objects.hash(this.m_address, this.m_host, this.m_port);
        }

        public boolean equals(Object other) {
            if (!(other instanceof InetSocketAddressKey)) {
                return false;
            }
            InetSocketAddressKey otherKey = (InetSocketAddressKey)other;
            return this.m_address == otherKey.m_address && this.m_host == otherKey.m_host && this.m_port == otherKey.m_port;
        }

        public boolean match(InetSocketAddress otherInetSocketAddress) {
            String otherHost;
            String thisHost;
            int thisPort = this.m_port;
            int otherPort = otherInetSocketAddress.getPort();
            if (thisPort != otherPort) {
                return false;
            }
            InetAddress thisAddress = this.m_address;
            InetAddress otherAddress = otherInetSocketAddress.getAddress();
            if (thisAddress != otherAddress) {
                if (thisAddress == null || otherAddress == null) {
                    return false;
                }
                if (!thisAddress.equals(otherAddress)) {
                    return false;
                }
            }
            if (thisAddress == null && (thisHost = this.m_host) != (otherHost = otherInetSocketAddress.getHostName())) {
                if (thisHost == null || otherHost == null) {
                    return false;
                }
                if (!thisHost.equals(otherHost)) {
                    return false;
                }
            }
            return true;
        }
    }
}

