/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.security.KeyPair;
import java.time.Duration;
import java.time.Instant;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Metadata;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.connector.Resource;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.provider.AcmeProvider;
import org.shredzone.acme4j.provider.GenericAcmeProvider;
import org.shredzone.acme4j.toolbox.JSON;

@ParametersAreNonnullByDefault
@ThreadSafe
public class Session {
    private static final GenericAcmeProvider GENERIC_PROVIDER = new GenericAcmeProvider();
    private final AtomicReference<Map<Resource, URL>> resourceMap = new AtomicReference();
    private final AtomicReference<Metadata> metadata = new AtomicReference();
    private final URI serverUri;
    private final AcmeProvider provider;
    private String nonce;
    private Locale locale = Locale.getDefault();
    private Proxy proxy = Proxy.NO_PROXY;
    protected Instant directoryCacheExpiry;

    public Session(String serverUri) {
        this(URI.create(serverUri));
    }

    public Session(URI serverUri) {
        this.serverUri = Objects.requireNonNull(serverUri, "serverUri");
        if (GENERIC_PROVIDER.accepts(serverUri)) {
            this.provider = GENERIC_PROVIDER;
            return;
        }
        URI localServerUri = serverUri;
        ServiceLoader<AcmeProvider> providers = ServiceLoader.load(AcmeProvider.class);
        this.provider = StreamSupport.stream(providers.spliterator(), false).filter(p -> p.accepts(localServerUri)).reduce((a, b) -> {
            throw new IllegalArgumentException("Both ACME providers " + a.getClass().getSimpleName() + " and " + b.getClass().getSimpleName() + " accept " + localServerUri + ". Please check your classpath.");
        }).orElseThrow(() -> new IllegalArgumentException("No ACME provider found for " + localServerUri));
    }

    public Login login(URL accountLocation, KeyPair accountKeyPair) {
        return new Login(accountLocation, accountKeyPair, this);
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    @CheckForNull
    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(@Nullable String nonce) {
        this.nonce = nonce;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(@Nullable Locale locale) {
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(@Nullable Proxy proxy) {
        this.proxy = proxy != null ? proxy : Proxy.NO_PROXY;
    }

    public AcmeProvider provider() {
        return this.provider;
    }

    public Connection connect() {
        return this.provider.connect(this.getServerUri());
    }

    public URL resourceUrl(Resource resource) throws AcmeException {
        this.readDirectory();
        URL result = this.resourceMap.get().get((Object)Objects.requireNonNull(resource, "resource"));
        if (result == null) {
            throw new AcmeException("Server does not offer " + resource.path());
        }
        return result;
    }

    public Metadata getMetadata() throws AcmeException {
        this.readDirectory();
        return this.metadata.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDirectory() throws AcmeException {
        Session session = this;
        synchronized (session) {
            Instant now = Instant.now();
            if (this.directoryCacheExpiry != null && this.directoryCacheExpiry.isAfter(now)) {
                return;
            }
            this.directoryCacheExpiry = now.plus(Duration.ofHours(1L));
        }
        JSON directoryJson = this.provider().directory(this, this.getServerUri());
        JSON.Value meta = directoryJson.get("meta");
        if (meta.isPresent()) {
            this.metadata.set(new Metadata(meta.asObject()));
        } else {
            this.metadata.set(new Metadata(JSON.empty()));
        }
        EnumMap map = new EnumMap(Resource.class);
        for (Resource res : Resource.values()) {
            directoryJson.get(res.path()).map(JSON.Value::asURL).ifPresent(url -> map.put(res, url));
        }
        this.resourceMap.set(map);
    }
}

