/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableCollection;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.util.FpKit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;

@Internal
public class DirectivesUtil {
    @Deprecated
    public static Map<String, GraphQLDirective> nonRepeatableDirectivesByName(List<GraphQLDirective> directives) {
        List singletonDirectives = directives.stream().filter(d -> !d.isRepeatable()).collect(Collectors.toList());
        return FpKit.getByName(singletonDirectives, GraphQLDirective::getName);
    }

    @Deprecated
    public static Map<String, ImmutableList<GraphQLDirective>> allDirectivesByName(List<GraphQLDirective> directives) {
        return ImmutableMap.copyOf(FpKit.groupingBy(directives, GraphQLDirective::getName));
    }

    @Deprecated
    public static Optional<GraphQLArgument> directiveWithArg(List<GraphQLDirective> directives, String directiveName, String argumentName) {
        GraphQLDirective directive = DirectivesUtil.nonRepeatableDirectivesByName(directives).get(directiveName);
        GraphQLArgument argument = null;
        if (directive != null) {
            argument = directive.getArgument(argumentName);
        }
        return Optional.ofNullable(argument);
    }

    @Deprecated
    public static boolean isAllNonRepeatable(List<GraphQLDirective> directives) {
        if (directives == null || directives.isEmpty()) {
            return false;
        }
        for (GraphQLDirective graphQLDirective : directives) {
            if (!graphQLDirective.isRepeatable()) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static List<GraphQLDirective> add(List<GraphQLDirective> targetList, GraphQLDirective newDirective) {
        Assert.assertNotNull(targetList, () -> "directive list can't be null");
        Assert.assertNotNull(newDirective, () -> "directive can't be null");
        targetList.add(newDirective);
        return targetList;
    }

    @Deprecated
    public static List<GraphQLDirective> addAll(List<GraphQLDirective> targetList, List<GraphQLDirective> newDirectives) {
        Assert.assertNotNull(targetList, () -> "directive list can't be null");
        Assert.assertNotNull(newDirectives, () -> "directive list can't be null");
        targetList.addAll(newDirectives);
        return targetList;
    }

    @Deprecated
    public static GraphQLDirective getFirstDirective(String name, Map<String, List<GraphQLDirective>> allDirectivesByName) {
        List directives = allDirectivesByName.getOrDefault(name, ImmutableKit.emptyList());
        if (directives.isEmpty()) {
            return null;
        }
        return (GraphQLDirective)directives.get(0);
    }

    public static List<GraphQLAppliedDirective> toAppliedDirectives(GraphQLDirectiveContainer directiveContainer) {
        return DirectivesUtil.toAppliedDirectives(directiveContainer.getAppliedDirectives(), directiveContainer.getDirectives());
    }

    public static List<GraphQLAppliedDirective> toAppliedDirectives(Collection<GraphQLAppliedDirective> appliedDirectives, Collection<GraphQLDirective> directives) {
        Set named = appliedDirectives.stream().map(GraphQLAppliedDirective::getName).collect(Collectors.toSet());
        ImmutableCollection.Builder list = ImmutableList.builder().addAll(appliedDirectives);
        directives.forEach(arg_0 -> DirectivesUtil.lambda$toAppliedDirectives$5(named, (ImmutableList.Builder)list, arg_0));
        return ((ImmutableList.Builder)list).build();
    }

    private static /* synthetic */ void lambda$toAppliedDirectives$5(Set named, ImmutableList.Builder list, GraphQLDirective directive) {
        if (!named.contains(directive.getName())) {
            list.add(directive.toAppliedDirective());
        }
    }

    public static class DirectivesHolder {
        private final ImmutableMap<String, List<GraphQLDirective>> allDirectivesByName;
        private final ImmutableMap<String, GraphQLDirective> nonRepeatableDirectivesByName;
        private final List<GraphQLDirective> allDirectives;
        private final ImmutableMap<String, List<GraphQLAppliedDirective>> allAppliedDirectivesByName;
        private final List<GraphQLAppliedDirective> allAppliedDirectives;

        public DirectivesHolder(Collection<GraphQLDirective> allDirectives, Collection<GraphQLAppliedDirective> allAppliedDirectives) {
            this.allDirectives = ImmutableList.copyOf(allDirectives);
            this.allDirectivesByName = ImmutableMap.copyOf(FpKit.groupingBy(allDirectives, GraphQLDirective::getName));
            List nonRepeatableDirectives = allDirectives.stream().filter(d -> !d.isRepeatable()).collect(Collectors.toList());
            this.nonRepeatableDirectivesByName = ImmutableMap.copyOf(FpKit.getByName(nonRepeatableDirectives, GraphQLDirective::getName));
            this.allAppliedDirectives = ImmutableList.copyOf(allAppliedDirectives);
            this.allAppliedDirectivesByName = ImmutableMap.copyOf(FpKit.groupingBy(allAppliedDirectives, GraphQLAppliedDirective::getName));
        }

        public ImmutableMap<String, List<GraphQLDirective>> getAllDirectivesByName() {
            return this.allDirectivesByName;
        }

        public ImmutableMap<String, GraphQLDirective> getDirectivesByName() {
            return this.nonRepeatableDirectivesByName;
        }

        public List<GraphQLDirective> getDirectives() {
            return this.allDirectives;
        }

        public GraphQLDirective getDirective(String directiveName) {
            List<GraphQLDirective> directiveList = this.allDirectivesByName.get(directiveName);
            if (directiveList == null || directiveList.isEmpty()) {
                return null;
            }
            return directiveList.get(0);
        }

        public List<GraphQLDirective> getDirectives(String directiveName) {
            return this.allDirectivesByName.getOrDefault(directiveName, ImmutableKit.emptyList());
        }

        public ImmutableMap<String, List<GraphQLAppliedDirective>> getAllAppliedDirectivesByName() {
            return this.allAppliedDirectivesByName;
        }

        public List<GraphQLAppliedDirective> getAppliedDirectives() {
            return this.allAppliedDirectives;
        }

        public List<GraphQLAppliedDirective> getAppliedDirectives(String directiveName) {
            return this.allAppliedDirectivesByName.getOrDefault(directiveName, ImmutableKit.emptyList());
        }

        public GraphQLAppliedDirective getAppliedDirective(String directiveName) {
            List list = this.allAppliedDirectivesByName.getOrDefault(directiveName, ImmutableKit.emptyList());
            return list.isEmpty() ? null : (GraphQLAppliedDirective)list.get(0);
        }

        public String toString() {
            return new StringJoiner(", ", DirectivesHolder.class.getSimpleName() + "[", "]").add("allDirectivesByName=" + String.join((CharSequence)",", this.allDirectivesByName.keySet())).add("allAppliedDirectivesByName=" + String.join((CharSequence)",", this.allAppliedDirectivesByName.keySet())).toString();
        }
    }
}

