/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.api.mbeans;

import com.arjuna.ats.arjuna.objectstore.BaseStore;
import com.arjuna.ats.arjuna.tools.osb.api.mbeans.BaseStoreMBean;
import com.arjuna.ats.arjuna.tools.osb.api.proxy.StoreManagerProxy;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

public abstract class BaseStoreBean
extends NotificationBroadcasterSupport
implements BaseStoreMBean {
    private BaseStore store;

    public BaseStoreBean(BaseStore store) {
        this.store = store;
    }

    protected BaseStore getStore() {
        return this.store;
    }

    protected abstract ObjectName getMBeanName();

    public String getStoreName() {
        return this.store.getStoreName();
    }

    public void start() {
        StoreManagerProxy.registerBean((ObjectName)this.getMBeanName(), (Object)this, (boolean)true);
        this.generateNotification("Registering ObjectStore MBean");
    }

    public void stop() {
        this.generateNotification("Unregistering ObjectStore MBean");
        StoreManagerProxy.registerBean((ObjectName)this.getMBeanName(), (Object)this, (boolean)false);
    }

    private void generateNotification(String message) {
        AttributeChangeNotification acn = new AttributeChangeNotification(this, 0L, 0L, message, "storeName", "String", "oldValue", "newValue");
        this.sendNotification((Notification)acn);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "Generated when the ObjectStore MBean is registered and destroyed")};
    }
}

