/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.utils.SocialUtil;
import com.ibm.ws.security.social.tai.AuthorizationCodeAuthenticator;
import com.ibm.ws.security.social.tai.TAISubjectUtils;
import com.ibm.ws.security.social.tai.TAIWebUtils;
import com.ibm.ws.security.social.web.utils.SocialWebUtils;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.wsspi.security.tai.TAIResult;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OAuthLoginFlow {
    public static final TraceComponent tc = Tr.register(OAuthLoginFlow.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    ReferrerURLCookieHandler referrerURLCookieHandler = null;
    TAIWebUtils taiWebUtils = new TAIWebUtils();
    SocialWebUtils webUtils = new SocialWebUtils();
    static final long serialVersionUID = -8532506312339047798L;

    public OAuthLoginFlow() {
        this.referrerURLCookieHandler = this.taiWebUtils.getCookieHandler();
    }

    TAIResult handleOAuthRequest(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig clientConfig) throws WebTrustAssociationFailedException {
        if (SocialUtil.useAccessTokenFromRequest(clientConfig) && this.isBeforeSSO(request)) {
            TAIResult result = this.handleAccessTokenFlow(request, response, clientConfig);
            if (clientConfig.isAccessTokenRequired() || result != null && result.getSubject() != null) {
                return result;
            }
            return TAIResult.create((int)100);
        }
        String code = this.webUtils.getAndClearCookie(request, response, "WASSocialState");
        if (code == null) {
            return this.handleRedirectToServer(request, response, clientConfig);
        }
        return this.handleAuthorizationCode(request, response, code, clientConfig);
    }

    private boolean isBeforeSSO(HttpServletRequest request) {
        if (request.getAttribute("SocialTaiBeforeSSORequest") != null) {
            request.removeAttribute("SocialTaiBeforeSSORequest");
            return true;
        }
        return false;
    }

    private TAIResult handleAccessTokenFlow(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig clientConfig) throws WebTrustAssociationFailedException {
        TAIResult result = null;
        String tokenFromRequest = this.taiWebUtils.getBearerAccessToken(request, clientConfig);
        if (this.requestShouldHaveToken(clientConfig)) {
            if (this.isAccessTokenNullOrEmpty(tokenFromRequest)) {
                Tr.error((TraceComponent)tc, (String)"ACCESS_TOKEN_MISSING_FROM_HEADERS", (Object[])new Object[]{clientConfig.getUniqueId()});
                return this.taiWebUtils.sendToErrorPage(response, TAIResult.create((int)401));
            }
            return this.handleAccessToken(tokenFromRequest, request, response, clientConfig);
        }
        if (!this.isAccessTokenNullOrEmpty(tokenFromRequest)) {
            try {
                return this.handleAccessToken(tokenFromRequest, request, response, clientConfig);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.tai.OAuthLoginFlow", (String)"89", (Object)this, (Object[])new Object[]{request, response, clientConfig});
            }
        }
        return result;
    }

    private boolean isAccessTokenNullOrEmpty(@Sensitive String tokenFromRequest) {
        return tokenFromRequest == null || tokenFromRequest.isEmpty();
    }

    @FFDCIgnore(value={SocialLoginException.class})
    private TAIResult handleAccessToken(@Sensitive String tokenFromRequest, HttpServletRequest request, HttpServletResponse response, SocialLoginConfig clientConfig) throws WebTrustAssociationFailedException {
        AuthorizationCodeAuthenticator authzCodeAuthenticator = new AuthorizationCodeAuthenticator(request, response, clientConfig, tokenFromRequest, true);
        try {
            authzCodeAuthenticator.generateJwtAndTokensFromAccessOrServiceAccountToken();
        }
        catch (SocialLoginException e) {
            if (!clientConfig.isAccessTokenRequired() && clientConfig.isAccessTokenSupported()) {
                this.taiWebUtils.restorePostParameters(request);
                return null;
            }
            return this.taiWebUtils.sendToErrorPage(response, TAIResult.create((int)401));
        }
        return this.buildTAIResultFromAuthzCodeAuthenticator(request, response, clientConfig, authzCodeAuthenticator);
    }

    private boolean requestShouldHaveToken(SocialLoginConfig clientConfig) {
        return clientConfig.isAccessTokenRequired();
    }

    @FFDCIgnore(value={SocialLoginException.class})
    TAIResult handleRedirectToServer(HttpServletRequest req, HttpServletResponse res, SocialLoginConfig clientConfig) throws WebTrustAssociationFailedException {
        try {
            req.getSession(true);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.tai.OAuthLoginFlow", (String)"128", (Object)this, (Object[])new Object[]{req, res, clientConfig});
        }
        String stateValue = this.taiWebUtils.createStateCookie(req, res);
        String redirect_url = this.taiWebUtils.getRedirectUrl(req, clientConfig);
        try {
            this.taiWebUtils.savePostParameters(req);
            String acr_values = req.getParameter("acr_values");
            String authzEndPointUrlWithQuery = this.buildAuthorizationUrlWithQuery(stateValue, clientConfig, redirect_url, acr_values);
            if (clientConfig.isClientSideRedirectSupported()) {
                this.webUtils.doClientSideRedirect(res, "WASReqUrlSocial_" + stateValue.hashCode(), authzEndPointUrlWithQuery);
                return TAIResult.create((int)403);
            }
            String cookieName = "WASReqUrlSocial_" + stateValue.hashCode();
            Cookie c = this.referrerURLCookieHandler.createCookie(cookieName, this.webUtils.getRequestUrlWithEncodedQueryString(req), req);
            res.addCookie(c);
            res.sendRedirect(authzEndPointUrlWithQuery);
            return TAIResult.create((int)403);
        }
        catch (SocialLoginException e) {
            Tr.error((TraceComponent)tc, (String)"FAILED_TO_REDIRECT_TO_AUTHZ_ENDPOINT", (Object[])new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.social.tai.OAuthLoginFlow", (String)"153", (Object)this, (Object[])new Object[]{req, res, clientConfig});
            Tr.error((TraceComponent)tc, (String)"FAILED_TO_REDIRECT_TO_AUTHZ_ENDPOINT", (Object[])new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
        }
        return this.taiWebUtils.sendToErrorPage(res, TAIResult.create((int)403));
    }

    /*
     * WARNING - void declaration
     */
    String buildAuthorizationUrlWithQuery(String state, SocialLoginConfig clientConfig, String redirectUrl, String acr_values) throws SocialLoginException {
        String scope;
        if (state == null) {
            throw new SocialLoginException("STATE_IS_NULL", null, new Object[]{clientConfig.getUniqueId()});
        }
        if (redirectUrl == null) {
            throw new SocialLoginException("REDIRECT_URL_IS_NULL", null, new Object[]{clientConfig.getUniqueId()});
        }
        String authzEndpoint = this.taiWebUtils.getAuthorizationEndpoint(clientConfig);
        String strResponse_type = clientConfig.getResponseType();
        String clientId = clientConfig.getClientId();
        if (clientId == null) {
            Tr.warning((TraceComponent)tc, (String)"OUTGOING_REQUEST_MISSING_PARAMETER", (Object[])new Object[]{authzEndpoint, "client_id"});
            clientId = "";
        }
        if ((scope = clientConfig.getScope()) == null) {
            scope = "";
        }
        String query = "";
        try {
            String resources;
            query = String.format("response_type=%s&client_id=%s&state=%s&redirect_uri=%s&scope=%s", URLEncoder.encode(strResponse_type, "UTF-8"), URLEncoder.encode(clientId, "UTF-8"), URLEncoder.encode(state, "UTF-8"), URLEncoder.encode(redirectUrl, "UTF-8"), URLEncoder.encode(scope, "UTF-8"));
            if (clientConfig.createNonce()) {
                String nonceValue = SocialUtil.generateRandom();
                query = String.format("%s&nonce=%s", query, URLEncoder.encode(nonceValue, "UTF-8"));
            }
            if (acr_values != null && !acr_values.isEmpty()) {
                query = String.format("%s&acr_values=%s", query, URLEncoder.encode(acr_values, "UTF-8"));
            }
            query = this.addResponseModeToQuery(query, clientConfig);
            if (!strResponse_type.equals("code") && (resources = clientConfig.getResource()) != null) {
                query = String.format("%s&%s", query, URLEncoder.encode(resources, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException resources) {
            void e;
            FFDCFilter.processException((Throwable)resources, (String)"com.ibm.ws.security.social.tai.OAuthLoginFlow", (String)"205", (Object)this, (Object[])new Object[]{state, clientConfig, redirectUrl, acr_values});
            throw new SocialLoginException((Exception)e);
        }
        String s = authzEndpoint + "?" + query;
        return s;
    }

    String addResponseModeToQuery(String query, SocialLoginConfig config) throws UnsupportedEncodingException {
        String responseMode = config.getResponseMode();
        String responseType = config.getResponseType();
        if (!responseType.equals("code")) {
            responseMode = "form_post";
        }
        if (responseMode != null) {
            query = String.format("%s&response_mode=%s", query, URLEncoder.encode(responseMode, "UTF-8"));
        }
        return query;
    }

    TAIResult handleAuthorizationCode(HttpServletRequest req, HttpServletResponse res, String authzCode, SocialLoginConfig clientConfig) throws WebTrustAssociationFailedException {
        AuthorizationCodeAuthenticator authzCodeAuthenticator = this.getAuthorizationCodeAuthenticator(req, res, authzCode, clientConfig);
        try {
            authzCodeAuthenticator.generateJwtAndTokenInformation();
        }
        catch (SocialLoginException socialLoginException) {
            FFDCFilter.processException((Throwable)socialLoginException, (String)"com.ibm.ws.security.social.tai.OAuthLoginFlow", (String)"230", (Object)this, (Object[])new Object[]{req, res, authzCode, clientConfig});
            return this.taiWebUtils.sendToErrorPage(res, TAIResult.create((int)401));
        }
        return this.buildTAIResultFromAuthzCodeAuthenticator(req, res, clientConfig, authzCodeAuthenticator);
    }

    AuthorizationCodeAuthenticator getAuthorizationCodeAuthenticator(HttpServletRequest req, HttpServletResponse res, String authzCode, SocialLoginConfig clientConfig) {
        return new AuthorizationCodeAuthenticator(req, res, authzCode, clientConfig);
    }

    /*
     * WARNING - void declaration
     */
    TAIResult buildTAIResultFromAuthzCodeAuthenticator(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig clientConfig, AuthorizationCodeAuthenticator authzCodeAuthenticator) throws WebTrustAssociationFailedException {
        TAIResult authnResult = null;
        try {
            TAISubjectUtils subjectUtils = this.getTAISubjectUtils(authzCodeAuthenticator);
            authnResult = subjectUtils.createResult(response, clientConfig);
        }
        catch (Exception subjectUtils) {
            void e;
            FFDCFilter.processException((Throwable)subjectUtils, (String)"com.ibm.ws.security.social.tai.OAuthLoginFlow", (String)"246", (Object)this, (Object[])new Object[]{request, response, clientConfig, authzCodeAuthenticator});
            Tr.error((TraceComponent)tc, (String)"AUTH_CODE_ERROR_CREATING_RESULT", (Object[])new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
            return this.taiWebUtils.sendToErrorPage(response, TAIResult.create((int)401));
        }
        this.taiWebUtils.restorePostParameters(request);
        return authnResult;
    }

    TAISubjectUtils getTAISubjectUtils(AuthorizationCodeAuthenticator authzCodeAuthenticator) {
        return new TAISubjectUtils(authzCodeAuthenticator);
    }
}

