/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.component;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonEventUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.view.facelets.component.JsfElement;

public class JsfElementRenderer
extends HtmlRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        HtmlRendererUtils.decodeClientBehaviors((FacesContext)context, (UIComponent)component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String elementName = (String)component.getPassThroughAttributes().get("elementName");
        if (elementName == null) {
            throw new FacesException("jsf:element with clientId" + component.getClientId(facesContext) + " requires 'elementName' passthrough attribute");
        }
        JsfElement jsfElement = (JsfElement)component;
        Map behaviors = jsfElement.getClientBehaviors();
        if (behaviors != null && !behaviors.isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary((FacesContext)facesContext, (ResponseWriter)writer);
        }
        writer.startElement(elementName, component);
        if (!behaviors.isEmpty()) {
            HtmlRendererUtils.writeIdAndName((ResponseWriter)writer, (UIComponent)component, (FacesContext)facesContext);
        } else {
            HtmlRendererUtils.writeIdIfNecessary((ResponseWriter)writer, (UIComponent)component, (FacesContext)facesContext);
        }
        long commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked((UIComponent)component);
        if (behaviors.isEmpty()) {
            CommonPropertyUtils.renderEventProperties((ResponseWriter)writer, (long)commonPropertiesMarked, (UIComponent)component);
            CommonPropertyUtils.renderFocusBlurEventProperties((ResponseWriter)writer, (long)commonPropertiesMarked, (UIComponent)component);
            CommonPropertyUtils.renderChangeSelectEventProperties((ResponseWriter)writer, (long)commonPropertiesMarked, (UIComponent)component);
        } else {
            long commonEventsMarked = CommonEventUtils.getCommonEventsMarked((UIComponent)component);
            CommonEventUtils.renderBehaviorizedEventHandlers((FacesContext)facesContext, (ResponseWriter)writer, (long)commonPropertiesMarked, (long)commonEventsMarked, (UIComponent)component, (Map)behaviors);
            CommonEventUtils.renderBehaviorizedFieldEventHandlers((FacesContext)facesContext, (ResponseWriter)writer, (long)commonPropertiesMarked, (long)commonEventsMarked, (UIComponent)component, (String)component.getClientId(facesContext), (Map)behaviors);
        }
        CommonPropertyUtils.renderStyleProperties((ResponseWriter)writer, (long)commonPropertiesMarked, (UIComponent)component);
        HtmlRendererUtils.renderBehaviorizedAttribute((FacesContext)facesContext, (ResponseWriter)writer, (String)"onload", (UIComponent)component, (String)"load", (Map)behaviors, (String)"onload");
        HtmlRendererUtils.renderBehaviorizedAttribute((FacesContext)facesContext, (ResponseWriter)writer, (String)"onunload", (UIComponent)component, (String)"unload", (Map)behaviors, (String)"onunload");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.renderChildren((FacesContext)facesContext, (UIComponent)component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String elementName = (String)component.getPassThroughAttributes().get("elementName");
        writer.endElement(elementName);
    }

    protected boolean isCommonPropertiesOptimizationEnabled(FacesContext facesContext) {
        return true;
    }

    protected boolean isCommonEventsOptimizationEnabled(FacesContext facesContext) {
        return true;
    }
}

