/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health40.internal.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.health40.internal.HealthCheck40Service;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HealthCheckLivenessServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(HealthCheckLivenessServlet.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
    private transient HealthCheck40Service healthService = null;
    private ServiceTracker<HealthCheck40Service, HealthCheck40Service> healthServiceTracker;
    private static final Logger logger = Logger.getLogger(HealthCheckLivenessServlet.class.getName(), "io.openliberty.microprofile.health.resources.Health");

    public void init(ServletConfig config) throws ServletException {
        BundleContext bundleContext = (BundleContext)config.getServletContext().getAttribute("osgi-bundlecontext");
        this.healthServiceTracker = new ServiceTracker(bundleContext, HealthCheck40Service.class, null);
        this.healthServiceTracker.open();
        super.init(config);
    }

    public void destroy() {
        super.destroy();
        this.healthServiceTracker.close();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.findHealthService();
        this.healthService.performHealthCheck(request, response, "LIVE");
    }

    private synchronized void findHealthService() throws ServletException {
        if (this.healthService == null) {
            if (this.healthServiceTracker == null) {
                logger.log(Level.SEVERE, "OSGI_SERVICE_ERROR", "HealthCheckService");
                throw new ServletException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"HealthCheckService"}));
            }
            this.healthService = (HealthCheck40Service)this.healthServiceTracker.getService();
        }
    }
}

