/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.admin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.config.admin.SystemConfigSupport;
import com.ibm.ws.config.admin.internal.ConfigAdminServiceFactory;
import com.ibm.ws.config.admin.internal.ExtendedConfigurationImpl;
import com.ibm.ws.config.admin.internal.UpdateQueue;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class SystemConfigSupportImpl
implements SystemConfigSupport {
    private final ConfigAdminServiceFactory caFactory;
    private final ServiceRegistration<?> caSupportRef;
    private ServiceTracker<EventAdmin, EventAdmin> eventTracker = null;
    static final long serialVersionUID = -5567496331460706713L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SystemConfigSupportImpl(BundleContext bc, ConfigAdminServiceFactory configAdminServiceFactory) {
        this.caFactory = configAdminServiceFactory;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.vendor", "IBM");
        this.caSupportRef = bc.registerService(SystemConfigSupport.class.getName(), (Object)this, properties);
        this.eventTracker = new ServiceTracker(bc, EventAdmin.class.getName(), null);
        this.eventTracker.open();
    }

    public void stop() {
        this.caSupportRef.unregister();
        if (this.eventTracker != null) {
            this.eventTracker.close();
            this.eventTracker = null;
        }
    }

    @Override
    public void openManagedServiceTrackers() {
        this.caFactory.openManagedServiceTrackers();
    }

    @Override
    public ExtendedConfiguration lookupConfiguration(ConfigID id) {
        return this.caFactory.lookupConfiguration(id);
    }

    @Override
    public Set<ConfigID> getReferences(ConfigID id) {
        return this.caFactory.getReferences(id);
    }

    @Override
    public void registerConfiguration(ConfigID id, ExtendedConfiguration config) {
        this.caFactory.registerConfiguration(id, (ExtendedConfigurationImpl)config);
    }

    @Override
    public ExtendedConfiguration findConfiguration(String pid) {
        return this.caFactory.findConfiguration(pid);
    }

    @Override
    public boolean waitForAll(Collection<Future<?>> futureList, long timeout, TimeUnit timeUnit) {
        return UpdateQueue.waitForAll(futureList, timeout, timeUnit);
    }

    @Override
    public void fireMetatypeAddedEvent(String pid) {
        final String factoryPid = pid;
        final EventAdmin eventAdmin = (EventAdmin)this.eventTracker.getService();
        this.caFactory.updateQueue.add(pid, new Runnable(){
            static final long serialVersionUID = -8472487957940012336L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("mtp_updated_pids", factoryPid);
                Event event = new Event("com/ibm/ws/config/xml/internal/MetaTypeRegistry/METATYPE_PROVIDER_ADDED", properties);
                eventAdmin.postEvent(event);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.admin.internal.SystemConfigSupportImpl$1", 1.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
            }
        });
    }

    @Override
    public void fireMetatypeRemovedEvent(String pid) {
        final String factoryPid = pid;
        final EventAdmin eventAdmin = (EventAdmin)this.eventTracker.getService();
        this.caFactory.updateQueue.add(pid, new Runnable(){
            static final long serialVersionUID = 4569361644196640906L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("mtp_updated_pids", factoryPid);
                Event event = new Event("com/ibm/ws/config/xml/internal/MetaTypeRegistry/METATYPE_PROVIDER_REMOVED", properties);
                eventAdmin.postEvent(event);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.admin.internal.SystemConfigSupportImpl$2", 2.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
            }
        });
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.admin.internal.SystemConfigSupportImpl", SystemConfigSupportImpl.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    }
}

