/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.objectManager;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.objectManager.Iterator;
import com.ibm.ws.objectManager.LinkedList;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.persistence.RangeManager;
import com.ibm.ws.sib.msgstore.persistence.UniqueKeyGenerator;
import com.ibm.ws.sib.msgstore.persistence.objectManager.UniqueKeyGeneratorManagedObject;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;

public class UniqueKeyRangeManager
implements RangeManager,
Runnable {
    private static TraceComponent tc = SibTr.register(UniqueKeyRangeManager.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final long UNIQUE_KEY_INITIAL_VALUE = 0L;
    private boolean _running = true;
    private HashMap _generators;
    private Token _uniqueKeyRootToken;
    private ObjectStore _objectStore;
    private ObjectManager _objectManager;
    private java.util.LinkedList _asyncQ;

    public UniqueKeyRangeManager(Token uniqueKeyRootToken, ObjectManager objectManager, ObjectStore objectStore) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)("Token=" + uniqueKeyRootToken));
        }
        this._uniqueKeyRootToken = uniqueKeyRootToken;
        this._objectStore = objectStore;
        this._objectManager = objectManager;
        this._generators = new HashMap(5);
        this._asyncQ = new java.util.LinkedList();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    void start() throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        try {
            LinkedList list = (LinkedList)this._uniqueKeyRootToken.getManagedObject();
            Iterator iterator = list.iterator();
            while (iterator.hasNext(null)) {
                Token token = (Token)iterator.next(null);
                UniqueKeyGeneratorManagedObject mo = (UniqueKeyGeneratorManagedObject)token.getManagedObject();
                String name = mo.getGeneratorName();
                this._generators.put(name, mo);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Generator loaded from persistent store: " + name));
            }
        }
        catch (ClassCastException cce) {
            FFDCFilter.processException((Throwable)cce, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.UniqueKeyRangeManager.start", (String)"1:109:1.8", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Class cast exception caught during start of RangeManager!", (Object)cce);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"start");
            }
            throw new PersistenceException("Class cast exception caught during start of RangeManager!", (Throwable)cce);
        }
        catch (ObjectManagerException ome) {
            FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.UniqueKeyRangeManager.start", (String)"1:116:1.8", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Unexpected exception caught during start of RangeManager!", (Object)ome);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"start");
            }
            throw new PersistenceException("Unexpected exception caught during start of RangeManager!", (Throwable)ome);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        this._running = false;
        java.util.LinkedList linkedList = this._asyncQ;
        synchronized (linkedList) {
            this._asyncQ.notify();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleUpdate(UniqueKeyGenerator generator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"scheduleUpdate", (Object)("GeneratorName=" + generator.getName()));
        }
        java.util.LinkedList linkedList = this._asyncQ;
        synchronized (linkedList) {
            this._asyncQ.add(generator);
            this._asyncQ.notify();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"scheduleUpdate");
        }
    }

    @Override
    public boolean entryExists(UniqueKeyGenerator generator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"entryExists", (Object)("GeneratorName=" + generator.getName()));
        }
        boolean retval = false;
        if (this._generators.containsKey(generator.getName())) {
            retval = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"entryExists", (Object)("retrun=" + retval));
        }
        return retval;
    }

    @Override
    public long addEntry(UniqueKeyGenerator generator) throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addEntry", (Object)("GeneratorName=" + generator.getName()));
        }
        if (!this._generators.containsKey(generator.getName())) {
            Transaction transaction = null;
            try {
                transaction = this._objectManager.getTransaction();
                UniqueKeyGeneratorManagedObject uniqueKey = new UniqueKeyGeneratorManagedObject(generator);
                Token uniqueKeyToken = this._objectStore.allocate(uniqueKey);
                transaction.add(uniqueKey);
                LinkedList list = (LinkedList)this._uniqueKeyRootToken.getManagedObject();
                list.add(uniqueKeyToken, transaction);
                transaction.commit(false);
                this._generators.put(generator.getName(), uniqueKey);
            }
            catch (ObjectManagerException ome) {
                block10: {
                    FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.UniqueKeyRangeManager.addEntry", (String)"1:217:1.8", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Exception caught creating new unique key generator!", (Object)ome);
                    }
                    if (transaction != null) {
                        try {
                            transaction.backout(false);
                        }
                        catch (ObjectManagerException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.UniqueKeyRangeManager.addEntry", (String)"1:229:1.8", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block10;
                            SibTr.event((TraceComponent)tc, (String)"Exception caught backing out unique key generator creation!", (Object)e);
                        }
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addEntry");
                }
                throw new PersistenceException("Exception caught creating new unique key generator!", (Throwable)ome);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addEntry", (Object)"return=0");
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long updateEntry(UniqueKeyGenerator generator) throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateEntry", (Object)("GeneratorName=" + generator.getName()));
        }
        long currentLimit = 0L;
        if (this._generators.containsKey(generator.getName())) {
            Transaction transaction = null;
            try {
                transaction = this._objectManager.getTransaction();
                UniqueKeyGeneratorManagedObject mo = (UniqueKeyGeneratorManagedObject)this._generators.get(generator.getName());
                transaction.lock(mo);
                UniqueKeyGeneratorManagedObject uniqueKeyGeneratorManagedObject = mo;
                synchronized (uniqueKeyGeneratorManagedObject) {
                    currentLimit = mo.getGeneratorKeyLimit();
                    mo.setGeneratorKeyLimit(currentLimit + generator.getRange());
                }
                transaction.replace(mo);
                transaction.commit(false);
            }
            catch (ObjectManagerException ome) {
                block15: {
                    FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.UniqueKeyRangeManager.updateEntry", (String)"1:286:1.8", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Exception caught increasing range of unique key generator!", (Object)ome);
                    }
                    if (transaction != null) {
                        try {
                            transaction.backout(false);
                        }
                        catch (ObjectManagerException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.UniqueKeyRangeManager.updateEntry", (String)"1:298:1.8", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block15;
                            SibTr.event((TraceComponent)tc, (String)"Exception caught backing out unique key generator update!", (Object)e);
                        }
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"updateEntry");
                }
                throw new PersistenceException("Exception caught increasing range of unique key generator!", (Throwable)ome);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.event((TraceComponent)tc, (String)("No UniqueKeyGenerator matching: " + generator.getName() + " found to update!"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateEntry");
        }
        throw new PersistenceException("No UniqueKeyGenerator matching: " + generator.getName() + " found to update!");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateEntry", (Object)("return=" + currentLimit));
        }
        return currentLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"run");
        }
        UniqueKeyGenerator generator = null;
        while (this._running) {
            java.util.LinkedList linkedList = this._asyncQ;
            synchronized (linkedList) {
                while (this._asyncQ.isEmpty()) {
                    try {
                        this._asyncQ.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this._running) continue;
                    return;
                }
                generator = (UniqueKeyGenerator)this._asyncQ.removeFirst();
            }
            try {
                this.updateEntry(generator);
            }
            catch (PersistenceException pe) {
                FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.UniqueKeyRangeManager.run", (String)"1:366:1.8", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) continue;
                SibTr.event((TraceComponent)tc, (String)"Exception caught asynchronously increasing range of unique key generator!", (Object)((Object)pe));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"run");
        }
    }
}

