/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.parameter;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.ObjectWriter;
import io.smallrye.openapi.runtime.io.content.ContentWriter;
import io.smallrye.openapi.runtime.io.example.ExampleWriter;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.io.schema.SchemaWriter;
import io.smallrye.openapi.runtime.util.StringUtil;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;

public class ParameterWriter {
    private ParameterWriter() {
    }

    public static void writeParameters(ObjectNode parent, Map<String, Parameter> parameters) {
        if (parameters == null) {
            return;
        }
        ObjectNode parametersNode = parent.putObject("parameters");
        for (Map.Entry<String, Parameter> entry : parameters.entrySet()) {
            ParameterWriter.writeParameter(parametersNode, entry.getValue(), entry.getKey());
        }
    }

    private static void writeParameter(ObjectNode parent, Parameter model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        ParameterWriter.writeParameter(node, model);
    }

    public static void writeParameterList(ObjectNode parent, List<Parameter> models) {
        if (models == null) {
            return;
        }
        ArrayNode node = parent.putArray("parameters");
        for (Parameter model : models) {
            ObjectNode paramNode = node.addObject();
            ParameterWriter.writeParameter(paramNode, model);
        }
    }

    private static void writeParameter(ObjectNode node, Parameter model) {
        if (StringUtil.isNotEmpty(model.getRef())) {
            JsonUtil.stringProperty(node, "$ref", model.getRef());
        } else {
            JsonUtil.stringProperty(node, "name", model.getName());
            JsonUtil.enumProperty(node, "in", model.getIn());
            JsonUtil.stringProperty(node, "description", model.getDescription());
            JsonUtil.booleanProperty(node, "required", model.getRequired());
            SchemaWriter.writeSchema(node, model.getSchema(), "schema");
            JsonUtil.booleanProperty(node, "allowEmptyValue", model.getAllowEmptyValue());
            JsonUtil.booleanProperty(node, "deprecated", model.getDeprecated());
            JsonUtil.enumProperty(node, "style", model.getStyle());
            JsonUtil.booleanProperty(node, "explode", model.getExplode());
            JsonUtil.booleanProperty(node, "allowReserved", model.getAllowReserved());
            ObjectWriter.writeObject(node, "example", model.getExample());
            ExampleWriter.writeExamples(node, model.getExamples());
            ContentWriter.writeContent(node, model.getContent());
            ExtensionWriter.writeExtensions(node, model);
        }
    }
}

