/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmispec.util;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.yoko.rmispec.util.UtilLoader;
import org.omg.CORBA.INITIALIZE;

public enum DelegateType {
    UTIL("javax.rmi.CORBA.UtilClass", "org.apache.yoko.rmi.impl.UtilImpl"),
    STUB("javax.rmi.CORBA.StubClass", "org.apache.yoko.rmi.impl.StubImpl"),
    PRO("javax.rmi.CORBA.PortableRemoteObjectClass", "org.apache.yoko.rmi.impl.PortableRemoteObjectImpl"),
    STUB_INIT("org.apache.yoko.rmi.RMIStubInitializerClass", "org.apache.yoko.rmi.impl.RMIStubInitializer");

    private static final Set<Object> delegateClassLoaders;
    private final String key;
    private final String defaultClassName;

    public static boolean isDelegateClassLoader(ClassLoader cl) {
        return delegateClassLoaders.contains(cl);
    }

    private DelegateType(String key, String defaultClassName) {
        this.key = key;
        this.defaultClassName = defaultClassName;
    }

    public <U> PrivilegedExceptionAction<Constructor<? extends U>> getConstructorAction() {
        return () -> {
            String delegateName = System.getProperty(this.key, this.defaultClassName);
            try {
                Class delegateClass = UtilLoader.loadServiceClass(delegateName, this.key);
                Constructor constructor = delegateClass.getConstructor(new Class[0]);
                ClassLoader classLoader = DelegateType.doPriv(delegateClass::getClassLoader);
                if (null != classLoader) {
                    delegateClassLoaders.add(classLoader);
                }
                return constructor;
            }
            catch (Exception e) {
                throw (INITIALIZE)new INITIALIZE("Can not create delegate: '" + delegateName + "' for key: '" + this.key + "'").initCause((Throwable)e);
            }
        };
    }

    private static <T> T doPriv(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }

    static {
        delegateClassLoaders = Collections.synchronizedSet(new HashSet());
    }
}

