/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;

public final class Classes {
    static final Classes INSTANCE = new Classes();

    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        return INSTANCE.registerObservers(openTelemetry, ManagementFactory.getClassLoadingMXBean());
    }

    List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, ClassLoadingMXBean classBean) {
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
        observables.add(meter.counterBuilder("jvm.class.loaded").setDescription("Number of classes loaded since JVM start.").setUnit("{class}").buildWithCallback(observableMeasurement -> observableMeasurement.record(classBean.getTotalLoadedClassCount())));
        observables.add(meter.counterBuilder("jvm.class.unloaded").setDescription("Number of classes unloaded since JVM start.").setUnit("{class}").buildWithCallback(observableMeasurement -> observableMeasurement.record(classBean.getUnloadedClassCount())));
        observables.add(meter.upDownCounterBuilder("jvm.class.count").setDescription("Number of classes currently loaded.").setUnit("{class}").buildWithCallback(observableMeasurement -> observableMeasurement.record(classBean.getLoadedClassCount())));
        return observables;
    }

    private Classes() {
    }
}

