/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.MultiLogRecordProcessor;
import io.opentelemetry.sdk.logs.NoopLogRecordProcessor;
import io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface LogRecordProcessor
extends Closeable {
    public static LogRecordProcessor composite(LogRecordProcessor ... processors) {
        return LogRecordProcessor.composite(Arrays.asList(processors));
    }

    public static LogRecordProcessor composite(Iterable<LogRecordProcessor> processors) {
        ArrayList<LogRecordProcessor> processorList = new ArrayList<LogRecordProcessor>();
        for (LogRecordProcessor processor : processors) {
            processorList.add(processor);
        }
        if (processorList.isEmpty()) {
            return NoopLogRecordProcessor.getInstance();
        }
        if (processorList.size() == 1) {
            return (LogRecordProcessor)processorList.get(0);
        }
        return MultiLogRecordProcessor.create(processorList);
    }

    public void onEmit(Context var1, ReadWriteLogRecord var2);

    default public CompletableResultCode shutdown() {
        return this.forceFlush();
    }

    default public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

