/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.document.Jsp2Dom;
import com.ibm.ws.jsp.translator.visitor.JspVisitor;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorCollection;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JspTranslator {
    protected JspInputSource inputSource = null;
    protected Jsp2Dom jsp2Dom = null;
    protected Document jspDocument = null;
    protected JspCoreContext context = null;
    protected JspConfiguration jspConfiguration = null;
    protected JspOptions jspOptions = null;
    protected JspVisitorCollection jspVisitorCollection = null;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.JspTranslator";
    static final long serialVersionUID = 5875263973623831914L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    JspTranslator(JspInputSource inputSource, JspCoreContext context, JspConfiguration jspConfiguration, JspOptions jspOptions, JspVisitorCollection jspVisitorCollection) throws JspCoreException {
        this(inputSource, context, jspConfiguration, jspOptions, jspVisitorCollection, new HashMap());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{inputSource, context, jspConfiguration, jspOptions, jspVisitorCollection});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    JspTranslator(JspInputSource inputSource, JspCoreContext context, JspConfiguration jspConfiguration, JspOptions jspOptions, JspVisitorCollection jspVisitorCollection, Map implicitTagLibMap) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "Constructor", inputSource.getRelativeURL());
        }
        this.inputSource = inputSource;
        this.context = context;
        this.jspConfiguration = jspConfiguration;
        this.jspOptions = jspOptions;
        this.jspVisitorCollection = jspVisitorCollection;
        this.jsp2Dom = new Jsp2Dom(inputSource, context, jspConfiguration, jspOptions, implicitTagLibMap);
        this.jspDocument = this.jsp2Dom.getJspDocument();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "Constructor", inputSource.getRelativeURL());
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HashMap processVisitors() throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "processVisitors", new Object[0]);
        }
        HashMap hashMap = this.processVisitors(new JspVisitorInputMap());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            hashMap = hashMap;
            logger.exiting(CLASS_NAME, "processVisitors", hashMap);
        }
        return hashMap;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HashMap processVisitors(JspVisitorInputMap jspVisitorInput) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "processVisitors", this.inputSource.getRelativeURL());
        }
        jspVisitorInput.put("StaticIncludeDependencyList", this.jsp2Dom.getDependencyList());
        jspVisitorInput.put("CdataJspIdMap", this.jsp2Dom.getCdataJspIdMap());
        HashMap<String, JspVisitorResult> resultsMap = new HashMap<String, JspVisitorResult>();
        try {
            TreeMap<Integer, JspVisitorUsage> sortedMap = new TreeMap<Integer, JspVisitorUsage>();
            for (JspVisitorUsage usage : this.jspVisitorCollection.getJspVisitorUsageList()) {
                try {
                    Integer order = new Integer(usage.getOrder());
                    sortedMap.put(order, usage);
                }
                catch (NumberFormatException e) {
                    throw new JspTranslationException("jsp.error.building.visitor.order", e);
                }
            }
            for (Integer key : sortedMap.keySet()) {
                JspVisitorUsage usage = (JspVisitorUsage)sortedMap.get(key);
                Class visitorClass = usage.getJspVisitorDefinition().getVisitorClass();
                Constructor constructor = visitorClass.getConstructor(JspVisitorUsage.class, JspConfiguration.class, JspCoreContext.class, HashMap.class, JspVisitorInputMap.class);
                JspVisitor visitor = (JspVisitor)constructor.newInstance(usage, this.jspConfiguration, this.context, resultsMap, jspVisitorInput);
                int visits = usage.getVisits();
                for (int i = 0; i < visits; ++i) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "processVisitors", "processing " + usage.getJspVisitorDefinition().getId() + " visitor - visit[" + (i + 1) + "] for " + this.inputSource.getRelativeURL());
                    }
                    visitor.visit(this.jspDocument, i + 1);
                }
                resultsMap.put(usage.getJspVisitorDefinition().getId(), visitor.getResult());
            }
        }
        catch (NoSuchMethodException e) {
            throw new JspTranslationException(e);
        }
        catch (InstantiationException e) {
            throw new JspTranslationException(e);
        }
        catch (InvocationTargetException e) {
            throw new JspTranslationException(e);
        }
        catch (IllegalAccessException e) {
            throw new JspTranslationException(e);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.exiting(CLASS_NAME, "processVisitors", this.inputSource.getRelativeURL());
            }
        }
        return resultsMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Document getDocument() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getDocument", new Object[0]);
        }
        Document document = this.jspDocument;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            document = document;
            logger.exiting(CLASS_NAME, "getDocument", document);
        }
        return document;
    }
}

