/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.netty.timeout.exception;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class TimeoutException
extends IOException {
    private static final TraceComponent tc = Tr.register(TimeoutException.class, (String)"Netty", (String)"io.openliberty.netty.internal.impl.resources.NettyFrameworkMessages");
    private static final long serialVersionUID = 1L;
    private final String code;
    private final long duration;
    private final TimeUnit unit;

    public TimeoutException(String warningCode, long duration, TimeUnit unit) {
        super(TimeoutException.normalize(duration, unit));
        this.code = warningCode;
        this.duration = duration;
        this.unit = unit;
    }

    private static String normalize(long duration, TimeUnit unit) {
        String shorthand;
        boolean singular = duration == 1L;
        switch (unit) {
            case DAYS: {
                shorthand = singular ? "day" : "days";
                break;
            }
            case HOURS: {
                shorthand = singular ? "hour" : "hours";
                break;
            }
            case MINUTES: {
                shorthand = singular ? "minute" : "minutes";
                break;
            }
            case SECONDS: {
                shorthand = singular ? "second" : "seconds";
                break;
            }
            case MICROSECONDS: {
                shorthand = "\u00b5s";
                break;
            }
            case MILLISECONDS: {
                shorthand = "ms";
                break;
            }
            case NANOSECONDS: {
                shorthand = "ns";
                break;
            }
            default: {
                shorthand = unit.name().toLowerCase();
            }
        }
        return duration + " " + shorthand;
    }
}

