/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.launch.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.internal.LauncherDelegate;
import com.ibm.ws.kernel.launch.internal.FrameworkConfigurator;
import com.ibm.ws.kernel.launch.internal.FrameworkManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.TextFileOutputStreamFactory;
import com.ibm.wsspi.logprovider.LogProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LauncherDelegateImpl
implements LauncherDelegate {
    private final BootstrapConfig config;
    private FrameworkManager manager;
    private final CountDownLatch managerLatch;
    private final TextFileOutputStreamFactory fileStreamFactory;
    static final long serialVersionUID = 3622509435815315622L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public LauncherDelegateImpl(BootstrapConfig config) {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{config});
        }
        this.manager = null;
        this.managerLatch = new CountDownLatch(1);
        this.config = config;
        this.fileStreamFactory = new TextFileOutputStreamFactory(){
            static final long serialVersionUID = 5581222731678888457L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{LauncherDelegateImpl.this});
                }
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
                }
            }

            @Trivial
            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            public FileOutputStream createOutputStream(File file) throws IOException {
                return com.ibm.ws.kernel.boot.logging.TextFileOutputStreamFactory.createOutputStream(file);
            }

            @Trivial
            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            public FileOutputStream createOutputStream(File file, boolean append) throws IOException {
                return com.ibm.ws.kernel.boot.logging.TextFileOutputStreamFactory.createOutputStream(file, append);
            }

            @Trivial
            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            public FileOutputStream createOutputStream(String name) throws IOException {
                return com.ibm.ws.kernel.boot.logging.TextFileOutputStreamFactory.createOutputStream(name);
            }

            @Trivial
            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            public FileOutputStream createOutputStream(String name, boolean append) throws IOException {
                return com.ibm.ws.kernel.boot.logging.TextFileOutputStreamFactory.createOutputStream(name, append);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.launch.internal.LauncherDelegateImpl$1", 1.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
            }
        };
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public void launchFramework() {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"launchFramework", (Object[])new Object[0]);
        }
        ClassLoader loader = this.config.getFrameworkClassloader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        try {
            LogProvider provider = this.getLogProviderImpl(loader, this.config);
            this.manager = new FrameworkManager();
            this.managerLatch.countDown();
            FrameworkConfigurator.configure(this.config);
            this.doFrameworkLaunch(provider);
        }
        catch (LaunchException provider) {
            void le;
            FFDCFilter.processException((Throwable)provider, (String)"com.ibm.ws.kernel.launch.internal.LauncherDelegateImpl", (String)"103", (Object)this, (Object[])new Object[0]);
            throw le;
        }
        catch (RuntimeException le) {
            void re;
            FFDCFilter.processException((Throwable)le, (String)"com.ibm.ws.kernel.launch.internal.LauncherDelegateImpl", (String)"105", (Object)this, (Object[])new Object[0]);
            throw re;
        }
        catch (Throwable re) {
            void e;
            FFDCFilter.processException((Throwable)re, (String)"com.ibm.ws.kernel.launch.internal.LauncherDelegateImpl", (String)"107", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)e);
        }
        finally {
            this.managerLatch.countDown();
        }
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"launchFramework");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    protected void doFrameworkLaunch(LogProvider provider) {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"doFrameworkLaunch", (Object[])new Object[]{provider});
        }
        this.manager.launchFramework(this.config, provider);
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"doFrameworkLaunch");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public boolean waitForReady() throws InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"waitForReady", (Object[])new Object[0]);
        }
        this.managerLatch.await();
        boolean bl = this.manager == null ? false : this.manager.waitForReady();
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            bl = bl;
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"waitForReady", (Object)bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public boolean shutdown() throws InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"shutdown", (Object[])new Object[0]);
        }
        boolean bl = this.shutdown(false);
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            bl = bl;
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"shutdown", (Object)bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public boolean shutdown(boolean force) throws InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"shutdown", (Object[])new Object[]{force});
        }
        this.managerLatch.await();
        if (this.manager == null) {
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                bl = bl;
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"shutdown", (Object)bl);
            }
            return bl;
        }
        this.manager.shutdownCommand(force);
        this.manager.waitForShutdown();
        boolean bl = true;
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            bl = bl;
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"shutdown", (Object)bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public Set<String> queryFeatureInformation(String osRequest) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"queryFeatureInformation", (Object[])new Object[]{osRequest});
        }
        if (this.manager != null) {
            Set<String> set = this.manager.queryFeatureInformation(osRequest);
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                set = set;
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"queryFeatureInformation", set);
            }
            return set;
        }
        throw new IllegalStateException("Framework is not launched.");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public Set<String> queryFeatureNames() {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"queryFeatureNames", (Object[])new Object[0]);
        }
        if (this.manager != null) {
            Set<String> set = this.manager.queryFeatureNames();
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                set = set;
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"queryFeatureNames", set);
            }
            return set;
        }
        throw new IllegalStateException("Framework is not launched.");
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    protected LogProvider getLogProviderImpl(ClassLoader loader, BootstrapConfig config) {
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"getLogProviderImpl", (Object[])new Object[]{loader, config});
        }
        String providerClassName = config.getKernelResolver().getLogProvider();
        LogProvider p = null;
        try {
            Class<?> providerClass = loader.loadClass(providerClassName);
            if (providerClass != null) {
                p = (LogProvider)providerClass.newInstance();
                p.configure((Map)new ReadOnlyFrameworkProperties(config), config.getLogDirectory(), this.fileStreamFactory);
            }
        }
        catch (RuntimeException providerClass) {
            void e;
            FFDCFilter.processException((Throwable)providerClass, (String)"com.ibm.ws.kernel.launch.internal.LauncherDelegateImpl", (String)"201", (Object)this, (Object[])new Object[]{loader, config});
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.kernel.launch.internal.LauncherDelegateImpl", (String)"204", (Object)this, (Object[])new Object[]{loader, config});
            throw new RuntimeException("Could not create framework configurator", e);
        }
        LogProvider logProvider = p;
        if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
            logProvider = logProvider;
            Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"getLogProviderImpl", (Object)logProvider);
        }
        return logProvider;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.launch.internal.LauncherDelegateImpl", LauncherDelegateImpl.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class ReadOnlyFrameworkProperties
    implements Map<String, String> {
        final BootstrapConfig wrappedCfg;
        static final long serialVersionUID = -2017022226688172226L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        ReadOnlyFrameworkProperties(BootstrapConfig cfg) {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{cfg});
            }
            this.wrappedCfg = cfg;
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
            }
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public void clear() {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"clear", (Object[])new Object[0]);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public boolean containsKey(Object key) {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"containsKey", (Object[])new Object[]{key});
            }
            if (key instanceof String) {
                boolean bl = this.wrappedCfg.get((String)key) != null;
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    bl = bl;
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"containsKey", (Object)bl);
                }
                return bl;
            }
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                bl = bl;
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"containsKey", (Object)bl);
            }
            return bl;
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public boolean containsValue(Object value) {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"containsValue", (Object[])new Object[]{value});
            }
            throw new UnsupportedOperationException();
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public Set<Map.Entry<String, String>> entrySet() {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"entrySet", (Object[])new Object[0]);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public String get(Object key) {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"get", (Object[])new Object[]{key});
            }
            if (key instanceof String) {
                String string = this.wrappedCfg.get((String)key);
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    string = string;
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"get", (Object)string);
                }
                return string;
            }
            String string = null;
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                string = string;
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"get", string);
            }
            return string;
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public boolean isEmpty() {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"isEmpty", (Object[])new Object[0]);
            }
            boolean bl = false;
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                bl = bl;
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"isEmpty", (Object)bl);
            }
            return bl;
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public Set<String> keySet() {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"keySet", (Object[])new Object[0]);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public String put(String key, String value) {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"put", (Object[])new Object[]{key, value});
            }
            String string = this.wrappedCfg.put(key, value);
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                string = string;
                Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"put", (Object)string);
            }
            return string;
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public void putAll(Map<? extends String, ? extends String> m) {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"putAll", (Object[])new Object[]{m});
            }
            throw new UnsupportedOperationException();
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public String remove(Object key) {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"remove", (Object[])new Object[]{key});
            }
            throw new UnsupportedOperationException();
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public int size() {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"size", (Object[])new Object[0]);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        public Collection<String> values() {
            if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"values", (Object[])new Object[0]);
            }
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.launch.internal.LauncherDelegateImpl$ReadOnlyFrameworkProperties", ReadOnlyFrameworkProperties.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
        }
    }
}

