/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.utility.utils;

import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.security.utility.utils.CommandUtils;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class SAFEncryptionKey {
    private String keyring;
    private String type;
    private String label;
    private static final String racfPass = "password";
    private KeyStore keystore = null;
    private static final String PREFIX_SAFKEYRING = "safkeyring:";
    private static final String PREFIX_SAFKEYRINGHYBRID = "safkeyringhybrid:";
    private static final String PREFIX_SAFKEYRINGHW = "safkeyringhw:";
    private static final String PREFIX_SAFKEYRINGJCE = "safkeyringjce:";
    private static final String PREFIX_SAFKEYRINGJCEHYBRID = "safkeyringjcehybrid:";
    private static final String PREFIX_SAFKEYRINGJCECCA = "safkeyringjcecca:";
    Pattern safKeyringPatternTwoSlashes = Pattern.compile("(safkeyring|(safkeyringhw|safkeyringhybrid|safkeyringjce|safkeyringjcehybrid|safkeyringjcecca))://\\w.*");
    Pattern safKeyringPatternThreeSlashes = Pattern.compile("(safkeyring|(safkeyringhw|safkeyringhybrid|safkeyringjce|safkeyringjcehybrid|safkeyringjcecca))://.*/\\w.*");
    private final Map<String, String> handlers = new HashMap<String, String>();

    public SAFEncryptionKey(String saf_keyring, String saf_type, String saf_label) throws Exception {
        if (saf_keyring != null) {
            this.keyring = saf_keyring;
        }
        if (saf_type != null) {
            this.type = saf_type;
        }
        if (saf_label != null) {
            this.label = saf_label;
        }
        if (JavaInfo.majorVersion() < 11) {
            this.setSAFHandlers();
        }
        this.validateConfig();
    }

    protected String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    public void setSAFHandlers() {
        this.handlers.put("safkeyring", "com.ibm.crypto.provider.safkeyring.Handler");
        this.handlers.put("safkeyringhw", "com.ibm.crypto.hdwrCCA.provider.safkeyring.Handler");
        this.handlers.put("safkeyringhybrid", "com.ibm.crypto.ibmjcehybrid.provider.safkeyring.Handler");
    }

    private void validateConfig() throws Exception {
        block6: {
            this.keystore = this.loadKeyStore();
            X509Certificate certEntry = null;
            if (this.keystore != null) {
                if (!this.keystore.containsAlias(this.label)) {
                    String msg = this.getMessage("saf.label.does.not.exist", this.label, this.keyring);
                    throw new Exception(msg);
                }
                if (!this.keystore.isKeyEntry(this.label)) {
                    String msg = "The " + this.label + " certificate is not a key entry.  The certificate needs to be a key entry for use as an AES password encryption key.";
                    throw new Exception(msg);
                }
                certEntry = (X509Certificate)this.keystore.getCertificate(this.label);
                if (!this.checkIfCertDateIsGood(certEntry)) {
                    String msg = this.getMessage("saf.cert.expired", this.label);
                    throw new Exception(msg);
                }
                break block6;
            }
            String msg = this.getMessage("saf.keyring.does.not.exist", this.keyring);
            throw new Exception(msg);
        }
    }

    private boolean checkIfCertDateIsGood(X509Certificate cert) {
        if (cert != null) {
            long currentTime = System.currentTimeMillis();
            long notAfter = cert.getNotAfter().getTime();
            return notAfter >= currentTime;
        }
        return false;
    }

    private InputStream openKeyStoreURL() throws Exception {
        URLStreamHandler handler = null;
        URL url = null;
        String effectiveLocation = this.processKeyringURL(this.keyring);
        if (JavaInfo.majorVersion() < 11) {
            if (effectiveLocation != null) {
                try {
                    String keyringPrefix = effectiveLocation.substring(0, effectiveLocation.indexOf(":"));
                    String jceHandler = this.handlers.get(keyringPrefix.toLowerCase());
                    handler = (URLStreamHandler)Class.forName(jceHandler).newInstance();
                }
                catch (Exception e) {
                    String msg = "Failed to set SAF handler associated with the keyring: " + effectiveLocation + ".  Extended error: " + e.getMessage();
                    throw new Exception(msg);
                }
            }
            url = new URL(null, effectiveLocation, handler);
        } else {
            url = new URL(effectiveLocation);
        }
        InputStream fis = url.openStream();
        return fis;
    }

    private KeyStore loadKeyStore() throws Exception {
        try {
            KeyStore ks = KeyStore.getInstance(this.type);
            InputStream is = this.openKeyStoreURL();
            ks.load(is, racfPass.toCharArray());
            return ks;
        }
        catch (Exception e) {
            String msg = "An exception occured when loading the " + this.keyring + " SAF key ring.  No key can be retrieved to use as the AES password encryption key.  Extended error is: " + e.getMessage();
            throw new Exception(msg);
        }
    }

    private String processKeyringURL(String safKeyringURL) {
        String processedUrl = null;
        if (safKeyringURL != null) {
            if (this.safKeyringPatternThreeSlashes.matcher(safKeyringURL).matches()) {
                processedUrl = safKeyringURL;
            } else if (this.safKeyringPatternTwoSlashes.matcher(safKeyringURL).matches()) {
                int index = safKeyringURL.indexOf("//");
                StringBuffer sb = new StringBuffer(safKeyringURL);
                sb.insert(index, "/");
                processedUrl = sb.toString();
            }
            String replacePrefix = null;
            if (processedUrl != null) {
                if (JavaInfo.majorVersion() >= 11) {
                    if (processedUrl.startsWith(PREFIX_SAFKEYRING)) {
                        replacePrefix = PREFIX_SAFKEYRINGJCE;
                    } else if (processedUrl.startsWith(PREFIX_SAFKEYRINGHYBRID)) {
                        replacePrefix = PREFIX_SAFKEYRINGJCEHYBRID;
                    } else if (processedUrl.startsWith(PREFIX_SAFKEYRINGHW)) {
                        replacePrefix = PREFIX_SAFKEYRINGJCECCA;
                    }
                } else if (processedUrl.startsWith(PREFIX_SAFKEYRINGJCE)) {
                    replacePrefix = PREFIX_SAFKEYRING;
                } else if (processedUrl.startsWith(PREFIX_SAFKEYRINGJCEHYBRID)) {
                    replacePrefix = PREFIX_SAFKEYRINGHYBRID;
                } else if (processedUrl.startsWith(PREFIX_SAFKEYRINGJCECCA)) {
                    replacePrefix = PREFIX_SAFKEYRINGHW;
                }
                if (replacePrefix != null) {
                    int index = processedUrl.indexOf(":");
                    String removedPrefix = processedUrl.substring(index + 1);
                    processedUrl = replacePrefix + removedPrefix;
                }
            }
        }
        return processedUrl;
    }

    public String getKey() throws Exception {
        Key key = null;
        Key privKey = null;
        try {
            if (this.keystore != null && this.label != null && (key = this.keystore.getKey(this.label, racfPass.toCharArray())) instanceof PrivateKey) {
                privKey = (PrivateKey)key;
            }
        }
        catch (Exception e) {
            String msg = "An exception occurred during the " + this.label + " private key access.  No key can be retrieved for use as the AES password encryption key.  Extended error: " + e.getMessage();
            throw new Exception(msg);
        }
        byte[] keyBytes = privKey.getEncoded();
        String keyString = new String(keyBytes);
        return keyString;
    }
}

