/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.netty.channel;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.RecvByteBufAllocator;
import java.net.SocketAddress;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LoggingRecvByteBufAllocator
implements RecvByteBufAllocator {
    private static final TraceComponent tc = Tr.register(LoggingRecvByteBufAllocator.class, (String)"TCPChannel", (String)"Netty");
    private final RecvByteBufAllocator delegate;
    static final long serialVersionUID = -1968698693829206223L;

    public LoggingRecvByteBufAllocator(RecvByteBufAllocator delegate) {
        this.delegate = delegate;
    }

    public RecvByteBufAllocator.Handle newHandle() {
        return new LoggingHandle(this.delegate.newHandle());
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class LoggingHandle
    implements RecvByteBufAllocator.Handle {
        private final RecvByteBufAllocator.Handle delegateHandle;
        private ChannelHandlerContext context;
        static final long serialVersionUID = -6756895050757650030L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        LoggingHandle(RecvByteBufAllocator.Handle handle) {
            this.delegateHandle = handle;
        }

        public void setChannelHandlerContext(ChannelHandlerContext context) {
            this.context = context;
        }

        public ByteBuf allocate(ByteBufAllocator allocator) {
            if (this.context != null) {
                SocketAddress localAddress = this.context.channel().localAddress();
                SocketAddress remoteAddress = this.context.channel().remoteAddress();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this.context.channel(), (TraceComponent)tc, (String)("read (async) requested for local: " + localAddress + " remote: " + remoteAddress), (Object[])new Object[0]);
                }
            }
            return this.delegateHandle.allocate(allocator);
        }

        public void reset(ChannelConfig config) {
            this.delegateHandle.reset(config);
        }

        public int guess() {
            return this.delegateHandle.guess();
        }

        public void incMessagesRead(int numMessages) {
            this.delegateHandle.incMessagesRead(numMessages);
        }

        public void lastBytesRead(int bytes) {
            this.delegateHandle.lastBytesRead(bytes);
        }

        public int lastBytesRead() {
            return this.delegateHandle.lastBytesRead();
        }

        public boolean continueReading() {
            return this.delegateHandle.continueReading();
        }

        public void readComplete() {
            this.delegateHandle.readComplete();
        }

        public void attemptedBytesRead(int bytes) {
            this.delegateHandle.attemptedBytesRead(bytes);
        }

        public int attemptedBytesRead() {
            return this.delegateHandle.attemptedBytesRead();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.http.netty.channel.LoggingRecvByteBufAllocator$LoggingHandle", LoggingHandle.class, null, null);
        }
    }
}

