/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.metatype;

public enum SchemaVersion {
    v1_0("1.0"),
    v1_1("1.1");

    private String value;

    private SchemaVersion(String version) {
        this.value = SchemaVersion.getNormalizedVersion(version);
    }

    public String toString() {
        return this.value;
    }

    public static SchemaVersion getEnum(String version) {
        String normalizedVersion = SchemaVersion.getNormalizedVersion(version);
        for (SchemaVersion v : SchemaVersion.values()) {
            if (!v.value.equals(normalizedVersion)) continue;
            return v;
        }
        throw new IllegalArgumentException(version);
    }

    public static boolean isValid(String version) {
        try {
            SchemaVersion.getEnum(version);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return true;
    }

    public static String getNormalizedVersion(String version) {
        if (version == null) {
            version = "1.0";
        } else if ((version = version.trim()).length() == 0) {
            version = "1.0";
        }
        if (!version.contains(".")) {
            return version.concat(".0");
        }
        return version;
    }
}

