/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.matching.MessageProcessorMatching;
import com.ibm.ws.sib.processor.matching.MonitoredConsumer;
import com.ibm.ws.sib.processor.matching.WrappedConsumerSetChangeCallback;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSetChangeCallback;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConsumerMonitorRegistrar {
    private static final TraceComponent tc = SibTr.register(ConsumerMonitorRegistrar.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessor _messageProcessor;
    private MessageProcessorMatching _mpm;
    private Map _registeredExactConsumerMonitors = new HashMap();
    private Map _registeredWildcardConsumerMonitors = new HashMap();
    private Map _callbackIndex = new HashMap();

    public ConsumerMonitorRegistrar(MessageProcessor messageProcessor, MessageProcessorMatching mpm) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ConsumerMonitorRegistrar", (Object)new Object[]{messageProcessor, mpm});
        }
        this._messageProcessor = messageProcessor;
        this._mpm = mpm;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConsumerMonitorRegistrar", (Object)this);
        }
    }

    public boolean registerCallbackOnNewExpression(ConnectionImpl connection, String topicExpression, boolean isWildcarded, ConsumerSetChangeCallback callback, ArrayList matchingConsumers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerCallbackOnNewExpression", (Object)new Object[]{connection, topicExpression, new Boolean(isWildcarded), callback, matchingConsumers});
        }
        boolean areConsumers = false;
        this.addCallbackToConnectionIndex(connection, topicExpression, isWildcarded, callback);
        ArrayList<WrappedConsumerSetChangeCallback> callbackList = new ArrayList<WrappedConsumerSetChangeCallback>();
        WrappedConsumerSetChangeCallback wcb = new WrappedConsumerSetChangeCallback(callback);
        callbackList.add(wcb);
        RegisteredCallbacks regMonitor = new RegisteredCallbacks(callbackList, matchingConsumers);
        if (isWildcarded) {
            this._registeredWildcardConsumerMonitors.put(topicExpression, regMonitor);
        } else {
            this._registeredExactConsumerMonitors.put(topicExpression, regMonitor);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerCallbackOnNewExpression", (Object)new Boolean(areConsumers));
        }
        return areConsumers;
    }

    public void deregisterMonitor(ConnectionImpl connection, ConsumerSetChangeCallback callback) throws SINotPossibleInCurrentConfigurationException {
        TopicRecord tRecord;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterMonitor", (Object)new Object[]{connection, callback});
        }
        if ((tRecord = this.retrieveCallbackFromConnectionIndex(connection, callback)) != null) {
            if (tRecord.isWildcarded) {
                this.removeCallbackFromRegisteredMonitors(callback, tRecord.topicExpression, true, this._registeredWildcardConsumerMonitors);
            } else {
                this.removeCallbackFromRegisteredMonitors(callback, tRecord.topicExpression, false, this._registeredExactConsumerMonitors);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deregisterMonitor", (Object)callback);
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitorRegistrar", "1:237:1.10", callback});
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitorRegistrar", "1:244:1.10", callback}, null));
        }
        this.removeCallbackFromConnectionIndex(connection, callback);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterMonitor");
        }
    }

    public void removeConsumerSetMonitors(ConnectionImpl connection) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerSetMonitors", (Object)new Object[]{connection});
        }
        if (this._callbackIndex.containsKey(connection)) {
            HashMap connMap = (HashMap)this._callbackIndex.get(connection);
            for (Map.Entry entry : connMap.entrySet()) {
                TopicRecord tRecord;
                ConsumerSetChangeCallback callback = (ConsumerSetChangeCallback)entry.getKey();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Found registered callback: " + callback));
                }
                if ((tRecord = (TopicRecord)entry.getValue()) == null) continue;
                if (tRecord.isWildcarded) {
                    this.removeCallbackFromRegisteredMonitors(callback, tRecord.topicExpression, true, this._registeredWildcardConsumerMonitors);
                    continue;
                }
                this.removeCallbackFromRegisteredMonitors(callback, tRecord.topicExpression, false, this._registeredExactConsumerMonitors);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerSetMonitors");
        }
    }

    public void removeCallbackFromRegisteredMonitors(ConsumerSetChangeCallback callback, String topicExpression, boolean isWildcarded, Map registeredMonitorsMap) throws SINotPossibleInCurrentConfigurationException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeCallbackFromRegisteredMonitors", (Object)new Object[]{callback, topicExpression, new Boolean(isWildcarded)});
        }
        ArrayList matchingConsumerList = null;
        RegisteredCallbacks rMonitor = (RegisteredCallbacks)registeredMonitorsMap.get(topicExpression);
        if (rMonitor != null) {
            WrappedConsumerSetChangeCallback wcb;
            boolean cbRemoved;
            ArrayList callbackList = rMonitor.getWrappedCallbacks();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Found existing entry with callbacks: " + callbackList));
            }
            if (!(cbRemoved = callbackList.remove(wcb = new WrappedConsumerSetChangeCallback(callback)))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeCallbackFromRegisteredMonitors", (Object)callback);
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitorRegistrar", "1:372:1.10", callback});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitorRegistrar", "1:379:1.10", callback}, null));
            }
            if (callbackList.isEmpty()) {
                boolean areConsumers;
                matchingConsumerList = rMonitor.getMatchingConsumers();
                boolean bl = areConsumers = !matchingConsumerList.isEmpty();
                if (areConsumers) {
                    for (MonitoredConsumer mc : matchingConsumerList) {
                        boolean removed;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Remove registration from consumer: " + mc));
                        }
                        if (removed = isWildcarded ? mc.removeMatchingWildcardMonitor(topicExpression) : mc.removeMatchingExactMonitor(topicExpression)) continue;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"removeCallbackFromRegisteredMonitors", (Object)(mc + ":" + topicExpression));
                        }
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitorRegistrar", "1:425:1.10", mc + ":" + topicExpression});
                        throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitorRegistrar", "1:432:1.10", mc + ":" + topicExpression}, null));
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"No more callbacks for this topicexpression, delete record");
                }
                registeredMonitorsMap.remove(topicExpression);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeCallbackFromRegisteredMonitors", (Object)callback);
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitorRegistrar", "1:456:1.10", callback});
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitorRegistrar", "1:463:1.10", callback}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeCallbackFromRegisteredMonitors");
        }
    }

    public void matchNewExactConsumerToMonitors(String topicExpression, MonitoredConsumer mc) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"matchNewExactConsumerToMonitors", (Object)new Object[]{topicExpression, mc});
        }
        ArrayList<String> exactMonitorList = new ArrayList<String>();
        ArrayList<String> wildcardMonitorList = new ArrayList<String>();
        for (String registeredTopic : this._registeredExactConsumerMonitors.keySet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Found registered topic: " + registeredTopic));
            }
            if (!topicExpression.equals(registeredTopic)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"topics match, Add consumer to list");
            }
            this.addConsumerToMonitorList(registeredTopic, this._registeredExactConsumerMonitors, mc, false);
            exactMonitorList.add(registeredTopic);
        }
        for (String registeredTopic : this._registeredWildcardConsumerMonitors.keySet()) {
            String registeredTopicStem = this._mpm.retrieveNonWildcardStem(registeredTopic);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Found registered topic: " + registeredTopic + "with stem: " + registeredTopicStem));
            }
            if (!topicExpression.startsWith(registeredTopicStem)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Drive direct evaluation for topic: " + registeredTopic));
            }
            if (!this._mpm.evaluateDiscriminator(topicExpression, registeredTopic)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Add consumer to list");
            }
            this.addConsumerToMonitorList(registeredTopic, this._registeredWildcardConsumerMonitors, mc, true);
            wildcardMonitorList.add(registeredTopic);
        }
        mc.setMatchingExactMonitorList(exactMonitorList);
        mc.setMatchingWildcardMonitorList(wildcardMonitorList);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"matchNewExactConsumerToMonitors");
        }
    }

    public void matchNewWildcardConsumerToMonitors(String topicExpression, MonitoredConsumer mc) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"matchNewWildcardConsumerToMonitors", (Object)new Object[]{topicExpression, mc});
        }
        ArrayList<String> exactMonitorList = new ArrayList<String>();
        ArrayList<String> wildcardMonitorList = new ArrayList<String>();
        String stem = this._mpm.retrieveNonWildcardStem(topicExpression);
        for (String registeredTopic : this._registeredExactConsumerMonitors.keySet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Found registered topic: " + registeredTopic));
            }
            if (!registeredTopic.startsWith(stem)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Drive direct evaluation for topic: " + registeredTopic));
            }
            if (!this._mpm.evaluateDiscriminator(registeredTopic, topicExpression)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Add consumer to list");
            }
            this.addConsumerToMonitorList(registeredTopic, this._registeredExactConsumerMonitors, mc, false);
            exactMonitorList.add(registeredTopic);
        }
        for (String registeredTopic : this._registeredWildcardConsumerMonitors.keySet()) {
            String registeredTopicStem = this._mpm.retrieveNonWildcardStem(registeredTopic);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Found registered topic: " + registeredTopic + "with stem: " + registeredTopicStem));
            }
            if (registeredTopicStem.length() >= stem.length()) {
                if (!registeredTopicStem.startsWith(stem)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Topic expressions might overlap, add consumer to list");
                }
                this.addConsumerToMonitorList(registeredTopic, this._registeredWildcardConsumerMonitors, mc, true);
                wildcardMonitorList.add(registeredTopic);
                continue;
            }
            if (!stem.startsWith(registeredTopicStem)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Topic expressions might overlap, add consumer to list");
            }
            this.addConsumerToMonitorList(registeredTopic, this._registeredWildcardConsumerMonitors, mc, true);
            wildcardMonitorList.add(registeredTopic);
        }
        mc.setMatchingExactMonitorList(exactMonitorList);
        mc.setMatchingWildcardMonitorList(wildcardMonitorList);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"matchNewWildcardConsumerToMonitors");
        }
    }

    public void addConsumerToRegisteredMonitors(MonitoredConsumer mc, ArrayList exactMonitorList, ArrayList wildcardMonitorList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumerToRegisteredMonitors", (Object)new Object[]{mc, exactMonitorList, wildcardMonitorList});
        }
        this.addConsumerToRegisteredMonitorMap(mc, exactMonitorList, this._registeredExactConsumerMonitors);
        this.addConsumerToRegisteredMonitorMap(mc, wildcardMonitorList, this._registeredWildcardConsumerMonitors);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumerToRegisteredMonitors");
        }
    }

    private void addConsumerToRegisteredMonitorMap(MonitoredConsumer mc, ArrayList monitorList, Map registeredMonitors) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumerToRegisteredMonitorMap", (Object)new Object[]{registeredMonitors, mc, monitorList});
        }
        for (String tExpr : monitorList) {
            RegisteredCallbacks rMonitor = (RegisteredCallbacks)registeredMonitors.get(tExpr);
            ArrayList matchingConsumerList = rMonitor.getMatchingConsumers();
            matchingConsumerList.add(mc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumerToRegisteredMonitorMap");
        }
    }

    public void addConsumerToMonitorList(String registeredTopic, Map registeredMonitors, MonitoredConsumer mc, boolean isWildcarded) {
        RegisteredCallbacks rMonitor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumerToMonitorList", (Object)new Object[]{registeredTopic, registeredMonitors, mc, new Boolean(isWildcarded)});
        }
        if ((rMonitor = (RegisteredCallbacks)registeredMonitors.get(registeredTopic)) == null) {
            String mapType = "exact";
            if (isWildcarded) {
                mapType = "wildcard";
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addConsumerToMonitorList", (Object)(mapType + ":" + registeredTopic));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitorRegistrar", "1:844:1.10", mapType + ":" + registeredTopic});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitorRegistrar", "1:851:1.10", mapType + ":" + registeredTopic}, null));
        }
        ArrayList matchingConsumerList = rMonitor.getMatchingConsumers();
        if (matchingConsumerList.isEmpty()) {
            this.driveRegisteredCallbacks(rMonitor, false);
        }
        matchingConsumerList.add(mc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumerToMonitorList");
        }
    }

    public boolean checkExistingExpression(String topicExpression, boolean isWildcarded) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkExistingExpression", (Object)new Object[]{topicExpression, new Boolean(isWildcarded)});
        }
        boolean alreadyRegistered = false;
        if (isWildcarded) {
            if (this._registeredWildcardConsumerMonitors.containsKey(topicExpression)) {
                alreadyRegistered = true;
            }
        } else if (this._registeredExactConsumerMonitors.containsKey(topicExpression)) {
            alreadyRegistered = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkExistingExpression", (Object)new Boolean(alreadyRegistered));
        }
        return alreadyRegistered;
    }

    public boolean registerCallbackOnExistingExpression(ConnectionImpl connection, String topicExpression, boolean isWildcarded, ConsumerSetChangeCallback callback) {
        ArrayList consumerList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerCallbackOnExistingExpression", (Object)new Object[]{connection, topicExpression, new Boolean(isWildcarded), callback});
        }
        boolean areConsumers = false;
        RegisteredCallbacks rMonitor = null;
        this.addCallbackToConnectionIndex(connection, topicExpression, isWildcarded, callback);
        rMonitor = isWildcarded ? (RegisteredCallbacks)this._registeredWildcardConsumerMonitors.get(topicExpression) : (RegisteredCallbacks)this._registeredExactConsumerMonitors.get(topicExpression);
        ArrayList callbackList = rMonitor.getWrappedCallbacks();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Found existing entry with callbacks: " + callbackList));
        }
        WrappedConsumerSetChangeCallback wcb = new WrappedConsumerSetChangeCallback(callback);
        Iterator it = callbackList.iterator();
        boolean alreadyExisting = false;
        while (it.hasNext()) {
            WrappedConsumerSetChangeCallback tmpwcb = (WrappedConsumerSetChangeCallback)it.next();
            if (!tmpwcb.equals(wcb)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("The same callback is already registerd for the topic expression :" + topicExpression + " Hence registration will not be done!"));
            }
            alreadyExisting = true;
            break;
        }
        if (!alreadyExisting) {
            callbackList.add(wcb);
        }
        boolean bl = areConsumers = !(consumerList = rMonitor.getMatchingConsumers()).isEmpty();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerCallbackOnExistingExpression", (Object)new Boolean(areConsumers));
        }
        return areConsumers;
    }

    public void removeConsumerFromRegisteredMonitors(MonitoredConsumer mc, ArrayList exactMonitorList, ArrayList wildcardMonitorList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerFromRegisteredMonitors", (Object)new Object[]{mc, exactMonitorList, wildcardMonitorList});
        }
        this.removeConsumerFromRegisteredMonitorMap(mc, exactMonitorList, this._registeredExactConsumerMonitors);
        this.removeConsumerFromRegisteredMonitorMap(mc, wildcardMonitorList, this._registeredWildcardConsumerMonitors);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerFromRegisteredMonitors");
        }
    }

    private void removeConsumerFromRegisteredMonitorMap(MonitoredConsumer mc, ArrayList monitorList, Map registeredMonitors) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerFromRegisteredMonitorMap", (Object)new Object[]{registeredMonitors, mc, monitorList});
        }
        for (String tExpr : monitorList) {
            RegisteredCallbacks rMonitor;
            ArrayList matchingConsumerList;
            boolean removed;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Remove registration entry for consumer at: " + tExpr));
            }
            if (!(removed = (matchingConsumerList = (rMonitor = (RegisteredCallbacks)registeredMonitors.get(tExpr)).getMatchingConsumers()).remove(mc))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeConsumerFromRegisteredMonitorMap", (Object)(mc + ":" + tExpr));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitorRegistrar", "1:1067:1.10", mc + ":" + tExpr});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.matching.ConsumerMonitorRegistrar", "1:1074:1.10", mc + ":" + tExpr}, null));
            }
            if (!matchingConsumerList.isEmpty()) continue;
            this.driveRegisteredCallbacks(rMonitor, true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerFromRegisteredMonitorMap");
        }
    }

    private void driveRegisteredCallbacks(RegisteredCallbacks rMonitor, boolean isEmpty) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"driveRegisteredCallbacks", (Object)new Object[]{rMonitor, new Boolean(isEmpty)});
        }
        ArrayList callbackList = rMonitor.getWrappedCallbacks();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Iterate over wrapped callbacks");
        }
        for (WrappedConsumerSetChangeCallback wcb : callbackList) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Drive callback: " + wcb.getCallback()));
            }
            wcb.transitionEvent(isEmpty);
            try {
                this._messageProcessor.startNewThread(new AsynchThread(wcb));
            }
            catch (InterruptedException e) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"driveRegisteredCallbacks");
        }
    }

    public void addCallbackToConnectionIndex(ConnectionImpl connection, String topicExpression, boolean isWildcarded, ConsumerSetChangeCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addCallbackToConnectionIndex", (Object)new Object[]{connection, topicExpression, new Boolean(isWildcarded), callback});
        }
        HashMap connMap = null;
        if (this._callbackIndex.containsKey(connection)) {
            connMap = (HashMap)this._callbackIndex.get(connection);
        } else {
            connMap = new HashMap();
            this._callbackIndex.put(connection, connMap);
        }
        TopicRecord tRecord = new TopicRecord(topicExpression, isWildcarded);
        connMap.put(callback, tRecord);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addCallbackToConnectionIndex");
        }
    }

    public TopicRecord retrieveCallbackFromConnectionIndex(ConnectionImpl connection, ConsumerSetChangeCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"retrieveCallbackFromConnectionIndex", (Object)new Object[]{connection, callback});
        }
        TopicRecord tRecord = null;
        if (this._callbackIndex.containsKey(connection)) {
            HashMap connMap = (HashMap)this._callbackIndex.get(connection);
            tRecord = (TopicRecord)connMap.get(callback);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveCallbackFromConnectionIndex", tRecord);
        }
        return tRecord;
    }

    public TopicRecord removeCallbackFromConnectionIndex(ConnectionImpl connection, ConsumerSetChangeCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeCallbackFromConnectionIndex", (Object)new Object[]{connection, callback});
        }
        TopicRecord tRecord = null;
        if (this._callbackIndex.containsKey(connection)) {
            HashMap connMap = (HashMap)this._callbackIndex.get(connection);
            tRecord = (TopicRecord)connMap.remove(callback);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeCallbackFromConnectionIndex", tRecord);
        }
        return tRecord;
    }

    public int getExactSubsSize(String topicExpression) {
        RegisteredCallbacks rMonitor;
        ArrayList consumerList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExactSubsSize", (Object)topicExpression);
        }
        int numSubs = 0;
        if (!this._registeredExactConsumerMonitors.isEmpty() && this._registeredExactConsumerMonitors.containsKey(topicExpression) && (consumerList = (rMonitor = (RegisteredCallbacks)this._registeredExactConsumerMonitors.get(topicExpression)).getMatchingConsumers()) != null && !consumerList.isEmpty()) {
            numSubs = consumerList.size();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getExactSubsSize", (Object)new Integer(numSubs));
        }
        return numSubs;
    }

    public int getWildcardSubsSize(String topicExpression) {
        RegisteredCallbacks rMonitor;
        ArrayList consumerList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getWildcardSubsSize", (Object)topicExpression);
        }
        int numSubs = 0;
        if (!this._registeredWildcardConsumerMonitors.isEmpty() && this._registeredWildcardConsumerMonitors.containsKey(topicExpression) && (consumerList = (rMonitor = (RegisteredCallbacks)this._registeredWildcardConsumerMonitors.get(topicExpression)).getMatchingConsumers()) != null && !consumerList.isEmpty()) {
            numSubs = consumerList.size();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getWildcardSubsSize", (Object)new Integer(numSubs));
        }
        return numSubs;
    }

    public ArrayList getExactMonitorList(String topicExpression) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExactMonitorList", (Object)topicExpression);
        }
        ArrayList consumerList = null;
        if (!this._registeredExactConsumerMonitors.isEmpty() && this._registeredExactConsumerMonitors.containsKey(topicExpression)) {
            RegisteredCallbacks rMonitor = (RegisteredCallbacks)this._registeredExactConsumerMonitors.get(topicExpression);
            consumerList = rMonitor.getMatchingConsumers();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getExactMonitorList", consumerList);
        }
        return consumerList;
    }

    public ArrayList getWildcardMonitorList(String topicExpression) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getWildcardMonitorList", (Object)topicExpression);
        }
        ArrayList consumerList = null;
        if (!this._registeredWildcardConsumerMonitors.isEmpty() && this._registeredWildcardConsumerMonitors.containsKey(topicExpression)) {
            RegisteredCallbacks rMonitor = (RegisteredCallbacks)this._registeredWildcardConsumerMonitors.get(topicExpression);
            consumerList = rMonitor.getMatchingConsumers();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getWildcardMonitorList", consumerList);
        }
        return consumerList;
    }

    public int getExactCallbackListSize(String topicExpression) {
        RegisteredCallbacks rMonitor;
        ArrayList callbackList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExactCallbackListSize", (Object)topicExpression);
        }
        int numCallbacks = 0;
        if (!this._registeredExactConsumerMonitors.isEmpty() && this._registeredExactConsumerMonitors.containsKey(topicExpression) && (callbackList = (rMonitor = (RegisteredCallbacks)this._registeredExactConsumerMonitors.get(topicExpression)).getWrappedCallbacks()) != null && !callbackList.isEmpty()) {
            numCallbacks = callbackList.size();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getExactCallbackListSize", (Object)new Integer(numCallbacks));
        }
        return numCallbacks;
    }

    public int getWildcardCallbackListSize(String topicExpression) {
        RegisteredCallbacks rMonitor;
        ArrayList callbackList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getWildcardCallbackListSize", (Object)topicExpression);
        }
        int numCallbacks = 0;
        if (!this._registeredWildcardConsumerMonitors.isEmpty() && this._registeredWildcardConsumerMonitors.containsKey(topicExpression) && (callbackList = (rMonitor = (RegisteredCallbacks)this._registeredWildcardConsumerMonitors.get(topicExpression)).getWrappedCallbacks()) != null && !callbackList.isEmpty()) {
            numCallbacks = callbackList.size();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getWildcardCallbackListSize", (Object)new Integer(numCallbacks));
        }
        return numCallbacks;
    }

    private class RegisteredCallbacks {
        private ArrayList wrappedCallbacks;
        private ArrayList matchingConsumers;

        RegisteredCallbacks(ArrayList wrappedCallbacks, ArrayList matchingConsumers) {
            this.wrappedCallbacks = wrappedCallbacks;
            this.matchingConsumers = matchingConsumers;
        }

        public ArrayList getWrappedCallbacks() {
            return this.wrappedCallbacks;
        }

        public ArrayList getMatchingConsumers() {
            return this.matchingConsumers;
        }
    }

    private class TopicRecord {
        public String topicExpression;
        public boolean isWildcarded;

        TopicRecord(String topicExpression, boolean isWildcarded) {
            this.topicExpression = topicExpression;
            this.isWildcarded = isWildcarded;
        }
    }

    private class AsynchThread
    implements Runnable {
        private WrappedConsumerSetChangeCallback _wcb;

        AsynchThread(WrappedConsumerSetChangeCallback wcb) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AsynchThread", (Object)new Object[]{wcb});
            }
            this._wcb = wcb;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AsynchThread", (Object)this);
            }
        }

        @Override
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"run", (Object)this);
            }
            this._wcb.consumerSetChange();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"run");
            }
        }
    }
}

