/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.impl.store.items.SIMPItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public class AIProtocolItemStream
extends SIMPItemStream {
    private static final TraceComponent tc = SibTr.register(AIProtocolItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 1;
    private SIBUuid12 streamId;
    private boolean flushStarted;
    private PersistentTranId currentTranId;
    private boolean unableToOrder;

    public AIProtocolItemStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIProtocolItemStream");
        }
        this.streamId = null;
        this.flushStarted = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIProtocolItemStream", (Object)((Object)this));
        }
    }

    public AIProtocolItemStream(SIBUuid12 streamId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIProtocolItemStream", (Object)streamId);
        }
        this.streamId = streamId;
        this.flushStarted = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIProtocolItemStream", (Object)((Object)this));
        }
    }

    @Override
    public int getPersistentVersion() {
        return 1;
    }

    @Override
    public void getPersistentData(ObjectOutputStream oos) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)oos);
        }
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("streamId", this.streamId.toByteArray());
            hm.put("flushStarted", new Boolean(this.flushStarted));
            oos.writeObject(hm);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.AIProtocolItemStream.getPersistentData", (String)"1:146:1.26", (Object)((Object)this));
            SIErrorException e2 = new SIErrorException((Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)((Object)e2));
            }
            throw e2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    @Override
    public void restore(ObjectInputStream ois, int dataVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{ois, new Integer(dataVersion)});
        }
        this.checkPersistentVersionId(dataVersion);
        try {
            HashMap hm = (HashMap)ois.readObject();
            this.streamId = new SIBUuid12((byte[])hm.get("streamId"));
            this.flushStarted = (Boolean)hm.get("flushStarted");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.AIProtocolItemStream.restore", (String)"1:180:1.26", (Object)((Object)this));
            SIErrorException e2 = new SIErrorException((Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)((Object)e2));
            }
            throw e2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.taggedValue("streamId", (Object)this.streamId);
        writer.newLine();
        writer.taggedValue("flushStarted", (Object)this.flushStarted);
    }

    public SIBUuid12 getStreamId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamId", (Object)this.streamId);
        }
        return this.streamId;
    }

    public boolean isFlushStarted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isFlushStarted");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isFlushStarted", (Object)this.flushStarted);
        }
        return this.flushStarted;
    }

    public void setFlushStarted(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setFlushStarted", (Object)value);
        }
        this.flushStarted = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setFlushStarted");
        }
    }

    public PersistentTranId getOrderedActiveTran() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOrderedActiveTran");
            SibTr.exit((TraceComponent)tc, (String)"getOrderedActiveTran", (Object)this.currentTranId);
        }
        return this.currentTranId;
    }

    public boolean isUnableToOrder() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isUnableToOrder");
            SibTr.exit((TraceComponent)tc, (String)"isUnableToOrder", (Object)this.unableToOrder);
        }
        return this.unableToOrder;
    }

    public void setCurrentTransaction(SIMPItem msg, boolean isInDoubtOnRemoteConsumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCurrentTransaction", (Object)new Object[]{msg, isInDoubtOnRemoteConsumer});
        }
        if (this.currentTranId != null && !this.currentTranId.equals((Object)msg.getTransactionId())) {
            this.unableToOrder = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Unable to order. Transaction: " + msg.getTransactionId() + " Current:" + this.currentTranId));
            }
        } else {
            this.currentTranId = msg.getTransactionId();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCurrentTransaction");
        }
    }

    public void clearOrderedTran() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearOrderedTran");
            SibTr.exit((TraceComponent)tc, (String)"clearOrderedTran");
        }
        this.currentTranId = null;
    }
}

