/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.transactions;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public final class XidKey {
    private static final TraceComponent tc = SibTr.register(XidKey.class, (String)"SIBTransactions", (String)"com.ibm.ws.sib.transactions.CWSJSMessages");
    private final int hashCode;
    private final int formatId;
    private final byte[] globalTxId;
    private String cachedToString = null;
    private static final String[] hexValues = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    protected XidKey(int formatId, byte[] globalTxId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"XidKey", (Object)new Object[]{new Integer(formatId), globalTxId});
        }
        this.formatId = formatId;
        if (globalTxId == null) {
            this.globalTxId = null;
        } else {
            this.globalTxId = new byte[globalTxId.length];
            System.arraycopy(globalTxId, 0, this.globalTxId, 0, this.globalTxId.length);
        }
        this.hashCode = this.globalTxId.length > 3 ? ((globalTxId[globalTxId.length - 4] & 0xFF) << 24) + ((globalTxId[globalTxId.length - 3] & 0xFF) << 16) + ((globalTxId[globalTxId.length - 2] & 0xFF) << 8) + (globalTxId[globalTxId.length - 1] & 0xFF) : -1;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"XidKey", (Object)this);
        }
    }

    public XidKey(Xid xid) {
        this(xid.getFormatId(), xid.getGlobalTransactionId());
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"XidKey", (Object)xid);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"XidKey");
        }
    }

    public boolean equals(Object o) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"equals", (Object)o);
        }
        boolean returnValue = false;
        if (o instanceof XidKey) {
            XidKey xidkey = (XidKey)o;
            if (xidkey.formatId == this.formatId && Arrays.equals(xidkey.globalTxId, this.globalTxId)) {
                returnValue = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"equals", (Object)new Boolean(returnValue));
        }
        return returnValue;
    }

    public int hashCode() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hashCode");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hashCode", (Object)new Integer(this.hashCode));
        }
        return this.hashCode;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"toString");
        }
        if (this.cachedToString == null) {
            StringBuffer sb = new StringBuffer("XIDKey(format:");
            sb.append(Integer.toHexString(this.formatId));
            if (this.globalTxId == null) {
                sb.append(",global:null");
            } else {
                sb.append(",global:");
                for (int i = 0; i < this.globalTxId.length; ++i) {
                    sb.append(hexValues[this.globalTxId[i] >> 4 & 0xF]);
                    sb.append(hexValues[this.globalTxId[i] & 0xF]);
                }
            }
            this.cachedToString = sb.toString();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"toString", (Object)this.cachedToString);
        }
        return this.cachedToString;
    }
}

