/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.object.hpel;

import com.ibm.websphere.logging.hpel.reader.RepositoryPointer;
import java.util.Arrays;

public class RepositoryPointerImpl
implements RepositoryPointer {
    private static final long serialVersionUID = 2840589997089219493L;
    private final String[] instanceIds;
    private final String fileId;
    private final long recordOffset;

    public RepositoryPointerImpl(String[] instanceIds, String fileId, long recordPosition) {
        this.instanceIds = Arrays.copyOf(instanceIds, instanceIds.length);
        this.fileId = fileId;
        this.recordOffset = recordPosition;
    }

    public String[] getInstanceIds() {
        return this.instanceIds;
    }

    public String getFileId() {
        return this.fileId;
    }

    public long getRecordOffset() {
        return this.recordOffset;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileId == null ? 0 : this.fileId.hashCode());
        result = 31 * result + Arrays.hashCode(this.instanceIds);
        result = 31 * result + (int)(this.recordOffset ^ this.recordOffset >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryPointerImpl other = (RepositoryPointerImpl)obj;
        if (this.fileId == null ? other.fileId != null : !this.fileId.equals(other.fileId)) {
            return false;
        }
        if (!Arrays.equals(this.instanceIds, other.instanceIds)) {
            return false;
        }
        return this.recordOffset == other.recordOffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\" file: \"");
        for (String st : this.instanceIds) {
            sb.append(st);
            sb.append("/");
        }
        sb.append(this.fileId);
        sb.append("\" offset: ");
        sb.append(Long.toString(this.recordOffset));
        return sb.toString();
    }
}

