/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics50.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.library.Library;
import io.openliberty.cdi.spi.CDIExtensionMetadata;
import io.openliberty.microprofile.metrics50.helper.Util;
import io.openliberty.microprofile.metrics50.internal.MetricsConfig;
import io.openliberty.smallrye.metrics.cdi.adapters.LegacyMetricsExtensionAdapter;
import jakarta.enterprise.inject.spi.Extension;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.osgi.framework.VersionRange;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={CDIExtensionMetadata.class, SmallryeMetricsCDIMetadata.class}, configurationPid={"com.ibm.ws.microprofile.metrics"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM"})
public class SmallryeMetricsCDIMetadata
implements CDIExtensionMetadata {
    private static final TraceComponent tc = Tr.register(SmallryeMetricsCDIMetadata.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    private static final String SMALLRYE_METRICS_JAR_NAME = "io.openliberty.io.smallrye.metrics";
    private static final String SMALLRYE_METRICS_JAR_VERSION_RANGE = "[1.0,5.0)";
    private static final String MICROMETER_JAR_NAME = "io.openliberty.io.micrometer";
    private static final String MICROMETER_JAR_VERSION_RANGE = "[1.0,5.0)";
    private static final String LEGACY_METRICS_EXTENSION_CLASSNAME = "io.smallrye.metrics.legacyapi.LegacyMetricsExtension";
    private static final String LEGACY_METRIC_REGISTRY_ADAPTER_CLASSNAME = "io.smallrye.metrics.legacyapi.LegacyMetricRegistryAdapter";
    private static final String METRIC_REGISTRY_PRODUCER_CLASSNAME = "io.smallrye.metrics.MetricRegistryProducer";
    private static final String METRIC_PRODUCER_CLASSNAME = "io.smallrye.metrics.MetricProducer";
    private static final String SHARED_METRIC_REGISTRIES_CLASSNAME = "io.smallrye.metrics.SharedMetricRegistries";
    private static final String METRICS_REQUEST_HANDLER_CLASSNAME = "io.smallrye.metrics.MetricsRequestHandler";
    private static final String METRICS_REQUEST_HANDELER_RESPONDER_CLASSNAME = "io.smallrye.metrics.MetricsRequestHandler$Responder";
    private static final String APPLICATION_NAME_RESOLVER_CLASSNAME = "io.smallrye.metrics.setup.ApplicationNameResolver";
    private static final String FQ_PROMETHEUSCONFIG_PATH = "io.micrometer.prometheus.PrometheusConfig";
    private ClassLoadingService classLoadingService;
    private volatile Library sharedLib = null;
    private static boolean isSuccessfulActivation = true;
    private MetricsConfig metricsConfig;
    static final long serialVersionUID = -4762470505863977530L;

    public boolean isSuccessfulActivation() {
        return isSuccessfulActivation;
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> properties) {
        Tr.info((TraceComponent)tc, (String)"configurationChange.info.CWMMC0007I", (Object[])new Object[0]);
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) throws Exception {
        boolean isSharedLibAvailable;
        File smallRyeMetricsJarFile;
        try {
            smallRyeMetricsJarFile = this.resolveSmallRyeMetricsJar();
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"io.openliberty.microprofile.metrics50.internal.SmallryeMetricsCDIMetadata", (String)"112", (Object)this, (Object[])new Object[]{context, properties});
            isSuccessfulActivation = false;
            return;
        }
        ArrayList<File> classPath = new ArrayList<File>();
        classPath.add(smallRyeMetricsJarFile);
        boolean bl = isSharedLibAvailable = this.sharedLib != null;
        if (!isSharedLibAvailable) {
            try {
                File micrometerJarFile = this.resolveMicrometerJar();
                classPath.add(micrometerJarFile);
            }
            catch (FileNotFoundException micrometerJarFile) {
                FFDCFilter.processException((Throwable)micrometerJarFile, (String)"io.openliberty.microprofile.metrics50.internal.SmallryeMetricsCDIMetadata", (String)"130", (Object)this, (Object[])new Object[]{context, properties});
                isSuccessfulActivation = false;
                return;
            }
        }
        try {
            ClassLoader bundleAddOnCL;
            Util.BUNDLE_ADD_ON_CLASSLOADER = bundleAddOnCL = this.createBundleAddOnClassLoader(classPath, isSharedLibAvailable);
            this.loadSmallRyeClasses(bundleAddOnCL);
        }
        catch (IllegalStateException bundleAddOnCL) {
            FFDCFilter.processException((Throwable)bundleAddOnCL, (String)"io.openliberty.microprofile.metrics50.internal.SmallryeMetricsCDIMetadata", (String)"140", (Object)this, (Object[])new Object[]{context, properties});
            Tr.error((TraceComponent)tc, (String)"nullBundleAddOnClassLoader.error.CWMMC0011E", (Object[])new Object[0]);
            isSuccessfulActivation = false;
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"io.openliberty.microprofile.metrics50.internal.SmallryeMetricsCDIMetadata", (String)"146", (Object)this, (Object[])new Object[]{context, properties});
            Tr.error((TraceComponent)tc, (String)"missingSmallRyeClasses.error.CWMMC0012E", (Object[])new Object[0]);
            isSuccessfulActivation = false;
        }
        catch (NoClassDefFoundError e) {
            FFDCFilter.processException((Throwable)e, (String)"io.openliberty.microprofile.metrics50.internal.SmallryeMetricsCDIMetadata", (String)"153", (Object)this, (Object[])new Object[]{context, properties});
            Tr.error((TraceComponent)tc, (String)"missingDependencyClasses.error.CWMMC0013E", (Object[])new Object[0]);
            isSuccessfulActivation = false;
        }
    }

    public Set<Class<? extends Extension>> getExtensions() {
        if (!isSuccessfulActivation) {
            return null;
        }
        HashSet<Class<? extends Extension>> extensions = new HashSet<Class<? extends Extension>>();
        extensions.add(LegacyMetricsExtensionAdapter.class);
        return extensions;
    }

    @Reference(name="classLoadingService", service=ClassLoadingService.class)
    protected void setClassLoadingService(ClassLoadingService ref) throws Exception {
        this.classLoadingService = ref;
    }

    protected void unsetClassLoadingService() {
        this.classLoadingService = null;
    }

    @Reference(name="metricsConfig", service=MetricsConfig.class)
    protected void setMetricConfig(MetricsConfig ref) throws Exception {
        this.metricsConfig = ref;
    }

    protected void unsetMetricConfig() {
        this.metricsConfig = null;
    }

    @Reference(name="sharedLib", service=Library.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(id=unbound)")
    protected void setSharedLib(Library ref) throws Exception {
        this.sharedLib = ref;
        Tr.audit((TraceComponent)tc, (String)"libraryRefConfigured.info.CWMMC0014I", (Object[])new Object[]{this.sharedLib.id()});
    }

    protected void unsetSharedLib(Library ref) {
        this.sharedLib = null;
    }

    private File resolveSmallRyeMetricsJar() throws FileNotFoundException {
        File f = this.resolveLibJar(SMALLRYE_METRICS_JAR_NAME, "[1.0,5.0)");
        return f;
    }

    private File resolveMicrometerJar() throws FileNotFoundException {
        File f = this.resolveLibJar(MICROMETER_JAR_NAME, "[1.0,5.0)");
        return f;
    }

    private File resolveLibJar(String jarName, String jarVersionRange) throws FileNotFoundException {
        VersionRange vr;
        ContentBasedLocalBundleRepository cblb = BundleRepositoryRegistry.getInstallBundleRepository();
        File f = cblb.selectBundle("lib/", jarName, vr = VersionRange.valueOf((String)jarVersionRange));
        if (f == null) {
            Tr.error((TraceComponent)tc, (String)"fileNotFound.error.CWMMC0010E", (Object[])new Object[]{jarName});
            throw new FileNotFoundException("Could not load the " + jarName + " jar");
        }
        return f;
    }

    private ClassLoader createBundleAddOnClassLoader(List<File> classPath, boolean isSharedLibAvailable) throws IllegalStateException {
        ClassLoader retClassLoader = null;
        ClassLoader classCL = this.getClass().getClassLoader();
        ClassLoaderConfiguration clConfig = this.classLoadingService.createClassLoaderConfiguration();
        clConfig.setProtectionDomain(new ProtectionDomain(new CodeSource(null, new Certificate[0]), this.getClass().getProtectionDomain().getPermissions()));
        ClassLoaderIdentity cid = this.classLoadingService.createIdentity("smallrye", "metrics");
        clConfig.setId(cid);
        if (isSharedLibAvailable) {
            clConfig.addSharedLibraries(new String[]{this.sharedLib.id()});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("Class path : %s \nClassLoader: %s \nClassLoaderConfiguration: %s", classPath, classCL, clConfig), (Object[])new Object[0]);
        }
        if ((retClassLoader = this.classLoadingService.createBundleAddOnClassLoader(classPath, classCL, clConfig)) == null) {
            throw new IllegalStateException("The bundle add-on class loader was not created.");
        }
        return retClassLoader;
    }

    private void loadSmallRyeClasses(ClassLoader classLoader) throws ClassNotFoundException, NoClassDefFoundError {
        this.checkPrometheusRegistryAvailable(classLoader);
        Util.SR_LEGACY_METRIC_REGISTRY_EXTENSION_CLASS = Class.forName(LEGACY_METRICS_EXTENSION_CLASSNAME, true, classLoader);
        Class<?> metricRegistryProducerClass = Class.forName(METRIC_REGISTRY_PRODUCER_CLASSNAME, true, classLoader);
        Util.SR_METRIC_REGISTRY_PRODUCER_CLASS = metricRegistryProducerClass;
        Class<?> metricProducerClass = Class.forName(METRIC_PRODUCER_CLASSNAME, true, classLoader);
        Util.SR_METRICS_PRODUCER_CLASS = metricProducerClass;
        Class<?> sharedMetricRegistriesClass = Class.forName(SHARED_METRIC_REGISTRIES_CLASSNAME, true, classLoader);
        Util.SR_SHARED_METRIC_REGISTRIES_CLASS = sharedMetricRegistriesClass;
        Class<?> LegacyMetricRegistryClass = Class.forName(LEGACY_METRIC_REGISTRY_ADAPTER_CLASSNAME, true, classLoader);
        Util.SR_LEGACY_METRIC_REGISTRY_CLASS = LegacyMetricRegistryClass;
        Class<?> MetricRequestHandlerClass = Class.forName(METRICS_REQUEST_HANDLER_CLASSNAME, true, classLoader);
        Util.SR_METRICS_REQUEST_HANDLER_CLASS = MetricRequestHandlerClass;
        Class<?> restResponderInterface = Class.forName(METRICS_REQUEST_HANDELER_RESPONDER_CLASSNAME, true, classLoader);
        Util.SR_REST_RESPONDER_INTERFACE = restResponderInterface;
        Class<?> ApplicationNameResolverFuncInterface = Class.forName(APPLICATION_NAME_RESOLVER_CLASSNAME, true, classLoader);
        Util.SR_APPLICATION_NAME_RESOLVER_INTERFACE = ApplicationNameResolverFuncInterface;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    private void checkPrometheusRegistryAvailable(ClassLoader classLoader) {
        block4: {
            if (!Boolean.parseBoolean(ConfigProvider.getConfig().getOptionalValue("mp.metrics.prometheus.enabled", String.class).orElse("true"))) {
                Tr.info((TraceComponent)tc, (String)"disabled.info.CWMMC0009I", (Object[])new Object[0]);
                this.metricsConfig.disableMetricsEndpoint();
                return;
            }
            try {
                Class.forName(FQ_PROMETHEUSCONFIG_PATH, false, classLoader);
            }
            catch (ClassNotFoundException e) {
                Tr.info((TraceComponent)tc, (String)"noPrometheusRegistry.info.CWMMC0008I", (Object[])new Object[0]);
                this.metricsConfig.disableMetricsEndpoint();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"io.openliberty.microprofile.metrics50.internal.SmallryeMetricsCDIMetadata", (String)"325", (Object)this, (Object[])new Object[]{classLoader});
                Tr.info((TraceComponent)tc, (String)"noPrometheusRegistry.info.CWMMC0008I", (Object[])new Object[0]);
                this.metricsConfig.disableMetricsEndpoint();
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Unexpected exception encountered " + String.valueOf(e)), (Object[])new Object[0]);
            }
        }
    }
}

