/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.jsp.shared.util;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.configuration.JspConfigPropertyGroup;
import com.ibm.ws.jsp.runtime.metadata.JspComponentMetaData;
import com.ibm.ws.webcontainer.util.URIMatcher;
import com.ibm.ws.webcontainer.webapp.WebAppConfigExtended;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="log", fieldDesc="Ljava/util/logging/Logger;")
public class JspURIMatcher
extends URIMatcher {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = JspURIMatcher.class.getName();
    private Map<String, Object> sortedMap;
    static final long serialVersionUID = -6997573886251217569L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspURIMatcher(IServletContext webapp) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.jsp.shared.util.JspURIMatcher", "<init>", new Object[]{webapp});
        }
        this.sortedMap = new TreeMap<String, Object>();
        this.addImplicitJspMappings();
        this.addJspFileExtensions(webapp);
        this.addPropertyGroupExtensions(webapp);
        this.addJspMappedServlets(webapp);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.jsp.shared.util.JspURIMatcher", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addImplicitJspMappings() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.jsp.shared.util.JspURIMatcher", "addImplicitJspMappings", new Object[0]);
        }
        for (int i = 0; i < Constants.STANDARD_JSP_EXTENSIONS.length; ++i) {
            String uri = Constants.STANDARD_JSP_EXTENSIONS[i];
            this.put(uri, "implicitJspExtensions");
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.jsp.shared.util.JspURIMatcher", "addImplicitJspMappings");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addJspFileExtensions(IServletContext webapp) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.jsp.shared.util.JspURIMatcher", "addJspFileExtensions", new Object[]{webapp});
        }
        WebAppConfig webGroupCfg = webapp.getWebAppConfig();
        Map jspPropsMap = webGroupCfg.getJspAttributes();
        String list = (String)jspPropsMap.get("jsp.file.extensions");
        if (list != null) {
            StringTokenizer st = new StringTokenizer(list, ": ;");
            while (st.hasMoreTokens()) {
                String ext = st.nextToken();
                this.put(ext, "jsp.file.extension");
            }
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.jsp.shared.util.JspURIMatcher", "addJspFileExtensions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addPropertyGroupExtensions(IServletContext webapp) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.jsp.shared.util.JspURIMatcher", "addPropertyGroupExtensions", new Object[]{webapp});
        }
        WebAppConfig webGroupCfg = webapp.getWebAppConfig();
        JspComponentMetaData jspMetadata = (JspComponentMetaData)((WebAppConfigExtended)webGroupCfg).getMetaData().getJspComponentMetadata();
        List jspPropertyGroups = jspMetadata.getJspPropertyGroups();
        for (JspConfigPropertyGroup jspPropertyGroup : jspPropertyGroups) {
            for (String urlPattern : jspPropertyGroup.getUrlPatterns()) {
                this.put(urlPattern, "jspPropertyGroupURI");
            }
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.jsp.shared.util.JspURIMatcher", "addPropertyGroupExtensions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addJspMappedServlets(IServletContext webapp) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.jsp.shared.util.JspURIMatcher", "addJspMappedServlets", new Object[]{webapp});
        }
        WebAppConfig config = webapp.getWebAppConfig();
        Iterator itr = config.getServletInfos();
        while (itr.hasNext()) {
            List mappings;
            IServletConfig sconfig = (IServletConfig)itr.next();
            if (!sconfig.isJsp() || (mappings = sconfig.getMappings()) == null || mappings.isEmpty()) continue;
            for (String urlPattern : mappings) {
                this.put(urlPattern, "jspMappedServlets");
            }
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.jsp.shared.util.JspURIMatcher", "addJspMappedServlets");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void put(String uri, Object target) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.jsp.shared.util.JspURIMatcher", "put", new Object[]{uri, target});
        }
        try {
            super.put(uri, target);
            log.logp(Level.FINE, CLASS_NAME, "put", "adding [" + uri + "] target =[" + target + "]");
            this.sortedMap.put(uri, target);
        }
        catch (Exception e) {
            log.logp(Level.FINEST, CLASS_NAME, "put", "problem occured when adding new target [" + uri + "] target =[" + target + "]", e);
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.jsp.shared.util.JspURIMatcher", "put");
        }
    }

    public String toString() {
        return this.sortedMap.toString();
    }
}

