/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.ejb;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.naming.EJBLocalNamingHelper;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jndi.WSContextBase;
import com.ibm.ws.jndi.WSName;
import com.ibm.ws.jndi.ejb.EJBNamingEnumeration;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EJBLocalURLContext
extends WSContextBase
implements Context {
    static final TraceComponent tc = Tr.register(EJBLocalURLContext.class, (String)"Naming", (String)"com.ibm.ws.jndi.internal.url.contexts.resources.JNDIMessages");
    private final Map<String, Object> environment = new ConcurrentHashMap<String, Object>();
    private final ConcurrentServiceReferenceSet<EJBLocalNamingHelper> helperServices;
    private final String subContext;
    static final long serialVersionUID = -5778096201812543070L;

    public EJBLocalURLContext(Hashtable<?, ?> environment, ConcurrentServiceReferenceSet<EJBLocalNamingHelper> helperServices) {
        this.environment.putAll(environment);
        this.helperServices = helperServices;
        this.subContext = "";
    }

    public EJBLocalURLContext(EJBLocalURLContext copy) {
        this.environment.putAll(copy.environment);
        this.helperServices = copy.helperServices;
        this.subContext = copy.subContext;
    }

    public EJBLocalURLContext(EJBLocalURLContext copy, String subContext) {
        this.environment.putAll(copy.environment);
        this.helperServices = copy.helperServices;
        this.subContext = subContext;
    }

    @Override
    public Object addToEnvironment(String s, Object o) throws NamingException {
        return this.environment.put(s, o);
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        Hashtable<String, Object> envmt = new Hashtable<String, Object>();
        envmt.putAll(this.environment);
        return envmt;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "ejblocal:" + this.subContext;
    }

    @Override
    public Object removeFromEnvironment(String s) throws NamingException {
        return this.environment.remove(s);
    }

    @FFDCIgnore(value={NameNotFoundException.class})
    protected Object lookup(WSName name) throws NamingException {
        String lookupModified;
        Object toReturn;
        block18: {
            boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (name.isEmpty()) {
                return new EJBLocalURLContext(this);
            }
            String lookup = name.toString();
            boolean endsInNamespace = lookup.endsWith(":");
            String[] lookupArray = lookup.split(":");
            if (endsInNamespace) {
                lookup = lookupArray[lookupArray.length - 1] + ":";
            } else if (lookupArray.length > 1) {
                lookup = lookupArray[lookupArray.length - 2] + ":" + lookupArray[lookupArray.length - 1];
            }
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("namespace parsed lookup: " + lookup), (Object[])new Object[0]);
            }
            if (lookup.equals("ejblocal:")) {
                return new EJBLocalURLContext(this);
            }
            if (lookup.startsWith("local:")) {
                return new InitialContext().lookup(lookup);
            }
            if (lookup.equals("/")) {
                String nameStr = "ejblocal:" + this.subContext + lookup;
                throw new NameNotFoundException(NameNotFoundException.class.getName() + ": " + nameStr);
            }
            toReturn = null;
            String listModified = lookup;
            lookupModified = lookup;
            if (lookupModified.startsWith("ejblocal:")) {
                listModified = lookupModified = lookupModified.substring(9);
            } else if (!this.subContext.isEmpty()) {
                lookupModified = this.subContext + "/" + lookupModified;
            }
            Iterator it = this.helperServices.getServices();
            while (it.hasNext()) {
                EJBLocalNamingHelper helperService = (EJBLocalNamingHelper)it.next();
                toReturn = helperService.getObjectInstance(lookupModified);
                if (toReturn == null) continue;
                if (!isTraceOn || !tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("NamingHelper found object: " + toReturn), (Object[])new Object[0]);
                break;
            }
            if (toReturn == null) {
                try {
                    if (this.list(listModified).hasMore()) {
                        toReturn = new EJBLocalURLContext(this, lookupModified);
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("NamingHelper found sub-contexts: " + lookupModified + ", " + toReturn), (Object[])new Object[0]);
                        }
                    }
                }
                catch (NameNotFoundException ex) {
                    if (!isTraceOn || !tc.isDebugEnabled()) break block18;
                    Tr.debug((TraceComponent)tc, (String)("NamingHelper failed to find sub-contexts: " + ex), (Object[])new Object[0]);
                }
            }
        }
        if (toReturn == null) {
            String nameStr = "ejblocal:" + lookupModified;
            throw new NameNotFoundException(nameStr);
        }
        return toReturn;
    }

    protected void bind(WSName name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected void rebind(WSName name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected void rename(WSName oldName, WSName newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected void unbind(WSName name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected NamingEnumeration<NameClassPair> list(WSName name) throws NamingException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        HashSet allInstances = new HashSet();
        Iterator it = this.helperServices.getServices();
        while (it.hasNext()) {
            EJBLocalNamingHelper helperService = (EJBLocalNamingHelper)it.next();
            Collection instances = helperService.listInstances(this.subContext, name.toString());
            if (instances == null) continue;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("NamingHelper found instances: " + instances), (Object[])new Object[0]);
            }
            allInstances.addAll(instances);
        }
        if (!(!allInstances.isEmpty() || this.subContext.isEmpty() && name.isEmpty())) {
            throw new NameNotFoundException(name.toString());
        }
        return new EJBNamingEnumeration<NameClassPair>(allInstances);
    }

    protected NamingEnumeration<Binding> listBindings(WSName name) throws NamingException {
        HashSet<Binding> bindings = new HashSet<Binding>();
        NamingEnumeration<NameClassPair> pairs = this.list(name);
        if (pairs.hasMore()) {
            Context ctx = (Context)this.lookup(name);
            while (pairs.hasMore()) {
                NameClassPair pair = pairs.next();
                Binding binding = new Binding(pair.getName(), pair.getClassName(), ctx.lookup(pair.getName()));
                bindings.add(binding);
            }
        }
        return new EJBNamingEnumeration<Binding>(bindings);
    }

    protected void destroySubcontext(WSName name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected Context createSubcontext(WSName name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected Object lookupLink(WSName name) throws NamingException {
        return this.lookup(name);
    }

    protected NameParser getNameParser(WSName name) throws NamingException {
        return null;
    }
}

