/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.Utils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FailureScopeFactory;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FileFailureScopeFactory
implements FailureScopeFactory {
    private static final TraceComponent tc = Tr.register(FileFailureScopeFactory.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static final byte VERSION = 2;
    static final long serialVersionUID = -3388512732663541902L;

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    public FailureScope toFailureScope(byte[] bytes) {
        byte version;
        DataInputStream dis;
        block11: {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            dis = new DataInputStream(bais);
            version = 0;
            try {
                byte failureScopeID = dis.readByte();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("FailureScope version manager id is " + failureScopeID), (Object[])new Object[0]);
                }
                version = dis.readByte();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("FailureScope version is " + version), (Object[])new Object[0]);
                }
            }
            catch (IOException failureScopeID) {
                void ioe;
                FFDCFilter.processException((Throwable)failureScopeID, (String)"com.ibm.ws.recoverylog.spi.FileFailureScopeFactory", (String)"72", (Object)this, (Object[])new Object[]{bytes});
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.recoverylog.spi.FileFailureScopeFactory.toFailureScope", (String)"61", (Object)this);
                if (!tc.isEventEnabled()) break block11;
                Tr.event((TraceComponent)tc, (String)"IOException caught inflating failure scope", (Object[])new Object[]{ioe});
            }
        }
        FileFailureScope failureScope = null;
        if (version == 2) {
            try {
                String serverName = dis.readUTF();
                failureScope = new FileFailureScope(serverName);
            }
            catch (IOException serverName) {
                void ioe;
                FFDCFilter.processException((Throwable)serverName, (String)"com.ibm.ws.recoverylog.spi.FileFailureScopeFactory", (String)"86", (Object)this, (Object[])new Object[]{bytes});
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.recoverylog.spi.FileFailureScopeFactory.toFailureScope", (String)"68", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"IOException caught inflating failure scope", (Object[])new Object[]{ioe});
                }
            }
        } else if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"FailureScope version level not recognized. Expected version 2", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"toFailureScope {0} {1} {2}", (Object[])new Object[]{this, RLSUtils.toHexString(bytes), failureScope});
        }
        return failureScope;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    public byte[] toByteArray(FailureScope failureScope) {
        byte[] bytes;
        block3: {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            bytes = null;
            try {
                dos.writeByte(FailureScopeFactory.FILE_FAILURE_SCOPE_ID.byteValue());
                dos.writeByte(2);
                dos.writeUTF(failureScope.serverName());
                dos.flush();
                dos.close();
                bytes = baos.toByteArray();
            }
            catch (IOException iOException) {
                void ioe;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.FileFailureScopeFactory", (String)"132", (Object)this, (Object[])new Object[]{failureScope});
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.recoverylog.spi.FileFailureScopeFactory.toByteArray", (String)"104", (Object)this);
                if (!tc.isEventEnabled()) break block3;
                Tr.event((TraceComponent)tc, (String)"IOException caught deflating failure scope", (Object[])new Object[]{ioe});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"toByteArray", (Object[])new Object[]{this, failureScope, Utils.toString((byte[])bytes)});
        }
        return bytes;
    }
}

