/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.Constants;
import com.ibm.ws.ssl.SSLPropertyUtils;
import com.ibm.ws.ssl.config.ProtocolHelper;
import java.nio.ByteBuffer;
import java.util.Properties;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class LibertySSLEngineWrapper
extends SSLEngine {
    private static final TraceComponent tc = Tr.register(LibertySSLEngineWrapper.class, (String)"SSL", (String)"com.ibm.ws.ssl");
    private SSLEngine delegate = null;
    private final Properties props;
    private final ProtocolHelper protocolHelper = new ProtocolHelper();

    public LibertySSLEngineWrapper(SSLEngine sslEngine) {
        String[] protocols;
        this.delegate = sslEngine;
        this.props = SSLPropertyUtils.lookupProperties();
        String[] ciphers = this.getEnabledCipherSuitesFromConfig(this.props);
        if (ciphers != null) {
            this.delegate.setEnabledCipherSuites(ciphers);
        }
        if ((protocols = this.getEnabledProtocolsFromConfig(this.props)) != null) {
            this.delegate.setEnabledProtocols(protocols);
        }
    }

    public LibertySSLEngineWrapper(SSLEngine sslEngine, String alias) {
        String[] protocols;
        this.delegate = sslEngine;
        this.props = SSLPropertyUtils.lookupProperties(alias);
        String[] ciphers = this.getEnabledCipherSuitesFromConfig(this.props);
        if (ciphers != null) {
            this.delegate.setEnabledCipherSuites(ciphers);
        }
        if ((protocols = this.getEnabledProtocolsFromConfig(this.props)) != null) {
            this.delegate.setEnabledProtocols(protocols);
        }
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        return this.delegate.wrap(srcs, offset, length, dst);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        return this.delegate.unwrap(src, dsts, offset, length);
    }

    @Override
    public Runnable getDelegatedTask() {
        return this.delegate.getDelegatedTask();
    }

    @Override
    public void closeInbound() throws SSLException {
        this.delegate.closeInbound();
    }

    @Override
    public boolean isInboundDone() {
        return this.delegate.isInboundDone();
    }

    @Override
    public void closeOutbound() {
        this.delegate.closeOutbound();
    }

    @Override
    public boolean isOutboundDone() {
        return this.delegate.isOutboundDone();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        String securityLevel = this.props.getProperty("com.ibm.ssl.securityLevel");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("securityLevel from properties is " + securityLevel));
        }
        if (securityLevel == null) {
            securityLevel = "HIGH";
        }
        return Constants.adjustSupportedCiphersToSecurityLevel(this.delegate.getSupportedCipherSuites(), securityLevel);
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.delegate.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.delegate.setEnabledCipherSuites(suites);
    }

    private String[] getEnabledCipherSuitesFromConfig(Properties props) {
        String cipherString = props.getProperty("com.ibm.ssl.enabledCipherSuites");
        if (cipherString != null) {
            return cipherString.split("\\s+");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"com.ibm.ssl.enabledCipherSuites has not been configured.");
        }
        return null;
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.delegate.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.delegate.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.delegate.setEnabledProtocols(protocols);
    }

    private String[] getEnabledProtocolsFromConfig(Properties props) {
        String sslProtocol = props.getProperty("com.ibm.ssl.protocol");
        return this.protocolHelper.getSSLProtocol(sslProtocol);
    }

    @Override
    public SSLSession getSession() {
        return this.delegate.getSession();
    }

    @Override
    public void beginHandshake() throws SSLException {
        this.delegate.beginHandshake();
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.delegate.getHandshakeStatus();
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.delegate.setUseClientMode(mode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.delegate.getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.delegate.setNeedClientAuth(need);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.delegate.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.delegate.setWantClientAuth(want);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.delegate.getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.delegate.setEnableSessionCreation(flag);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.delegate.getEnableSessionCreation();
    }
}

