/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.channelfw.objectpool;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.objectpool.CircularObjectPool;
import com.ibm.wsspi.channelfw.objectpool.LocalThreadObjectPool;
import com.ibm.wsspi.channelfw.objectpool.ObjectDestroyer;
import com.ibm.wsspi.channelfw.objectpool.ObjectFactory;
import com.ibm.wsspi.channelfw.objectpool.ObjectPool;
import java.util.Hashtable;

public class TwoTierObjectPool
implements ObjectPool {
    private int threadPoolSize;
    private ThreadLocal<LocalThreadObjectPool> threadLocals = null;
    private CircularObjectPool mainPool = null;
    private ObjectFactory factory;
    private Hashtable<Object, Object> inUseTable = null;
    private boolean inUseTracking;
    private boolean cleanUpOld = true;
    private ObjectDestroyer destroyer;
    private static final TraceComponent tc = Tr.register(TwoTierObjectPool.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");

    public TwoTierObjectPool(int _threadPoolSize, int _mainPoolSize, ObjectFactory _factory, boolean _inUseTracking) {
        this.threadPoolSize = _threadPoolSize;
        this.factory = _factory;
        this.inUseTracking = _inUseTracking;
        if (_threadPoolSize > 0) {
            this.threadLocals = new ThreadLocal();
        }
        if (_mainPoolSize > 0) {
            this.mainPool = new CircularObjectPool(_mainPoolSize, this.factory);
        }
        if (_inUseTracking) {
            this.inUseTable = new Hashtable(_threadPoolSize * 2 + _mainPoolSize * 2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Object Pool " + this + " created, local size: " + _threadPoolSize + ", main pool size: " + _mainPoolSize), (Object[])new Object[0]);
        }
    }

    public TwoTierObjectPool(int _threadPoolSize, int _mainPoolSize, ObjectFactory _factory, ObjectDestroyer _destroyer, boolean _inUseTracking) {
        this.threadPoolSize = _threadPoolSize;
        this.factory = _factory;
        this.destroyer = _destroyer;
        this.inUseTracking = _inUseTracking;
        if (_threadPoolSize > 0) {
            this.threadLocals = new ThreadLocal();
        }
        if (_mainPoolSize > 0) {
            this.mainPool = new CircularObjectPool(_mainPoolSize, this.factory, this.destroyer);
        }
        if (_inUseTracking) {
            this.inUseTable = new Hashtable(_threadPoolSize * 2 + _mainPoolSize * 2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Object Pool " + this + " created, local size: " + _threadPoolSize + ", main pool size: " + _mainPoolSize), (Object[])new Object[0]);
        }
    }

    public TwoTierObjectPool(int _threadPoolSize, int _mainPoolSize) {
        this(_threadPoolSize, _mainPoolSize, null, false);
    }

    public void doNotCleanUpOld() {
        if (this.mainPool != null) {
            this.mainPool.setCleanUpOld(false);
        }
        this.cleanUpOld = false;
    }

    @Override
    public Object get() {
        Object ret = null;
        LocalThreadObjectPool localPool = this.getThreadLocalObjectPool();
        if (localPool != null) {
            ret = localPool.get();
        }
        if (ret == null && this.mainPool != null) {
            if (localPool != null) {
                Object[] objectArray = this.mainPool.getBatch();
                localPool.putBatch(objectArray);
                ret = localPool.get();
            } else {
                ret = this.mainPool.get();
            }
        }
        if (ret == null && this.factory != null) {
            ret = this.factory.create();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Object Pool " + this + " couldn't obtain object from either local or global pool, new object created"), (Object[])new Object[0]);
            }
        }
        if (this.inUseTracking && ret != null) {
            this.inUseTable.put(ret, ret);
        }
        return ret;
    }

    @Override
    public Object put(Object o) {
        LocalThreadObjectPool localPool;
        if (null == o) {
            throw new NullPointerException();
        }
        Object putObject = o;
        if (this.inUseTracking) {
            this.inUseTable.remove(o);
        }
        if ((localPool = this.getThreadLocalObjectPool()) != null) {
            putObject = localPool.put(putObject);
        }
        if (this.mainPool != null && putObject != null) {
            Object[] objectArray;
            this.mainPool.put(putObject);
            if (localPool != null && (objectArray = localPool.getBatch())[0] != null) {
                this.mainPool.putBatch(objectArray);
            }
        }
        return null;
    }

    private LocalThreadObjectPool getThreadLocalObjectPool() {
        if (this.threadPoolSize <= 0) {
            return null;
        }
        LocalThreadObjectPool localPool = null;
        if (this.threadLocals != null && (localPool = this.threadLocals.get()) == null) {
            localPool = new LocalThreadObjectPool(this.threadPoolSize, null, this.destroyer);
            this.threadLocals.set(localPool);
            localPool.setCleanUpOld(this.cleanUpOld);
        }
        return localPool;
    }

    public void removeFromInUse(Object o) {
        if (null == o) {
            throw new NullPointerException();
        }
        if (this.inUseTracking) {
            this.inUseTable.remove(o);
        }
    }

    public Object[] getInUseTable() {
        return ((Hashtable)this.inUseTable.clone()).keySet().toArray();
    }

    public void purgeThreadLocal() {
        Object[] data;
        LocalThreadObjectPool pool;
        if (null != this.threadLocals && null != (pool = this.threadLocals.get()) && 0 < (data = pool.purge()).length) {
            this.mainPool.putBatch(data);
        }
    }
}

