/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.VariableXPathCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.XMLContainerMapping;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.sessions.Session;

public class XMLVariableXPathCollectionMapping
extends XMLCompositeCollectionMapping
implements VariableXPathCollectionMapping<AbstractSession, AttributeAccessor, ContainerPolicy, Converter, ClassDescriptor, DatabaseField, XMLMarshaller, Session, XMLUnmarshaller, XMLRecord>,
XMLMapping,
XMLContainerMapping {
    protected String variableAttributeName;
    protected String variableGetMethodName;
    protected String variableSetMethodName;
    private AttributeAccessor variableAttributeAccessor;
    private boolean isAttribute;

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.variableAttributeAccessor == null) {
            if (this.variableAttributeName != null) {
                this.variableAttributeAccessor = new InstanceVariableAttributeAccessor();
                this.variableAttributeAccessor.setAttributeName(this.variableAttributeName);
            } else if (this.variableGetMethodName != null) {
                this.variableAttributeAccessor = new MethodAttributeAccessor();
                this.variableAttributeAccessor.setAttributeName("VARIABLE");
                ((MethodAttributeAccessor)this.variableAttributeAccessor).setGetMethodName(this.variableGetMethodName);
                if (this.variableSetMethodName == null) {
                    this.variableAttributeAccessor.setIsWriteOnly(true);
                } else {
                    ((MethodAttributeAccessor)this.variableAttributeAccessor).setSetMethodName(this.variableSetMethodName);
                }
            }
        }
        this.variableAttributeAccessor.initializeAttributes(this.getReferenceClass());
    }

    public void useMapClass(String concreteContainerClassName) {
        MapContainerPolicy policy = new MapContainerPolicy(concreteContainerClassName);
        this.setContainerPolicy(policy);
    }

    @Override
    protected void initializeMapContainerPolicy(AbstractSession session, MapContainerPolicy cp) {
        super.initializeMapContainerPolicy(session, cp);
        if (this.variableAttributeName != null) {
            cp.setKeyName(this.variableAttributeName);
        } else if (this.variableGetMethodName != null) {
            cp.setKeyMethodName(this.variableGetMethodName);
        }
    }

    @Override
    protected List<DatabaseField> collectFields() {
        if (this.field != null) {
            return super.collectFields();
        }
        return NO_FIELDS;
    }

    @Override
    public List<DatabaseField> getFields() {
        return this.collectFields();
    }

    @Override
    protected void initializeReferenceDescriptorAndField(AbstractSession session) {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        this.setReferenceDescriptor((ClassDescriptor)session.getDescriptor((Class)this.getReferenceClass()));
        ClassDescriptor refDescriptor = this.getReferenceDescriptor();
        if (refDescriptor == null) {
            session.getIntegrityChecker().handleError(DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this));
            return;
        }
        if (this.field != null) {
            this.setField(this.getDescriptor().buildField(this.field));
            this.setFields(this.collectFields());
        }
        if (this.hasConverter()) {
            this.getConverter().initialize(this, session);
        }
    }

    @Override
    public boolean isAbstractCompositeCollectionMapping() {
        return false;
    }

    public String getVariableAttributeName() {
        return this.variableAttributeName;
    }

    @Override
    public void setVariableAttributeName(String variableAttributeName) {
        this.variableAttributeName = variableAttributeName;
    }

    public String getVariableGetMethodName() {
        return this.variableGetMethodName;
    }

    @Override
    public void setVariableGetMethodName(String variableGetMethodName) {
        this.variableGetMethodName = variableGetMethodName;
    }

    public String getVariableSetMethodName() {
        return this.variableSetMethodName;
    }

    @Override
    public void setVariableSetMethodName(String variableSetMethodName) {
        this.variableSetMethodName = variableSetMethodName;
    }

    @Override
    public AttributeAccessor getVariableAttributeAccessor() {
        return this.variableAttributeAccessor;
    }

    @Override
    public void setVariableAttributeAccessor(AttributeAccessor variableAttributeAccessor) {
        this.variableAttributeAccessor = variableAttributeAccessor;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(attributeValue);
        if (null != iter) {
            while (cp.hasNext(iter)) {
                Object element = cp.next(iter, session);
                if ((element = this.convertObjectValueToDataValue(element, session, ((XMLRecord)row).getMarshaller())) == null) continue;
                XMLField variableField = new XMLField();
                XMLRecord xmlRow = (XMLRecord)row;
                variableField.setXPathFragment(this.getXPathFragmentForValue(element, xmlRow.getNamespaceResolver(), xmlRow.isNamespaceAware(), xmlRow.getNamespaceSeparator()));
                row.put(variableField, (Object)this.buildCompositeRow(variableField, element, session, row, writeType));
            }
        }
    }

    protected AbstractRecord buildCompositeRow(XMLField variableField, Object attributeValue, AbstractSession session, AbstractRecord parentRow, DatabaseMapping.WriteType writeType) {
        ClassDescriptor classDesc = this.getReferenceDescriptor(attributeValue, session);
        return this.buildCompositeRowForDescriptor(classDesc, attributeValue, session, (XMLRecord)parentRow, writeType);
    }

    @Override
    public XPathFragment getXPathFragmentForValue(Object obj, NamespaceResolver nr, boolean isNamespaceAware, char sep) {
        String returnString;
        Object value = this.getVariableAttributeAccessor().getAttributeValueFromObject(obj);
        if (value == null) {
            throw XMLMarshalException.nullValueNotAllowed(this.getVariableAttributeName(), this.getReferenceClassName());
        }
        String uri = null;
        if (value instanceof QName) {
            returnString = ((QName)value).getLocalPart();
            uri = ((QName)value).getNamespaceURI();
        } else {
            returnString = (String)value;
        }
        XPathFragment frag = new XPathFragment();
        frag.setLocalName(returnString);
        if (isNamespaceAware && uri != null && !uri.isEmpty()) {
            String prefix = nr.resolveNamespaceURI(uri);
            if (prefix == null) {
                prefix = nr.generatePrefix();
                frag.setGeneratedPrefix(true);
            }
            if (prefix != null && !prefix.isEmpty()) {
                frag.setPrefix(prefix);
            }
        }
        frag.setNamespaceURI(uri);
        return frag;
    }

    @Override
    public boolean isAttribute() {
        return this.isAttribute;
    }

    @Override
    public void setAttribute(boolean isAttribute) {
        this.isAttribute = isAttribute;
    }

    @Override
    public void useMapClassName(String concreteContainerClassName, String methodName) {
        if (this.getReferenceClassName() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        MapContainerPolicy policy = new MapContainerPolicy(concreteContainerClassName);
        policy.setKeyName(methodName, this.getReferenceClass().getName());
        this.setContainerPolicy(policy);
    }
}

