/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal;

import com.ibm.ws.kernel.provisioning.packages.PackageIndex;
import com.ibm.ws.kernel.provisioning.packages.SharedPackageInspector;
import com.ibm.ws.logging.internal.BundleManifest;
import com.ibm.ws.logging.internal.StackFinder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;

public class PackageProcessor
implements BundleTrackerCustomizer<Object> {
    private static final String IBM = "IBM";
    private final BundleContext bundleContext;
    private final AtomicReference<BundlePackages> packages = new AtomicReference();
    private final ServiceTracker<SharedPackageInspector, SharedPackageInspector> st;
    private volatile Set<Pattern> bootDelegationPackages = null;
    private static final AtomicReference<PackageProcessor> instance = new AtomicReference<Object>(null);

    public static PackageProcessor getPackageProcessor() {
        PackageProcessor processor = instance.get();
        if (processor != null) {
            return processor;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                BundleContext ctx = PackageProcessor.getSystemBundleContext();
                if (ctx != null && instance.compareAndSet(null, new PackageProcessor(ctx))) {
                    BundleTracker bt = new BundleTracker(ctx, 4, (BundleTrackerCustomizer)instance.get());
                    bt.open();
                }
                return null;
            }
        });
        return instance.get();
    }

    private static BundleContext getSystemBundleContext() {
        Bundle bundle = StackFinder.getInstance().getTopBundleFromCallStack();
        Bundle systemBundle = null;
        if (bundle != null) {
            BundleContext topBundlesContext = bundle.getBundleContext();
            systemBundle = topBundlesContext.getBundle("System Bundle");
        }
        return systemBundle == null ? null : systemBundle.getBundleContext();
    }

    public static void setProcessor(PackageProcessor processor) {
        instance.set(processor);
    }

    private PackageProcessor(BundleContext ctx) {
        this.bundleContext = ctx;
        this.st = new ServiceTracker(this.bundleContext, SharedPackageInspector.class.getName(), null);
        this.st.open();
    }

    public boolean isIBMPackage(String packageName) {
        BundlePackages p;
        if (packageName != null && (p = this.populatePackageLists()) != null) {
            if (p.containsPrivatePackage(packageName)) {
                return true;
            }
            if (p.containsExportedPackage(packageName)) {
                SharedPackageInspector inspector = (SharedPackageInspector)this.st.getService();
                if (inspector != null) {
                    SharedPackageInspector.PackageType exported = inspector.getExportedPackageType(packageName);
                    if (exported == null) {
                        return true;
                    }
                    return !exported.isSpecApi() && !exported.isThirdPartyApi() && !exported.isStableApi();
                }
                return true;
            }
        }
        return false;
    }

    private BundlePackages populatePackageLists() {
        BundlePackages p = this.packages.get();
        if (p == null && this.bundleContext != null) {
            BundlePackages bp = new BundlePackages();
            for (Bundle bundle : this.bundleContext.getBundles()) {
                PackageProcessor.harvestPackageList(bp, bundle);
            }
            this.populateBootDelegationPackageList();
            if (this.packages.compareAndSet(null, bp)) {
                return bp;
            }
            return this.packages.get();
        }
        return p;
    }

    private static void harvestPackageList(BundlePackages packages, Bundle bundle) {
        if (bundle.getLocation() != null && bundle.getState() != 1) {
            BundleManifest manifest = new BundleManifest(bundle);
            if (bundle.getBundleId() == 0L || IBM.equals(manifest.getBundleVendor()) || IBM.equals(manifest.getBundleDistributor())) {
                packages.addPackages(manifest);
            }
        }
    }

    private void populateBootDelegationPackageList() {
        String[] packages;
        HashSet<Pattern> patterns = new HashSet<Pattern>();
        patterns.add(Pattern.compile("java..*"));
        String boots = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return PackageProcessor.this.bundleContext.getProperty("org.osgi.framework.bootdelegation");
            }
        });
        for (String packageRegex : packages = boots.split(",")) {
            patterns.add(Pattern.compile(packageRegex.replaceAll("\\*", ".*")));
        }
        this.bootDelegationPackages = patterns;
    }

    public static String extractPackageFromStackTraceLine(String txt) {
        String packageName = null;
        Pattern regexp = Pattern.compile("\tat ([\\w\\.]*)\\.[\\w\\$]+\\.[<>\\w]+\\(.*");
        Matcher matcher = regexp.matcher(txt);
        if (matcher.matches()) {
            packageName = matcher.group(1);
        }
        return packageName;
    }

    public static String extractPackageFromStackTraceElement(StackTraceElement element) {
        String className = element.getClassName();
        int lastDotIndex = className.lastIndexOf(".");
        String packageName = lastDotIndex > 0 ? className.substring(0, lastDotIndex) : className;
        return packageName;
    }

    public boolean isSpecOrThirdPartyOrBootDelegationPackage(String packageName) {
        SharedPackageInspector.PackageType type;
        SharedPackageInspector inspector = (SharedPackageInspector)this.st.getService();
        if (inspector != null && (type = inspector.getExportedPackageType(packageName)) != null && type.isSpecApi()) {
            return true;
        }
        boolean isBundlePackage = false;
        for (Pattern pattern : this.bootDelegationPackages) {
            isBundlePackage = pattern.matcher(packageName).matches();
            if (!isBundlePackage) continue;
            return isBundlePackage;
        }
        return false;
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        if (!PackageProcessor.isGateway(bundle)) {
            BundlePackages bp = this.populatePackageLists();
            PackageProcessor.harvestPackageList(bp, bundle);
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    private static boolean isGateway(Bundle b) {
        String gwHeader = (String)b.getHeaders("").get("IBM-GatewayBundle");
        return "true".equalsIgnoreCase(gwHeader);
    }

    private static class BundlePackages
    extends PackageIndex<OSGiPackageType> {
        private BundlePackages() {
        }

        public void addPackages(BundleManifest manifest) {
            this.addPackages(manifest.getPrivatePackages(), OSGiPackageType.PRIVATE);
            this.addPackages(manifest.getExportedPackages(), OSGiPackageType.EXPORTED);
        }

        public boolean containsPrivatePackage(String packageName) {
            OSGiPackageType actualType = (OSGiPackageType)((Object)this.find(packageName));
            return actualType == OSGiPackageType.PRIVATE;
        }

        public boolean containsExportedPackage(String packageName) {
            OSGiPackageType actualType = (OSGiPackageType)((Object)this.find(packageName));
            return actualType == OSGiPackageType.EXPORTED;
        }

        private void addPackages(Set<String> packages, OSGiPackageType type) {
            for (String packageName : packages) {
                this.add(packageName, (Object)type);
            }
        }
    }

    private static enum OSGiPackageType {
        PRIVATE,
        EXPORTED;

    }
}

