/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.collaborator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.mp.jwt.proxy.MpJwtHelper;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CollaboratorUtils {
    private static final TraceComponent tc = Tr.register(CollaboratorUtils.class, null, null);
    protected SubjectManager subjectManager;
    static final long serialVersionUID = 1544996125297377090L;

    public CollaboratorUtils(SubjectManager subjectManager) {
        this.subjectManager = subjectManager;
    }

    public Principal getCallerPrincipal(boolean useRealm, String realm, boolean web, boolean isJaspiEnabled) {
        Principal principal;
        Subject subject = this.subjectManager.getCallerSubject();
        if (subject == null) {
            return null;
        }
        SubjectHelper subjectHelper = new SubjectHelper();
        if (subjectHelper.isUnauthenticated(subject) && web) {
            return null;
        }
        if (isJaspiEnabled && (principal = this.getPrincipalFromWSCredential(subjectHelper, subject)) != null) {
            return principal;
        }
        String securityName = this.getSecurityNameFromWSCredential(subjectHelper, subject);
        if (securityName == null) {
            return null;
        }
        Principal jsonWebToken = MpJwtHelper.getJsonWebTokenPricipal((Subject)subject);
        if (jsonWebToken != null) {
            return jsonWebToken;
        }
        Set<WSPrincipal> principals = subject.getPrincipals(WSPrincipal.class);
        if (principals.size() > 1) {
            this.multiplePrincipalsError(principals);
        }
        WSPrincipal wsPrincipal = null;
        if (!principals.isEmpty()) {
            String principalName = this.createPrincipalName(useRealm, realm, securityName);
            wsPrincipal = principals.iterator().next();
            wsPrincipal = new WSPrincipal(principalName, wsPrincipal.getAccessId(), wsPrincipal.getAuthenticationMethod());
        }
        return wsPrincipal;
    }

    private String createPrincipalName(boolean useRealm, String realm, String securityName) {
        String principalName = useRealm && realm != null ? realm + "/" + securityName : securityName;
        return principalName;
    }

    private String getSecurityNameFromWSCredential(SubjectHelper subjectHelper, Subject subject) {
        String securityName = null;
        WSCredential wscredential = subjectHelper.getWSCredential(subject);
        if (wscredential != null) {
            try {
                securityName = wscredential.getSecurityName();
            }
            catch (CredentialExpiredException credentialExpiredException) {
                FFDCFilter.processException((Throwable)credentialExpiredException, (String)"com.ibm.ws.security.collaborator.CollaboratorUtils", (String)"127", (Object)this, (Object[])new Object[]{subjectHelper, subject});
            }
            catch (CredentialDestroyedException credentialDestroyedException) {
                FFDCFilter.processException((Throwable)credentialDestroyedException, (String)"com.ibm.ws.security.collaborator.CollaboratorUtils", (String)"129", (Object)this, (Object[])new Object[]{subjectHelper, subject});
            }
        }
        return securityName;
    }

    /*
     * WARNING - void declaration
     */
    private Principal getPrincipalFromWSCredential(SubjectHelper subjectHelper, Subject subject) {
        Principal principal;
        block3: {
            principal = null;
            WSCredential wscredential = subjectHelper.getWSCredential(subject);
            if (wscredential != null) {
                try {
                    principal = (Principal)wscredential.get("com.ibm.wsspi.security.cred.jaspi.principal");
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.collaborator.CollaboratorUtils", (String)"142", (Object)this, (Object[])new Object[]{subjectHelper, subject});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"Internal error getting JASPIC Principal from credential", (Object[])new Object[]{e});
                }
            }
        }
        return principal;
    }

    private void multiplePrincipalsError(Set<WSPrincipal> principals) {
        String principalNames = null;
        for (WSPrincipal principal : principals) {
            if (principalNames == null) {
                principalNames = principal.getName();
                continue;
            }
            principalNames = principalNames + ", " + principal.getName();
        }
        throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"SEC_TOO_MANY_PRINCIPALS", (Object[])new Object[]{principalNames}));
    }

    /*
     * WARNING - void declaration
     */
    public String getUserRegistryRealm(AtomicServiceReference<SecurityService> securityServiceRef) {
        String realm;
        block3: {
            realm = "defaultRealm";
            try {
                SecurityService securityService = (SecurityService)securityServiceRef.getService();
                UserRegistryService userRegistryService = securityService.getUserRegistryService();
                if (userRegistryService.isUserRegistryConfigured()) {
                    realm = userRegistryService.getUserRegistry().getRealm();
                }
            }
            catch (RegistryException securityService) {
                void re;
                FFDCFilter.processException((Throwable)securityService, (String)"com.ibm.ws.security.collaborator.CollaboratorUtils", (String)"181", (Object)this, (Object[])new Object[]{securityServiceRef});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"RegistryException while trying to get the realm", (Object[])new Object[]{re});
            }
        }
        return realm;
    }
}

