/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal;

import com.ibm.websphere.ras.annotation.Trivial;

@Trivial
public enum AttributeConstraint {
    Between(" BETWEEN ", 2, false),
    Contains(null, 1, true),
    Empty(" IS EMPTY", 0, true),
    EndsWith(null, 1, false),
    Equal("=", 1, true, "EqualTo"),
    False("=FALSE", 0, false),
    GreaterThan(">", 1, false),
    GreaterThanEqual(">=", 1, false, "AtLeast"),
    IgnoreCase(null, 1, false),
    In(" IN ", 1, false),
    LessThan("<", 1, false),
    LessThanEqual("<=", 1, false, "AtMost"),
    Like(" LIKE ", 1, false),
    LikeEscaped(" LIKE ", 2, false),
    Not("<>", 1, true, "NotEqualTo"),
    NotBetween(" NOT BETWEEN ", 2, false),
    NotContains(null, 1, true),
    NotEmpty(" IS NOT EMPTY", 0, true),
    NotEndsWith(null, 1, false),
    NotIn(" NOT IN ", 1, false),
    NotLike(" NOT LIKE ", 1, false),
    NotLikeEscaped(" NOT LIKE ", 2, false),
    NotNull(" IS NOT NULL", 0, false),
    NotStartsWith(null, 1, false),
    Null(" IS NULL", 0, false),
    StartsWith(null, 1, false),
    True("=TRUE", 0, false);

    private final String constraintName;
    private final boolean isNegative;
    private final int length;
    private final int numMethodParams;
    private final String operator;
    private final boolean supportsCollections;

    private AttributeConstraint(String operator, int numMethodParams, boolean supportsCollections) {
        String name = this.name();
        int len = name.length();
        this.constraintName = name;
        this.length = len == 5 && name.equals("Equal") ? 0 : len;
        this.isNegative = name.startsWith("Not");
        this.numMethodParams = numMethodParams;
        this.operator = operator;
        this.supportsCollections = supportsCollections;
    }

    private AttributeConstraint(String operator, int numMethodParams, boolean supportsCollections, String constraintAlias) {
        String name = this.name();
        int len = name.length();
        this.constraintName = constraintAlias == null ? name : constraintAlias;
        this.length = len == 5 && name.equals("Equal") ? 0 : len;
        this.isNegative = name.startsWith("Not");
        this.numMethodParams = numMethodParams;
        this.operator = operator;
        this.supportsCollections = supportsCollections;
    }

    public final String constraintName() {
        return this.constraintName;
    }

    public final boolean isNegative() {
        return this.isNegative;
    }

    public final int lengthWithinMethodName() {
        return this.length;
    }

    public final AttributeConstraint negate() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case Between -> NotBetween;
            case Contains -> NotContains;
            case EndsWith -> NotEndsWith;
            case Empty -> NotEmpty;
            case Equal -> Not;
            case False -> True;
            case GreaterThan -> LessThanEqual;
            case GreaterThanEqual -> LessThan;
            case IgnoreCase -> throw new UnsupportedOperationException();
            case In -> NotIn;
            case LessThan -> GreaterThanEqual;
            case LessThanEqual -> GreaterThan;
            case Like -> NotLike;
            case LikeEscaped -> NotLikeEscaped;
            case Not -> Equal;
            case NotBetween -> Between;
            case NotContains -> Contains;
            case NotEmpty -> Empty;
            case NotEndsWith -> EndsWith;
            case NotIn -> In;
            case NotLike -> Like;
            case NotLikeEscaped -> LikeEscaped;
            case NotNull -> Null;
            case NotStartsWith -> StartsWith;
            case Null -> NotNull;
            case StartsWith -> NotStartsWith;
            case True -> False;
        };
    }

    public final int numMethodParams() {
        return this.numMethodParams;
    }

    public final String operator() {
        return this.operator;
    }

    public final boolean supportsCollections() {
        return this.supportsCollections;
    }
}

