/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collector;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.collector.Client;
import com.ibm.ws.collector.ClientPool;
import com.ibm.ws.collector.Target;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.logging.synch.ThreadLocalHandler;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class TaskManager
implements Target,
Runnable {
    private static final TraceComponent tc = Tr.register(TaskManager.class, null, null);
    private final AtomicServiceReference<SSLSupport> sslSupportServiceRef;
    private final AtomicServiceReference<ExecutorService> executorServiceRef;
    private final LinkedBlockingDeque<List<Object>> newLists;
    private volatile ClientPool clientPool;
    private final int clientPoolSize;
    private volatile boolean shutDown;
    private volatile boolean updateConfig;
    private volatile String hostName;
    private volatile int port;
    private volatile String sslConfig;
    private static final String HOST_NAME_KEY = "hostName";
    private static final String PORT_KEY = "port";
    private static final String SSL_REF_KEY = "sslRef";
    static final long serialVersionUID = -3736269420203863740L;

    public TaskManager(AtomicServiceReference<SSLSupport> sslSupportServiceRef, AtomicServiceReference<ExecutorService> executorServiceRef, int poolSize) {
        this.clientPoolSize = poolSize;
        this.executorServiceRef = executorServiceRef;
        this.sslSupportServiceRef = sslSupportServiceRef;
        this.newLists = new LinkedBlockingDeque(2 * this.clientPoolSize + 1);
        this.updateConfig = false;
        this.shutDown = false;
    }

    public synchronized void addNewList(List<Object> formattedEvents) {
        while (!this.appendList(formattedEvents)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.collector.TaskManager", (String)"77", (Object)this, (Object[])new Object[]{formattedEvents});
            }
        }
    }

    public synchronized void allowNewLists() {
        if (this.newLists.size() < this.clientPoolSize) {
            this.notifyAll();
        }
    }

    private boolean appendList(List<Object> formattedEvents) {
        if (this.newLists.size() >= this.clientPoolSize) {
            return false;
        }
        boolean done = false;
        while (!done) {
            try {
                this.newLists.putLast(formattedEvents);
                done = true;
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.collector.TaskManager", (String)"99", (Object)this, (Object[])new Object[]{formattedEvents});
            }
        }
        return true;
    }

    public void addRetryList(List<Object> retryEvents) {
        boolean done = false;
        while (!done) {
            try {
                this.newLists.putFirst(retryEvents);
                done = true;
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.collector.TaskManager", (String)"112", (Object)this, (Object[])new Object[]{retryEvents});
            }
        }
    }

    public List<Object> removeList() {
        try {
            List<Object> newList = this.newLists.pollFirst(500L, TimeUnit.MILLISECONDS);
            return newList;
        }
        catch (InterruptedException newList) {
            FFDCFilter.processException((Throwable)newList, (String)"com.ibm.ws.collector.TaskManager", (String)"122", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public void clearList() {
        this.newLists.clear();
    }

    @Override
    public void sendEvents(List<Object> formattedEvents) {
        if (!this.shutDown) {
            this.addNewList(formattedEvents);
        }
    }

    public void setConfigInfo(Map<String, Object> config) {
        this.hostName = (String)config.get(HOST_NAME_KEY);
        this.port = (Integer)config.get(PORT_KEY);
        this.sslConfig = (String)config.get(SSL_REF_KEY);
    }

    public void updateConfig() {
        this.updateConfig = true;
    }

    @Override
    public void close() {
        this.shutDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        block14: {
            ThreadLocalHandler.set((Boolean)Boolean.TRUE);
            try {
                while (true) {
                    try {
                        while (true) {
                            List<Object> events;
                            if (this.shutDown) {
                                this.clearList();
                                this.allowNewLists();
                                if (this.clientPool != null) {
                                    this.clientPool.close();
                                }
                                break block14;
                            }
                            if (this.updateConfig) {
                                block15: {
                                    if (this.clientPool != null) {
                                        this.clientPool.close();
                                    }
                                    try {
                                        this.clientPool = null;
                                        this.clientPool = this.createClientPool(this.sslConfig, (SSLSupport)this.sslSupportServiceRef.getService(), this.clientPoolSize);
                                    }
                                    catch (SSLException sSLException) {
                                        void e;
                                        FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.collector.TaskManager", (String)"183", (Object)this, (Object[])new Object[0]);
                                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block15;
                                        Tr.event((TraceComponent)tc, (String)"SSLException creating client pool {0}", (Object[])new Object[]{e});
                                    }
                                }
                                this.updateConfig = false;
                            }
                            if (this.clientPool == null || (events = this.removeList()) == null) continue;
                            this.allowNewLists();
                            Client client = this.clientPool.checkoutClient();
                            if (client != null) {
                                SendEventsTask task = new SendEventsTask(this, events, client, this.clientPool, this.hostName, this.port);
                                ExecutorService execSrvc = (ExecutorService)this.executorServiceRef.getService();
                                if (execSrvc == null) continue;
                                task.start(execSrvc);
                                continue;
                            }
                            this.addRetryList(events);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.collector.TaskManager", (String)"210", (Object)this, (Object[])new Object[0]);
                        continue;
                    }
                    break;
                }
            }
            finally {
                ThreadLocalHandler.remove();
            }
        }
    }

    public abstract ClientPool createClientPool(String var1, SSLSupport var2, int var3) throws SSLException;

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class SendEventsTask
    implements Runnable {
        private final TaskManager taskMgr;
        private final List<Object> events;
        private final Client client;
        private final ClientPool clientPool;
        private final String hostName;
        private final int port;
        static final long serialVersionUID = -1078352777606326917L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public SendEventsTask(TaskManager taskMgr, List<Object> events, Client client, ClientPool clientPool, String hostName, int port) {
            this.taskMgr = taskMgr;
            this.events = events;
            this.client = client;
            this.hostName = hostName;
            this.port = port;
            this.clientPool = clientPool;
        }

        public void start(ExecutorService executorService) {
            try {
                executorService.submit(this);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.collector.TaskManager$SendEventsTask", (String)"243", (Object)this, (Object[])new Object[]{executorService});
                this.clientPool.checkinClient(this.client);
                this.taskMgr.addRetryList(this.events);
            }
        }

        @Override
        @Trivial
        @FFDCIgnore(value={Exception.class})
        public void run() {
            ThreadLocalHandler.set((Boolean)Boolean.TRUE);
            try {
                this.client.connect(this.hostName, this.port);
                this.client.sendData(this.events);
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unable to send events to the target. Reason {0}", (Object[])new Object[]{e});
                }
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.taskMgr.addRetryList(this.events);
            }
            finally {
                this.clientPool.checkinClient(this.client);
                ThreadLocalHandler.remove();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collector.TaskManager$SendEventsTask", SendEventsTask.class, null, null);
        }
    }
}

