/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util;

public enum Hex {

    private static final char[] HEX_DIGIT = "0123456789abcdef".toCharArray();
    private static final int PRINTABLE_CHAR_LOW = 31;
    private static final int PRINTABLE_CHAR_HIGH = 127;

    public static String formatHexPara(byte[] oct) {
        return Hex.formatHexPara(oct, 0, oct.length, new StringBuilder()).toString();
    }

    public static StringBuilder formatHexPara(byte[] oct, StringBuilder sb) {
        return Hex.formatHexPara(oct, 0, oct.length, sb);
    }

    public static StringBuilder formatHexPara(byte[] oct, int offset, int count, StringBuilder sb) {
        return Hex.formatHexPara("", oct, offset, count, sb);
    }

    public static StringBuilder formatHexPara(String indent, byte[] oct, int offset, int count, StringBuilder sb) {
        if (count <= 0) {
            return sb;
        }
        int endIndex = offset + count;
        int indexWidth = Math.max(4, Integer.toHexString(endIndex).length());
        String unindentedIndexFormat = "%0" + indexWidth + "X:  ";
        String indexFormat = indent + unindentedIndexFormat;
        String indexSpaces = indent + String.format(unindentedIndexFormat, 0).replaceAll(".", " ");
        sb.append(String.format(indexFormat, offset));
        StringBuilder ascii = new StringBuilder(18);
        switch (offset % 16) {
            case 15: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 14: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 13: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 12: {
                sb.append("   ");
                ascii.append(" ");
            }
            case 11: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 10: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 9: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 8: {
                sb.append("   ");
                ascii.append(" ");
            }
            case 7: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 6: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 5: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 4: {
                sb.append("   ");
                ascii.append(" ");
            }
            case 3: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 2: {
                sb.append("  ");
                ascii.append(" ");
            }
            case 1: {
                sb.append("  ");
                ascii.append(" ");
            }
        }
        ascii.append(" \"");
        for (int i = offset; i < endIndex; ++i) {
            int b = oct[i] & 0xFF;
            ascii.append(31 < b && b < 127 ? (char)b : (char)'.');
            sb.append(HEX_DIGIT[b >> 4]).append(HEX_DIGIT[b & 0xF]);
            if (i % 4 != 3) continue;
            sb.append(' ');
            if (i % 16 != 15) continue;
            sb.append((CharSequence)ascii).append("\"");
            ascii.setLength(0);
            ascii.append(" \"");
            if (i % 256 == 255) {
                sb.append("\n").append(indexSpaces).append("-----------------------------------");
            }
            if (i + 1 >= endIndex) continue;
            sb.append("\n").append(String.format(indexFormat, i + 1));
        }
        switch (endIndex % 16) {
            case 0: {
                break;
            }
            case 1: {
                sb.append("  ");
            }
            case 2: {
                sb.append("  ");
            }
            case 3: {
                sb.append("   ");
            }
            case 4: {
                sb.append("  ");
            }
            case 5: {
                sb.append("  ");
            }
            case 6: {
                sb.append("  ");
            }
            case 7: {
                sb.append("   ");
            }
            case 8: {
                sb.append("  ");
            }
            case 9: {
                sb.append("  ");
            }
            case 10: {
                sb.append("  ");
            }
            case 11: {
                sb.append("   ");
            }
            case 12: {
                sb.append("  ");
            }
            case 13: {
                sb.append("  ");
            }
            case 14: {
                sb.append("  ");
            }
            case 15: {
                sb.append("   ").append((CharSequence)ascii).append("\"");
            }
        }
        return sb;
    }

    public static void formatHexLine(byte[] oct, StringBuilder sb) {
        Hex.formatHexLine(oct, 0, oct.length, sb);
    }

    public static void formatHexLine(byte[] oct, int offset, int count, StringBuilder sb) {
        if (count <= 0) {
            return;
        }
        sb.append('\"');
        for (int i = offset; i < offset + count; ++i) {
            int n = oct[i] & 0xFF;
            sb.append(n >= 32 && n <= 127 ? (char)n : (char)'?');
        }
        sb.append('\"');
    }
}

