/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.joblog;

import com.ibm.jbatch.container.ws.WSRemotablePartitionExecution;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.joblog.RemotePartitionLog;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.runtime.JobExecution;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JobExecutionLog {
    private final JobExecution jobExecution;
    private final List<File> jobLogFiles;
    private final File execLogRootDir;
    private final List<RemotePartitionLog> partitionLogs = new ArrayList<RemotePartitionLog>();
    private final LogLocalState localState;
    static final long serialVersionUID = -4470019947331947188L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JobExecutionLog(JobExecution execution, List<File> jobLogFiles, File rootDir, LogLocalState localState, List<WSRemotablePartitionExecution> remotePartitions) {
        this.jobExecution = execution;
        this.jobLogFiles = new ArrayList<File>(jobLogFiles);
        this.execLogRootDir = rootDir;
        this.localState = localState;
        if (remotePartitions != null && !remotePartitions.isEmpty()) {
            for (WSRemotablePartitionExecution partition : remotePartitions) {
                this.partitionLogs.add(new RemotePartitionLog(partition));
            }
        }
    }

    public JobExecution getJobExecution() {
        return this.jobExecution;
    }

    public long getExecutionId() {
        return this.jobExecution.getExecutionId();
    }

    public List<File> getJobLogFiles() {
        return this.jobLogFiles;
    }

    public File getExecLogRootDir() {
        return this.execLogRootDir;
    }

    public List<RemotePartitionLog> getRemotePartitionLogs() {
        return this.partitionLogs;
    }

    public LogLocalState getLocalState() {
        return this.localState;
    }

    public File getPartByRelativePath(String relativePath) {
        relativePath = JobExecutionLog.normalizePath(relativePath);
        for (File jobLogFile : this.jobLogFiles) {
            if (!JobExecutionLog.normalizePath(this.getRelativePath(jobLogFile)).equals(relativePath)) continue;
            return jobLogFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected String getRelativePath(File jobLogFile) {
        try {
            return JobExecutionLog.stripPrefix(jobLogFile.getCanonicalPath(), this.getExecLogRootDir().getCanonicalPath() + File.separator);
        }
        catch (IOException iOException) {
            void ioe;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jbatch.joblog.JobExecutionLog", (String)"134", (Object)this, (Object[])new Object[]{jobLogFile});
            throw new RuntimeException((Throwable)ioe);
        }
    }

    protected static String stripPrefix(String str, String prefix) {
        return str.startsWith(prefix) ? str.substring(prefix.length()) : str;
    }

    protected static String normalizePath(String path) {
        return path != null ? path.replaceAll("\\\\", "/") : path;
    }

    public List<String> getRelativePaths() {
        ArrayList<String> retMe = new ArrayList<String>();
        for (File jobLogFile : this.getJobLogFiles()) {
            retMe.add(this.getRelativePath(jobLogFile));
        }
        return retMe;
    }

    public boolean purge() {
        return this.deleteFileRecursive(this.execLogRootDir);
    }

    private boolean deleteFileRecursive(final File file) {
        boolean success = true;
        boolean isThere = true;
        boolean isDir = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = -6300662225018533428L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return file.isDirectory();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.JobExecutionLog$1", 1.class, null, null);
            }
        });
        if (!isDir) {
            isThere = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = 2903006115134192788L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return file.exists();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.JobExecutionLog$2", 2.class, null, null);
                }
            });
        }
        if (isDir) {
            File[] children;
            for (File f : children = AccessController.doPrivileged(new PrivilegedAction<File[]>(){
                static final long serialVersionUID = 5234201061367220146L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public File[] run() {
                    return file.listFiles();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.JobExecutionLog$3", 3.class, null, null);
                }
            })) {
                success = success && this.deleteFileRecursive(f);
            }
        }
        if (success && isThere) {
            success = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = 802439886780289486L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    return file.delete();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.JobExecutionLog$4", 4.class, null, null);
                }
            });
        }
        return success;
    }

    public HashSet<String> getRemotePartitionEndpointURLs() {
        HashSet<String> retMe = new HashSet<String>();
        for (RemotePartitionLog partitionLog : this.getRemotePartitionLogs()) {
            retMe.add(partitionLog.getRemotePartition().getRestUrl());
        }
        return retMe;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.JobExecutionLog", JobExecutionLog.class, null, null);
    }

    public static enum LogLocalState {
        NOT_LOCAL,
        EXECUTION_LOCAL,
        PARTITION_LOCAL;

    }
}

