/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.rest;

import com.ibm.ws.jbatch.utility.http.Base64Coder;
import com.ibm.ws.jbatch.utility.http.Response;
import com.ibm.ws.jbatch.utility.http.SimpleHttpClient;
import com.ibm.ws.jbatch.utility.rest.JobExecutionListMessageBodyReader;
import com.ibm.ws.jbatch.utility.rest.JobExecutionMessageBodyReader;
import com.ibm.ws.jbatch.utility.rest.JobInstanceListMessageBodyReader;
import com.ibm.ws.jbatch.utility.rest.JobInstanceMessageBodyReader;
import com.ibm.ws.jbatch.utility.rest.JobRestart;
import com.ibm.ws.jbatch.utility.rest.JobRestartMessageBodyWriter;
import com.ibm.ws.jbatch.utility.rest.JobSubmission;
import com.ibm.ws.jbatch.utility.rest.JobSubmissionMessageBodyWriter;
import com.ibm.ws.jbatch.utility.rest.PurgeResponseMessageBodyReader;
import com.ibm.ws.jbatch.utility.rest.WSPurgeResponse;
import com.ibm.ws.jbatch.utility.utils.ResourceBundleUtils;
import com.ibm.ws.jbatch.utility.utils.StringUtils;
import com.ibm.ws.jbatch.utility.utils.TaskIO;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;

public class BatchRestClient {
    private Set<String> targets = new LinkedHashSet<String>();
    private Iterator<String> targetIterator;
    private String currentTarget;
    private String user;
    private String pass;
    private int httpTimeout_ms = 0;
    private boolean reusePreviousParams = false;
    private TaskIO taskIO;

    public BatchRestClient(List<String> targets) {
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("Target list cannot be empty: " + targets);
        }
        this.targets.addAll(targets);
        this.targetIterator = this.targets.iterator();
        this.setCurrentTarget(this.targetIterator.next());
    }

    public BatchRestClient setTaskIO(TaskIO taskIO) {
        this.taskIO = taskIO;
        return this;
    }

    protected TaskIO getTaskIO() {
        return this.taskIO;
    }

    protected Iterator<String> getTargetIterator() {
        return this.targetIterator;
    }

    protected String getCurrentTarget() {
        return this.currentTarget;
    }

    protected BatchRestClient setCurrentTarget(String target) {
        this.currentTarget = target;
        return this;
    }

    protected String getCurrentTargetUrl() {
        return "https://" + this.getCurrentTarget();
    }

    protected String getBatchRestContext() {
        return "ibm/api/batch";
    }

    protected String getBatchRestContext_V2() {
        return "ibm/api/batch/v2";
    }

    public BatchRestClient setAuthorization(String user, String pass) {
        this.user = user;
        this.pass = pass;
        return this;
    }

    protected String getPassword() {
        if (this.pass == null) {
            this.pass = StringUtils.firstNonNull(this.getTaskIO().promptForMaskedInput("Password: "), "");
        }
        return this.pass;
    }

    protected String getAuthorizationHeader() {
        return StringUtils.isEmpty(this.user) ? null : "Basic " + Base64Coder.base64Encode(this.user + ":" + this.getPassword());
    }

    public BatchRestClient setHttpTimeout(int httpTimeout_ms) {
        this.httpTimeout_ms = httpTimeout_ms;
        return this;
    }

    protected int getHttpTimeout() {
        return this.httpTimeout_ms;
    }

    public BatchRestClient setReusePreviousParams(boolean reusePreviousParams) {
        this.reusePreviousParams = reusePreviousParams;
        return this;
    }

    protected boolean getReusePreviousParams() {
        return this.reusePreviousParams;
    }

    public JobInstance start(final String applicationName, final String moduleName, final String componentName, final String jobXMLName, final Properties jobParameters, final String jobXMLFile) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext()).path("jobinstances").header("Accept", "application/json").header("Content-Type", "application/json; charset=utf-8").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).post(new JobSubmissionMessageBodyWriter(new JobSubmission(applicationName, moduleName, componentName, jobXMLName, jobParameters, jobXMLFile)));
            }
        }).readEntity(new JobInstanceMessageBodyReader());
    }

    public List<JobExecution> getJobExecutions(JobInstance jobInstance) throws IOException {
        return this.getJobExecutions(jobInstance.getInstanceId());
    }

    public List<JobExecution> getJobExecutions(final long jobInstanceId) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext()).path("jobinstances").path(String.valueOf(jobInstanceId)).path("jobexecutions").header("Accept", "application/json").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).get();
            }
        }).readEntity(new JobExecutionListMessageBodyReader());
    }

    public JobExecution getJobExecution(final long jobExecutionId) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext()).path("jobexecutions").path(String.valueOf(jobExecutionId)).header("Accept", "application/json").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).get();
            }
        }).readEntity(new JobExecutionMessageBodyReader());
    }

    public JobInstance restartJobExecution(final long jobExecutionId, final Properties jobParameters) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext()).path("jobexecutions").path(String.valueOf(jobExecutionId)).queryParam("action", "restart").queryParam("reusePreviousParams", String.valueOf(BatchRestClient.this.getReusePreviousParams())).header("Accept", "application/json").header("Content-Type", "application/json; charset=utf-8").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).put(new JobRestartMessageBodyWriter(new JobRestart(jobParameters)));
            }
        }).readEntity(new JobInstanceMessageBodyReader());
    }

    public JobInstance restartJobInstance(final long jobInstanceId, final Properties jobParameters) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext()).path("jobinstances").path(String.valueOf(jobInstanceId)).queryParam("action", "restart").queryParam("reusePreviousParams", String.valueOf(BatchRestClient.this.getReusePreviousParams())).header("Accept", "application/json").header("Content-Type", "application/json; charset=utf-8").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).put(new JobRestartMessageBodyWriter(new JobRestart(jobParameters)));
            }
        }).readEntity(new JobInstanceMessageBodyReader());
    }

    public JobInstance getJobInstance(final long jobInstanceId) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext()).path("jobinstances").path(String.valueOf(jobInstanceId)).header("Accept", "application/json").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).get();
            }
        }).readEntity(new JobInstanceMessageBodyReader());
    }

    public JobInstance getJobInstanceForJobExecution(final long jobExecutionId) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext()).path("jobexecutions").path(String.valueOf(jobExecutionId)).path("jobinstance").header("Accept", "application/json").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).get();
            }
        }).readEntity(new JobInstanceMessageBodyReader());
    }

    public List<JobInstance> getJobInstances(final int page, final int pageSize) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext()).path("jobinstances").queryParam("page", String.valueOf(page)).queryParam("pageSize", String.valueOf(pageSize)).header("Accept", "application/json").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).get();
            }
        }).readEntity(new JobInstanceListMessageBodyReader());
    }

    public List<JobInstance> getJobInstances(final int page, final int pageSize, final String instanceId, final String createTime, final String instanceState, final String exitStatus) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext_V2()).path("jobinstances").queryParamNotNullOrEmpty("jobInstanceId", instanceId).queryParamNotNullOrEmpty("createTime", createTime).queryParamNotNullOrEmpty("instanceState", instanceState).queryParamNotNullOrEmpty("exitStatus", exitStatus).queryParam("page", String.valueOf(page)).queryParam("pageSize", String.valueOf(pageSize)).header("Accept", "application/json").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).get();
            }
        }).readEntity(new JobInstanceListMessageBodyReader());
    }

    public JobExecution stop(final long jobExecutionId) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext()).path("jobexecutions").path(String.valueOf(jobExecutionId)).queryParam("action", "stop").queryParam("permitRedirect", "true").header("Accept", "application/json").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).put(null);
            }
        }).readEntity(new JobExecutionMessageBodyReader());
    }

    public JobExecution stop(final JobInstance jobInstance) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext()).path("jobinstances").path(String.valueOf(jobInstance.getInstanceId())).queryParam("action", "stop").queryParam("permitRedirect", "true").header("Accept", "application/json").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).put(null);
            }
        }).readEntity(new JobExecutionMessageBodyReader());
    }

    public String buildJobLogsRestLink(JobInstance jobInstance, String type) {
        return this.getCurrentTargetUrl() + "/" + this.getBatchRestContext() + "/jobinstances/" + jobInstance.getInstanceId() + "/joblogs" + (StringUtils.isEmpty(type) ? "" : "?type=" + type);
    }

    public Response getJobLogsForJobInstance(final long jobInstanceId, final String type) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext()).path("jobinstances").path(String.valueOf(jobInstanceId)).path("joblogs").queryParam("type", type).queryParam("permitRedirect", "true").header("Accept", "application/zip, text/plain").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).get();
            }
        });
    }

    public Response getJobLogsForJobExecution(final long jobExecutionId, final String type) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext()).path("jobexecutions").path(String.valueOf(jobExecutionId)).path("joblogs").queryParam("type", type).queryParam("permitRedirect", "true").header("Accept", "application/zip, text/plain").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).get();
            }
        });
    }

    public Response purge(final long jobInstanceId, final boolean purgeJobStoreOnly) throws IOException {
        Response response = this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext()).path("jobinstances").path(String.valueOf(jobInstanceId)).queryParam("purgeJobStoreOnly", String.valueOf(purgeJobStoreOnly)).queryParam("permitRedirect", "true").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).delete();
            }
        });
        response.getInputStream();
        return response;
    }

    public List<WSPurgeResponse> purge(final boolean purgeJobStoreOnly, final int page, final int pageSize, final String instanceId, final String createTime, final String instanceState, final String exitStatus) throws IOException {
        return this.handleFailover(new Callable<Response>(){

            @Override
            public Response call() throws IOException {
                return new SimpleHttpClient().setTarget(BatchRestClient.this.getCurrentTargetUrl()).path(BatchRestClient.this.getBatchRestContext_V2()).path("jobinstances").queryParamNotNullOrEmpty("jobInstanceId", instanceId).queryParamNotNullOrEmpty("createTime", createTime).queryParamNotNullOrEmpty("instanceState", instanceState).queryParamNotNullOrEmpty("exitStatus", exitStatus).queryParam("page", String.valueOf(page)).queryParam("pageSize", String.valueOf(pageSize)).queryParam("purgeJobStoreOnly", String.valueOf(purgeJobStoreOnly)).queryParam("permitRedirect", "true").header("Accept", "application/json").header("Authorization", BatchRestClient.this.getAuthorizationHeader()).setTimeout(BatchRestClient.this.getHttpTimeout()).delete();
            }
        }).readEntity(new PurgeResponseMessageBodyReader());
    }

    /*
     * Loose catch block
     */
    protected <T> T handleFailover(Callable<T> callMe) throws IOException {
        while (true) {
            try {
                return callMe.call();
            }
            catch (IOException ioe) {
                if (this.getTargetIterator().hasNext() && this.isRetryable(ioe)) {
                    String prevTarget = this.getCurrentTarget();
                    this.setCurrentTarget(this.getTargetIterator().next());
                    this.getTaskIO().info(ResourceBundleUtils.getMessage("failover.to.next.target", prevTarget, this.getCurrentTarget(), ioe.getClass().getName() + ":" + ioe.getMessage()));
                    continue;
                }
                throw ioe;
            }
            break;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isRetryable(IOException e) {
        return true;
    }
}

