/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.trace.propagation;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.extension.trace.propagation.Common;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class OtTracePropagator
implements TextMapPropagator {
    static final String TRACE_ID_HEADER = "ot-tracer-traceid";
    static final String SPAN_ID_HEADER = "ot-tracer-spanid";
    static final String SAMPLED_HEADER = "ot-tracer-sampled";
    static final String PREFIX_BAGGAGE_HEADER = "ot-baggage-";
    private static final Collection<String> FIELDS = Collections.unmodifiableList(Arrays.asList("ot-tracer-traceid", "ot-tracer-spanid", "ot-tracer-sampled"));
    private static final OtTracePropagator INSTANCE = new OtTracePropagator();

    private OtTracePropagator() {
    }

    public static OtTracePropagator getInstance() {
        return INSTANCE;
    }

    @Override
    public Collection<String> fields() {
        return FIELDS;
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        if (context == null || setter == null) {
            return;
        }
        SpanContext spanContext = Span.fromContext(context).getSpanContext();
        if (!spanContext.isValid()) {
            return;
        }
        setter.set(carrier, TRACE_ID_HEADER, spanContext.getTraceId().substring(TraceId.getLength() / 2));
        setter.set(carrier, SPAN_ID_HEADER, spanContext.getSpanId());
        setter.set(carrier, SAMPLED_HEADER, String.valueOf(spanContext.isSampled()));
        Baggage baggage = Baggage.fromContext(context);
        if (!baggage.isEmpty()) {
            baggage.forEach((key, baggageEntry) -> setter.set(carrier, PREFIX_BAGGAGE_HEADER + key, baggageEntry.getValue()));
        }
    }

    @Override
    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        String sampled;
        String spanId;
        if (context == null) {
            return Context.root();
        }
        if (getter == null) {
            return context;
        }
        String incomingTraceId = getter.get(carrier, TRACE_ID_HEADER);
        String traceId = incomingTraceId == null ? TraceId.getInvalid() : StringUtils.padLeft(incomingTraceId, Common.MAX_TRACE_ID_LENGTH);
        SpanContext spanContext = OtTracePropagator.buildSpanContext(traceId, spanId = getter.get(carrier, SPAN_ID_HEADER), sampled = getter.get(carrier, SAMPLED_HEADER));
        if (!spanContext.isValid()) {
            return context;
        }
        Context extractedContext = context.with(Span.wrap(spanContext));
        if (carrier != null) {
            BaggageBuilder baggageBuilder = Baggage.builder();
            for (String key : getter.keys(carrier)) {
                String value;
                String lowercaseKey = key.toLowerCase(Locale.ROOT);
                if (!lowercaseKey.startsWith(PREFIX_BAGGAGE_HEADER) || (value = getter.get(carrier, key)) == null) continue;
                String baggageKey = lowercaseKey.substring(PREFIX_BAGGAGE_HEADER.length());
                baggageBuilder.put(baggageKey, value);
            }
            Baggage baggage = baggageBuilder.build();
            if (!baggage.isEmpty()) {
                extractedContext = extractedContext.with(baggage);
            }
        }
        return extractedContext;
    }

    private static SpanContext buildSpanContext(@Nullable String traceId, @Nullable String spanId, @Nullable String sampled) {
        if (!Common.isTraceIdValid(traceId) || !Common.isSpanIdValid(spanId)) {
            return SpanContext.getInvalid();
        }
        return Common.buildSpanContext(traceId, spanId, sampled);
    }

    public String toString() {
        return "OtTracePropagator";
    }
}

