/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.Cache;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.impl.KnownSamlUrl;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.internal.utils.ForwardRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import com.ibm.ws.webcontainer.internalRuntimeExport.srt.IPrivateRequestAttributes;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RequestUtil
extends KnownSamlUrl {
    private static final TraceComponent tc = Tr.register(RequestUtil.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static SimpleDateFormat cookieDateFormater = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz");
    static final long serialVersionUID = 8076635822516211212L;

    public static void cacheRequestInfo(String requestId, SsoSamlService ssoService, HttpRequestInfo requestInfo) {
        Cache cache = ssoService.getAcsCookieCache(ssoService.getProviderId());
        cache.put(requestId, (Object)requestInfo);
    }

    public static String getAcsUrl(HttpServletRequest req, String samlCtxPath, String acsProviderId, SsoConfig samlConfig) {
        String urlContextPath = RequestUtil.getCtxRootUrl(req, samlCtxPath, samlConfig);
        return urlContextPath + acsProviderId + "/acs";
    }

    public static String getSloUrl(HttpServletRequest req, String samlCtxPath, String spId, SsoConfig samlConfig) {
        String urlContextPath = RequestUtil.getCtxRootUrl(req, samlCtxPath, samlConfig);
        return urlContextPath + spId + "/slo";
    }

    public static String getEntityUrl(HttpServletRequest req, String samlCtxPath, String acsProviderId, SsoConfig samlConfig) {
        String urlContextPath = RequestUtil.getCtxRootUrl(req, samlCtxPath, samlConfig);
        return urlContextPath + acsProviderId;
    }

    public static String getCtxRootUrl(HttpServletRequest req, String samlCtxPath, SsoConfig samlConfig) {
        String spHostAndPort;
        String string = spHostAndPort = samlConfig == null ? null : samlConfig.getSpHostAndPort();
        if (spHostAndPort != null && !spHostAndPort.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("spHostAndPort is:" + spHostAndPort), (Object[])new Object[0]);
            }
            if (spHostAndPort.startsWith("http")) {
                return spHostAndPort + samlCtxPath;
            }
            return "https://" + spHostAndPort + samlCtxPath;
        }
        String hostName = req.getServerName();
        Integer httpsPort = RequestUtil.getRedirectPortFromRequest(req);
        if (httpsPort == null && req.isSecure()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The redirect SSL port is null from request. Trying to get http port", (Object[])new Object[0]);
            }
            int port = req.getServerPort();
            String httpSchema = req.getScheme();
            return httpSchema + "://" + hostName + (port > 0 && port != 443 ? ":" + port : "") + samlCtxPath;
        }
        return "https://" + hostName + (httpsPort == null ? "" : ":" + httpsPort) + samlCtxPath;
    }

    protected static Integer getRedirectPortFromRequest(HttpServletRequest req) {
        HttpServletRequest sr = RequestUtil.getWrappedServletRequestObject(req);
        if (sr instanceof IPrivateRequestAttributes) {
            return (Integer)((IPrivateRequestAttributes)sr).getPrivateAttribute("SecurityRedirectPort");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRedirectUrl called for non-IPrivateRequestAttributes object", (Object[])new Object[]{req});
        }
        return null;
    }

    static HttpServletRequest getWrappedServletRequestObject(HttpServletRequest sr) {
        if (sr instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper w = (HttpServletRequestWrapper)sr;
            sr = (HttpServletRequest)w.getRequest();
            while (sr instanceof HttpServletRequestWrapper) {
                sr = (HttpServletRequest)((HttpServletRequestWrapper)sr).getRequest();
            }
        }
        return sr;
    }

    public static void createCookie(HttpServletRequest req, HttpServletResponse response, String cookieName, String cookieValue) {
        WebAppSecurityConfig webAppSecurityConfig = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
        ReferrerURLCookieHandler referrerURLCookieHandler = webAppSecurityConfig.createReferrerURLCookieHandler();
        Cookie c = referrerURLCookieHandler.createCookie(cookieName, cookieValue, req);
        response.addCookie(c);
    }

    public static void createCookie(HttpServletRequest req, HttpServletResponse response, String cookieName, String cookieValue, int maxAge) {
        WebAppSecurityConfig webAppSecurityConfig = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
        ReferrerURLCookieHandler referrerURLCookieHandler = webAppSecurityConfig.createReferrerURLCookieHandler();
        Cookie c = referrerURLCookieHandler.createCookie(cookieName, cookieValue, req);
        c.setMaxAge(maxAge);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cookie " + cookieName + ", expires in " + c.getMaxAge() + " seconds"), (Object[])new Object[0]);
        }
        response.addCookie(c);
    }

    public static void removeCookie(HttpServletRequest req, HttpServletResponse response, String cookieName) {
        WebAppSecurityConfig webAppSecurityConfig = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
        if (webAppSecurityConfig != null) {
            ReferrerURLCookieHandler referrerURLCookieHandler = webAppSecurityConfig.createReferrerURLCookieHandler();
            Cookie c = referrerURLCookieHandler.createCookie(cookieName, "", req);
            c.setMaxAge(0);
            response.addCookie(c);
        }
    }

    public static String getCookieId(IExtendedRequest req, HttpServletResponse res, String cookieName) throws SamlException {
        byte[] cookieValueBytes = req.getCookieValueAsBytes(cookieName);
        if (cookieValueBytes == null || cookieValueBytes.length == 0) {
            return null;
        }
        return new String(cookieValueBytes, StandardCharsets.UTF_8);
    }

    public static String convertBytesToString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @FFDCIgnore(value={SamlException.class})
    public static Credential getDecryptingCredential(SsoSamlService ssoService) throws SamlException {
        BasicX509Credential credential = null;
        try {
            PrivateKey privateKey = ssoService.getPrivateKey();
            if (privateKey == null) {
                throw new SamlException("SAML20_NO_PRIVATE_KEY", null, true, new Object[]{ssoService.getProviderId(), ssoService.getConfig().getKeyStoreRef()});
            }
            Certificate certificate = ssoService.getSignatureCertificate();
            if (certificate == null) {
                throw new SamlException("SAML20_NO_CERT", null, true, new Object[]{ssoService.getProviderId(), ssoService.getConfig().getKeyStoreRef()});
            }
            credential = new BasicX509Credential((X509Certificate)certificate);
            credential.setPrivateKey(privateKey);
        }
        catch (SamlException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil", (String)"233", null, (Object[])new Object[]{ssoService});
            throw new SamlException(e);
        }
        return credential;
    }

    @FFDCIgnore(value={SamlException.class})
    public static Credential getSigningCredential(SsoSamlService ssoService) throws SamlException {
        BasicX509Credential credential = null;
        try {
            PrivateKey privateKey = ssoService.getPrivateKey();
            if (privateKey == null) {
                throw new SamlException("SAML20_NO_PRIVATE_KEY", null, true, new Object[]{ssoService.getProviderId(), ssoService.getConfig().getKeyStoreRef()});
            }
            Certificate certificate = ssoService.getSignatureCertificate();
            if (certificate == null) {
                throw new SamlException("SAML20_NO_CERT", null, true, new Object[]{ssoService.getProviderId(), ssoService.getConfig().getKeyStoreRef()});
            }
            credential = new BasicX509Credential((X509Certificate)certificate);
            credential.setPrivateKey(privateKey);
        }
        catch (SamlException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil", (String)"264", null, (Object[])new Object[]{ssoService});
            throw new SamlException(e);
        }
        return credential;
    }

    public static void validateInResponseTo(BasicMessageContext<?, ?> context, String inResponseTo) throws SamlException {
        HttpRequestInfo requestInfo = context.getCachedRequestInfo();
        String externalRelayState = context.getExternalRelayState();
        if (requestInfo == null) {
            if (inResponseTo != null && !inResponseTo.isEmpty()) {
                throw new SamlException("SAML20_SP_UNSOLICITED_WITH_IN_RESPONSE_TO", null, new Object[]{inResponseTo});
            }
        } else {
            String inResponseToId = requestInfo.getInResponseToId();
            if (!ForwardRequestInfo.safeCompare(inResponseTo, inResponseToId)) {
                throw new SamlException("SAML20_NO_INRESPONSETO", null, new Object[]{externalRelayState, inResponseTo, inResponseToId});
            }
        }
    }

    public static SsoRequest setSamlRequest(HttpServletRequest req, SsoSamlService samlService, Constants.EndpointType type) {
        SsoRequest samlRequest = new SsoRequest(samlService.getProviderId(), type, req, Constants.SamlSsoVersion.SAMLSSO20, samlService);
        req.setAttribute("Saml20Request", (Object)samlRequest);
        return samlRequest;
    }

    public static String getUserName(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<Principal> principals = subject.getPrincipals();
        Iterator<Principal> principalsIterator = principals.iterator();
        if (principalsIterator.hasNext()) {
            Principal principal = principalsIterator.next();
            return principal.getName();
        }
        return null;
    }

    public static boolean isUnprotectedUrlForSaml(HttpServletRequest request) {
        String ctxPath = request.getContextPath();
        if ("/IBMJMXConnectorREST".equals(ctxPath)) {
            return true;
        }
        return RequestUtil.isSamlUnprotectedUrl(request, ctxPath);
    }

    static boolean isSamlUnprotectedUrl(HttpServletRequest request, String ctxPath) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Context path:" + ctxPath), (Object[])new Object[0]);
        }
        if (RequestUtil.isLogoutRequestFromIdP(request, ctxPath)) {
            return false;
        }
        return "/ibm/saml20".equals(ctxPath);
    }

    public static boolean isLogoutRequestFromIdP(HttpServletRequest request, String ctxPath) {
        return "/ibm/saml20".equals(ctxPath) && request.getRequestURI().endsWith("/slo") && request.getParameter("SAMLRequest") != null;
    }

    public static boolean isUnprocessedAcsCookiePresent(ConcurrentServiceReferenceMap<String, SsoSamlService> ssoSamlServiceRef, IExtendedRequest req, SsoRequest samlRequest) {
        String spProviderId = samlRequest.getProviderName();
        String acsCookieValue = RequestUtil.getAcsCookieValueFromRequest(req, spProviderId);
        if (acsCookieValue != null && !acsCookieValue.isEmpty()) {
            return RequestUtil.isAcsCookieInCache(ssoSamlServiceRef, spProviderId, acsCookieValue);
        }
        return false;
    }

    public static String getAcsCookieValueFromRequest(IExtendedRequest req, String spProviderId) {
        String cookieName = "WASSamlACS_" + SamlUtil.hash(spProviderId);
        byte[] cookieValueBytes = req.getCookieValueAsBytes(cookieName);
        if (cookieValueBytes != null) {
            return RequestUtil.convertBytesToString(cookieValueBytes);
        }
        return null;
    }

    static boolean isAcsCookieInCache(ConcurrentServiceReferenceMap<String, SsoSamlService> ssoSamlServiceRef, String spProviderId, String acsCookieValue) {
        Cache cache = RequestUtil.getAcsCookieCacheForProvider(ssoSamlServiceRef, spProviderId);
        if (cache == null) {
            return false;
        }
        return cache.get(acsCookieValue) != null;
    }

    public static Cache getAcsCookieCacheForProvider(ConcurrentServiceReferenceMap<String, SsoSamlService> ssoSamlServiceRef, String spProviderId) {
        SsoSamlService samlService = (SsoSamlService)ssoSamlServiceRef.getService((Object)spProviderId);
        if (samlService != null) {
            return samlService.getAcsCookieCache(spProviderId);
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        cookieDateFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

