/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.messaging.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.security.httpclient.HttpClientSecurityConfiguration;
import org.opensaml.security.httpclient.HttpClientSecurityConfigurationCriterion;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecurityParametersResolver;
import org.opensaml.security.httpclient.TLSCriteriaSetCriterion;
import org.opensaml.security.httpclient.impl.BasicHttpClientSecurityConfiguration;
import org.opensaml.security.messaging.HttpClientSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateHttpClientSecurityParametersHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateHttpClientSecurityParametersHandler.class);
    @Nonnull
    private Function<MessageContext, HttpClientSecurityContext> securityParametersContextLookupStrategy = new ChildContextLookup(HttpClientSecurityContext.class, true);
    @Nullable
    private Function<MessageContext, HttpClientSecurityContext> existingParametersContextLookupStrategy;
    @NonnullAfterInit
    private Function<MessageContext, List<HttpClientSecurityConfiguration>> configurationLookupStrategy;
    @NonnullAfterInit
    private HttpClientSecurityParametersResolver resolver;
    @Nullable
    private Predicate<MessageContext> clientTLSPredicate;

    public void setClientTLSPredicate(@Nullable Predicate<MessageContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.clientTLSPredicate = predicate;
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<MessageContext, HttpClientSecurityContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"HttpClientSecurityContext lookup strategy cannot be null");
    }

    public void setExistingParametersContextLookupStrategy(@Nullable Function<MessageContext, HttpClientSecurityContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.existingParametersContextLookupStrategy = strategy;
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<MessageContext, List<HttpClientSecurityConfiguration>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"HttpClientSecurityConfiguration lookup strategy cannot be null");
    }

    public void setHttpClientSecurityParametersResolver(@Nonnull HttpClientSecurityParametersResolver newResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver = (HttpClientSecurityParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"HttpClientSecurityParametersResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("HttpClientSecurityParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<MessageContext, List<HttpClientSecurityConfiguration>>(){

                public List<HttpClientSecurityConfiguration> apply(MessageContext input) {
                    return Collections.singletonList(new BasicHttpClientSecurityConfiguration());
                }
            };
        }
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (super.doPreInvoke(messageContext)) {
            this.log.debug("{} HttpClientSecurityParameters resolution and population enabled", (Object)this.getLogPrefix());
            return true;
        }
        this.log.debug("{} HttpClientSecurityParameters resolution and population not enabled", (Object)this.getLogPrefix());
        return false;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        CriteriaSet tlsCriteriaSet;
        HttpClientSecurityContext existingCtx;
        this.log.debug("{} Resolving HttpClientSecurityParameters for request", (Object)this.getLogPrefix());
        HttpClientSecurityContext paramsCtx = (HttpClientSecurityContext)((Object)this.securityParametersContextLookupStrategy.apply((Object)messageContext));
        if (paramsCtx == null) {
            this.log.debug("{} No HttpClientSecurityContext returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No HttpClientSecurityContext returned by lookup strategy");
        }
        if (this.existingParametersContextLookupStrategy != null && (existingCtx = (HttpClientSecurityContext)((Object)this.existingParametersContextLookupStrategy.apply((Object)messageContext))) != null && existingCtx.getSecurityParameters() != null) {
            this.log.debug("{} Found existing HttpClientSecurityContext to copy from", (Object)this.getLogPrefix());
            paramsCtx.setSecurityParameters(existingCtx.getSecurityParameters());
            return;
        }
        List configs = (List)this.configurationLookupStrategy.apply((Object)messageContext);
        if (configs == null || configs.isEmpty()) {
            this.log.error("{} No HttpClientSecurityConfiguration returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No HttpClientSecurityConfiguration returned by lookup strategy");
        }
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new HttpClientSecurityConfigurationCriterion(configs)});
        if (paramsCtx.getTLSCriteriaSetStrategy() != null && (tlsCriteriaSet = (CriteriaSet)paramsCtx.getTLSCriteriaSetStrategy().apply((Object)messageContext)) != null) {
            criteria.add((Object)new TLSCriteriaSetCriterion(tlsCriteriaSet));
        }
        try {
            HttpClientSecurityParameters params = (HttpClientSecurityParameters)this.resolver.resolveSingle(criteria);
            this.postProcessParams(messageContext, params);
            paramsCtx.setSecurityParameters(params);
            this.log.debug("{} {} HttpClientSecurityParameters", (Object)this.getLogPrefix(), (Object)(params != null ? "Resolved" : "Failed to resolve"));
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving HttpClientSecurityParameters", (Object)this.getLogPrefix(), (Object)e);
            throw new MessageHandlerException("Error resolving HttpClientSecurityParameters", (Exception)((Object)e));
        }
    }

    protected void postProcessParams(@Nonnull MessageContext messageContext, @Nonnull HttpClientSecurityParameters params) {
        if (this.clientTLSPredicate != null) {
            if (!this.clientTLSPredicate.apply((Object)messageContext)) {
                this.log.debug("Configured client TLS predicate indicates to exclude client TLS credential");
                params.setClientTLSCredential(null);
            } else if (params.getClientTLSCredential() == null) {
                this.log.warn("Configured client TLS predicate indicates to include client TLS credential, but no client TLS credential was present in resolved parameters");
            }
        }
    }
}

