/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl;

import io.smallrye.graphql.client.typesafe.api.AuthorizationHeader;
import io.smallrye.graphql.client.typesafe.api.GraphQlClientApi;
import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.api.Header;
import io.smallrye.graphql.client.typesafe.impl.CollectionUtils;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInvocation;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodResolver;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import jakarta.ws.rs.core.MultivaluedMap;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Base64;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class HeaderBuilder {
    private final Class<?> api;
    private final MethodInvocation method;
    private static final Config CONFIG = ConfigProvider.getConfig();

    public HeaderBuilder(Class<?> api, MethodInvocation method) {
        this.api = api;
        this.method = method;
    }

    public MultivaluedMap<String, Object> build() {
        MultivaluedMap headers = this.method.getResolvedAnnotations(this.api, Header.class).map(header -> new AbstractMap.SimpleEntry<String, Object>(header.name(), this.resolveValue((Header)header))).collect(CollectionUtils.toMultivaluedMap());
        this.method.headerParameters().forEach(parameter -> {
            Header header = ((Header[])parameter.getAnnotations(Header.class))[0];
            headers.add((Object)header.name(), parameter.getValue());
        });
        this.method.getResolvedAnnotations(this.api, AuthorizationHeader.class).findFirst().map(header -> this.resolveAuthHeader(this.method.getDeclaringType(), (AuthorizationHeader)header)).ifPresent(auth -> headers.add((Object)"Authorization", auth));
        return headers;
    }

    private Object resolveValue(Header header) {
        if (!header.method().isEmpty()) {
            if (!header.constant().isEmpty()) {
                throw new GraphQlClientException("Header with 'method' AND 'constant' not allowed: " + header);
            }
            return this.resolveMethodValue(header.method());
        }
        if (header.constant().isEmpty()) {
            throw new GraphQlClientException("Header must have either 'method' XOR 'constant': " + header);
        }
        return header.constant();
    }

    private Object resolveMethodValue(String methodName) {
        TypeInfo declaringType = this.method.getDeclaringType();
        MethodInvocation method = new MethodResolver(declaringType, methodName).resolve();
        if (!method.isStatic()) {
            throw new GraphQlClientException("referenced header method '" + methodName + "' in " + declaringType.getTypeName() + " is not static");
        }
        try {
            return method.invoke(null, new Object[0]).toString();
        }
        catch (RuntimeException e) {
            if (e instanceof GraphQlClientException) {
                throw e;
            }
            throw new GraphQlClientException("can't resolve header method expression '" + methodName + "' in " + declaringType.getTypeName(), e);
        }
    }

    private String resolveAuthHeader(TypeInfo declaringType, AuthorizationHeader header) {
        if (header.confPrefix().isEmpty()) {
            return HeaderBuilder.auth(header.type(), declaringType.getRawType());
        }
        return HeaderBuilder.auth(header.type(), header.confPrefix());
    }

    private static String auth(AuthorizationHeader.Type type, Class<?> api) {
        return HeaderBuilder.auth(type, HeaderBuilder.configKey(api));
    }

    private static String configKey(Class<?> api) {
        GraphQlClientApi annotation = api.getAnnotation(GraphQlClientApi.class);
        if (annotation == null || annotation.configKey().isEmpty()) {
            return api.getName();
        }
        return annotation.configKey();
    }

    private static String auth(AuthorizationHeader.Type type, String configKey) {
        String prefix = configKey.endsWith("*") ? configKey.substring(0, configKey.length() - 1) : configKey + "/mp-graphql/";
        switch (type) {
            case BASIC: {
                return HeaderBuilder.basic(prefix);
            }
            case BEARER: {
                return HeaderBuilder.bearer(prefix);
            }
        }
        throw new UnsupportedOperationException("unreachable");
    }

    private static String basic(String prefix) {
        String username = (String)CONFIG.getValue(prefix + "username", String.class);
        String password = (String)CONFIG.getValue(prefix + "password", String.class);
        String token = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8));
    }

    private static String bearer(String prefix) {
        return "Bearer " + (String)CONFIG.getValue(prefix + "bearer", String.class);
    }
}

