/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.privilizer;

import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.weaver.privilizer.AccessLevel;
import org.apache.commons.weaver.privilizer.ActionGenerator;
import org.apache.commons.weaver.privilizer.InlineNestedPrivilegedCalls;
import org.apache.commons.weaver.privilizer.Policy;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizer;
import org.apache.commons.weaver.privilizer._asm.AnnotationVisitor;
import org.apache.commons.weaver.privilizer._asm.ClassVisitor;
import org.apache.commons.weaver.privilizer._asm.FieldVisitor;
import org.apache.commons.weaver.privilizer._asm.Label;
import org.apache.commons.weaver.privilizer._asm.MethodVisitor;
import org.apache.commons.weaver.privilizer._asm.Type;
import org.apache.commons.weaver.privilizer._asm.commons.GeneratorAdapter;
import org.apache.commons.weaver.privilizer._asm.commons.Method;
import org.apache.commons.weaver.privilizer._asm.commons.StaticInitMerger;
import org.apache.commons.weaver.privilizer._lang3.ArrayUtils;

class PrivilizingVisitor
extends Privilizer.PrivilizerClassVisitor {
    final Map<Method, String> privilegedMethods = new LinkedHashMap<Method, String>();
    boolean annotated;
    final Policy policy;
    final AccessLevel accessLevel;

    PrivilizingVisitor(Privilizer privilizer, ClassVisitor cv) {
        this.policy = privilizer.policy;
        this.accessLevel = privilizer.accessLevel;
        this.cv = new InlineNestedPrivilegedCalls(privilizer, this.privilegedMethods, new StaticInitMerger(privilizer.generateName("clinit"), cv));
    }

    private void annotate() {
        if (!this.annotated) {
            this.annotated = true;
            AnnotationVisitor privilizedVisitor = super.visitAnnotation(Type.getType(Privilized.class).getDescriptor(), false);
            privilizedVisitor.visit("value", this.policy.name());
            privilizedVisitor.visitEnd();
        }
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.annotate();
        super.visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.annotate();
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(final int access, final String name, final String desc, final String signature, final String[] exceptions) {
        this.annotate();
        MethodVisitor originalMethod = super.visitMethod(access, name, desc, signature, exceptions);
        final Method methd = new Method(name, desc);
        return new GeneratorAdapter(327680, originalMethod, access, name, desc){

            @Override
            public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                if (Type.getType(Privileged.class).getDescriptor().equals(desc2)) {
                    AccessLevel localAccessLevel = AccessLevel.of(access);
                    if (PrivilizingVisitor.this.accessLevel.compareTo(localAccessLevel) > 0) {
                        throw new RuntimeException(new IllegalAccessException("Method " + PrivilizingVisitor.this.className + "#" + methd + " must have maximum access level '" + (Object)((Object)PrivilizingVisitor.this.accessLevel) + "' but is defined wider ('" + (Object)((Object)localAccessLevel) + "')"));
                    }
                    if (AccessLevel.PACKAGE.compareTo(PrivilizingVisitor.this.accessLevel) > 0) {
                        PrivilizingVisitor.this.privilizer().env.warn("Possible security leak: granting privileges to %s method %s.%s", new Object[]{localAccessLevel, PrivilizingVisitor.this.className, methd});
                    }
                    PrivilizingVisitor.this.privilegedMethods.put(methd, PrivilizingVisitor.this.privilizer().generateName(name));
                }
                return super.visitAnnotation(desc2, visible);
            }

            @Override
            public void visitCode() {
                boolean instanceMethod;
                super.visitCode();
                if (!PrivilizingVisitor.this.privilegedMethods.containsKey(methd)) {
                    return;
                }
                String impl = PrivilizingVisitor.this.privilegedMethods.get(methd);
                boolean bl = instanceMethod = !Modifier.isStatic(access);
                if (PrivilizingVisitor.this.policy.isConditional()) {
                    PrivilizingVisitor.this.privilizer().env.debug("setting up conditional execution due to policy %s", new Object[]{PrivilizingVisitor.this.policy});
                    if (PrivilizingVisitor.this.policy == Policy.ON_INIT) {
                        this.getStatic(PrivilizingVisitor.this.target, PrivilizingVisitor.this.privilizer().generateName("hasSecurityManager"), Type.BOOLEAN_TYPE);
                    } else if (PrivilizingVisitor.this.policy == Policy.DYNAMIC) {
                        PrivilizingVisitor.checkSecurityManager(this);
                    }
                    Label doPrivileged = new Label();
                    this.ifZCmp(154, doPrivileged);
                    Method implMethod = new Method(impl, desc);
                    if (instanceMethod) {
                        this.loadThis();
                        this.loadArgs();
                        this.invokeVirtual(PrivilizingVisitor.this.target, implMethod);
                    } else {
                        this.loadArgs();
                        this.invokeStatic(PrivilizingVisitor.this.target, implMethod);
                    }
                    this.returnValue();
                    this.mark(doPrivileged);
                } else {
                    PrivilizingVisitor.this.privilizer().env.debug("setting up unconditional privileged execution due to policy %s", new Object[]{PrivilizingVisitor.this.policy});
                }
                Type[] ctorArgs = instanceMethod ? ArrayUtils.add(methd.getArgumentTypes(), 0, PrivilizingVisitor.this.target) : methd.getArgumentTypes();
                Type actionType = new ActionGenerator(access, methd, exceptions, PrivilizingVisitor.this).build();
                this.newInstance(actionType);
                this.dup();
                if (instanceMethod) {
                    this.loadThis();
                }
                this.loadArgs();
                this.invokeConstructor(actionType, new Method("<init>", Type.VOID_TYPE, ctorArgs));
                boolean exc = ArrayUtils.isNotEmpty(exceptions);
                Label privTry = exc ? this.mark() : null;
                Type arg = exc ? Type.getType(PrivilegedExceptionAction.class) : Type.getType(PrivilegedAction.class);
                Method doPrivileged = new Method("doPrivileged", Type.getType(Object.class), new Type[]{arg});
                this.invokeStatic(Type.getType(AccessController.class), doPrivileged);
                this.unbox(methd.getReturnType());
                this.returnValue();
                if (exc) {
                    Type caught = Type.getType(PrivilegedActionException.class);
                    Label privCatch = this.mark();
                    this.catchException(privTry, privCatch, caught);
                    this.invokeVirtual(caught, new Method("getException", Type.getType(Exception.class), Privilizer.EMPTY_TYPE_ARRAY));
                    this.throwException();
                }
                this.endMethod();
                this.mv = PrivilizingVisitor.this.cv.visitMethod(AccessLevel.PRIVATE.merge(access), impl, desc, signature, exceptions);
                this.mv.visitCode();
            }
        };
    }

    @Override
    public void visitEnd() {
        this.annotate();
        if (this.privilizer().policy == Policy.ON_INIT) {
            String fieldName = this.privilizer().generateName("hasSecurityManager");
            this.visitField(26, fieldName, Type.BOOLEAN_TYPE.getDescriptor(), null, null).visitEnd();
            GeneratorAdapter mgen = new GeneratorAdapter(8, new Method("<clinit>", "()V"), null, Privilizer.EMPTY_TYPE_ARRAY, this);
            PrivilizingVisitor.checkSecurityManager(mgen);
            mgen.putStatic(this.target, fieldName, Type.BOOLEAN_TYPE);
            mgen.returnValue();
            mgen.endMethod();
        }
        super.visitEnd();
    }

    private static void checkSecurityManager(GeneratorAdapter mgen) {
        Label setFalse = new Label();
        Label done = new Label();
        mgen.invokeStatic(Type.getType(System.class), new Method("getSecurityManager", Type.getType(SecurityManager.class), Privilizer.EMPTY_TYPE_ARRAY));
        mgen.ifNull(setFalse);
        mgen.push(true);
        mgen.goTo(done);
        mgen.mark(setFalse);
        mgen.push(false);
        mgen.mark(done);
    }
}

